/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { HttpContextToken } from "@angular/common/http";
export var TOKEN;
(function (TOKEN) {
    TOKEN["ACCESS_KEY"] = "access.token";
    TOKEN["REFRESH_KEY"] = "refresh.token";
    TOKEN["RESTRICTED_KEY"] = "restricted.token";
})(TOKEN || (TOKEN = {}));
export var MMD;
(function (MMD) {
    MMD["MODEL_METADATAS_KEY"] = "model_metadatas";
    MMD["STAGING_METADATAS_KEY"] = "staging_model_metadatas";
    MMD["STAGING_ATTRIBUTE_METADATA_KEY"] = "attribute_metadatas";
    MMD["SYSTEM_MODEL_METADATAS_KEY"] = "system_model_metadatas";
    MMD["VIEW_TEMPLATES_KEY"] = "view_templates";
    MMD["WIDGET_CONFIG_KEY"] = "widget_configs";
})(MMD || (MMD = {}));
export const RESERVED_KEYWORDS = {
    PLAYBOOKS: ['items', 'result', 'input', 'request', 'values', 'keys', 'files', 'env', 'message', 'step_variables', 'do_until', 'ignore_errors', 'when', 'for_each', 'cyops_playbook_iri', 'cyops_playbook_name', 'collaborationNote', 'inputVariables', 'displayConditions'],
    MMD_FIELDS: ['id', 'recordtags', 'createUser', 'createdate', 'modifyUser', 'modifydate', 'owners', 'tenant']
};
export var VIEW_TEMPLATES;
(function (VIEW_TEMPLATES) {
    VIEW_TEMPLATES["GRID_COLUMNS"] = "grid_columns";
    VIEW_TEMPLATES["TYPE"] = "SystemViewTemplate";
    VIEW_TEMPLATES["CACHE_PREFIX"] = "views.";
    VIEW_TEMPLATES["VIEW_API_BASE"] = "/api/views/1/";
    VIEW_TEMPLATES["SYSTEM_VIEW_TEMPLATES_MODEL"] = "system_view_templates";
})(VIEW_TEMPLATES || (VIEW_TEMPLATES = {}));
export var API;
(function (API) {
    API["API"] = "api/";
    API["BASE"] = "api/3/";
    API["API_APPMANAGER"] = "api/appmanager/";
    API["DELETE_WITH_QUERY"] = "api/3/delete-with-query/";
    API["BULK_UPDATE"] = "api/3/update/";
    API["API_3_BASE"] = "api/3/";
    API["INSERT"] = "api/3/insert/";
    API["QUERY"] = "api/query/";
    API["SYSTEM_MODULES"] = "api/system/fixtures";
    API["CURRENT_ACTOR"] = "actors/current";
    API["AUTH"] = "api/auth/";
    API["DAS"] = "auth/";
    API["WEBSOCKET"] = "websocket/cyops-websocket";
    API["INTEGRATIONS"] = "api/integration/";
    API["INTEGRATION_CONFIGURATION"] = "api/integration/configuration/";
    API["WORKFLOW_ACTION"] = "xf/api/workflows/actions";
    API["PUBLIC"] = "api/public/";
    API["RULE"] = "api/rule/";
    API["WORKFLOW"] = "api/workflow/";
    API["WORKFLOW_GROUPS"] = "workflow_groups/";
    API["WORKFLOW_STEPS"] = "workflow_steps/";
    API["WORKFLOWS"] = "workflows/";
    API["USERS"] = "api/auth/users/";
    API["TEAMS"] = "api/auth/teams/";
    API["QUERY_PART"] = "query/";
    API["SEALAB"] = "api/workflow/";
    API["TEMP_WORKFLOWS"] = "wf/api/";
    API["EXPRESSIONS"] = "api/workflow/expressions/";
    API["LOGOUT"] = "token/logout/";
    API["SCHEDULE"] = "api/workflow/schedules/";
    API["AUDIT"] = "api/audit/";
    API["PORTER"] = "api/appmanager/";
    API["RULE_ENGINE"] = "api/rule-engine/";
})(API || (API = {}));
export const OPERATOR_MAPPINGS = {
    contains: 'icontains',
    notContains: 'nicontains',
    equals: 'eq',
    notEqual: 'neq',
    startsWith: 'istartswith',
    endsWith: 'iendswith',
    lessThan: 'lt',
    lessThanOrEqual: 'lte',
    greaterThan: 'gt',
    greaterThanOrEqual: 'gte',
    in: 'in'
};
export const ALL_RECORDS_SIZE = 2147483647;
export const DEFAULT_NEW_MODULE_PERMISSIONS = { create: false, read: false, update: false, delete: false, execute: false, fields: {} };
export const DEFAULT_REPO_URL = 'https://@product_yum_server@/';
export var STORAGE_KEYS;
(function (STORAGE_KEYS) {
    STORAGE_KEYS["LOCAL_STORAGE_PREFIX"] = "xf.";
    STORAGE_KEYS["LOCAL_STORAGE_PERSIST_PREFIX"] = "persist:";
    STORAGE_KEYS["CURRENT_USER"] = "current_user";
    STORAGE_KEYS["CURRENT_PERMISSIONS"] = "current_user.roles";
    STORAGE_KEYS["SETTINGS_HISTORY"] = "settings_history";
    STORAGE_KEYS["SETTINGS_ACCOUNT_CONFIG"] = "account_configuration";
    STORAGE_KEYS["SYSTEM_SETTINGS"] = "system_settings";
    STORAGE_KEYS["USER_PREFERENCES"] = "user_preferences";
    STORAGE_KEYS["AUDIT_PURGE_SETTINGS"] = "audit_purge_settings";
    STORAGE_KEYS["WF_PURGE_SETTINGS"] = "wf_purge_settings";
    STORAGE_KEYS["LICENSE_DETAILS"] = "license_details";
})(STORAGE_KEYS || (STORAGE_KEYS = {}));
export var AUTH;
(function (AUTH) {
    AUTH["TOKEN"] = "TOKEN";
})(AUTH || (AUTH = {}));
export var THEMES;
(function (THEMES) {
    THEMES["DEFAULT"] = "dark";
})(THEMES || (THEMES = {}));
export var FIXED_MODULE;
(function (FIXED_MODULE) {
    FIXED_MODULE["XF_QUEUES"] = "xf_queues";
    FIXED_MODULE["SHIFTS"] = "shifts";
    FIXED_MODULE["APPROVAL"] = "approvals";
    FIXED_MODULE["APPLICATION"] = "application";
    FIXED_MODULE["PLAYBOOK"] = "playbooks";
    FIXED_MODULE["PLAYBOOK_VERSIONS"] = "versions";
    FIXED_MODULE["PLAYBOOK_STEPS"] = "playbook-steps";
    FIXED_MODULE["EVENTS"] = "events";
    FIXED_MODULE["PLAYBOOK_COLLECTION"] = "playbook-collections";
    FIXED_MODULE["PEOPLE"] = "people";
    FIXED_MODULE["COMMENTS"] = "comments";
    FIXED_MODULE["TEAMS"] = "teams";
    FIXED_MODULE["ROLES"] = "roles";
    FIXED_MODULE["ROLE_SERVICES"] = "services";
    FIXED_MODULE["ROLE_ENTITIES"] = "entities";
    FIXED_MODULE["ROLE_PERMISSIONS"] = "permissions";
    FIXED_MODULE["USERS"] = "users";
    FIXED_MODULE["AUDIT_LOGS"] = "audit-logs";
    FIXED_MODULE["APPLIANCES"] = "appliances";
    FIXED_MODULE["SECURITY"] = "security";
    FIXED_MODULE["EXPORT_TEMPLATES"] = "export-templates";
    FIXED_MODULE["EXPORT_JOBS"] = "export-jobs";
    FIXED_MODULE["IMPORT_JOBS"] = "import-jobs";
    FIXED_MODULE["FILES"] = "files";
    FIXED_MODULE["PICKLIST_NAMES"] = "picklist_names";
    FIXED_MODULE["PICKLISTS"] = "picklists";
    FIXED_MODULE["LEGACY_SYSTEM_VIEW_TEMPLATE"] = "system_view_templates";
    FIXED_MODULE["WIDGET_METADATAS"] = "widget_metadatas";
    FIXED_MODULE["DYNAMIC_CONTENT"] = "dynamic_content";
    FIXED_MODULE["SETTINGS_CATEGORIES"] = "settings_categories";
    FIXED_MODULE["SETTINGS_LINKS"] = "settings_links";
    FIXED_MODULE["SETTINGS_PAGES"] = "settings_pages";
    FIXED_MODULE["SCHEDULES"] = "schedules";
    FIXED_MODULE["VIEW_TEMPLATES"] = "view-templates";
    FIXED_MODULE["WIDGET_CONFIGS"] = "widget-configs";
    FIXED_MODULE["AGENTS"] = "agents";
    FIXED_MODULE["WORKFLOW_LOGS"] = "workflow_logs";
    FIXED_MODULE["CONNECTORS"] = "connectors";
    FIXED_MODULE["GLOBAL_VARIABLES"] = "global-variables";
    FIXED_MODULE["RULE"] = "rules";
    FIXED_MODULE["CHANNEL"] = "channels";
    FIXED_MODULE["PENDING_NOTIFICATION"] = "pending-notification";
    FIXED_MODULE["SYSTEM_NOTIFICATION"] = "system-notification";
    FIXED_MODULE["SOLUTION_PACK"] = "solution-packs";
    FIXED_MODULE["WIDGETS"] = "widgets";
    FIXED_MODULE["PLAYBOOK_EXECUTION_LOGS"] = "playbook-execution-logs";
    FIXED_MODULE["CONNECTOR_CONFIGURATIONS"] = "connector-configurations";
    FIXED_MODULE["REFERENCE_BLOCKS"] = "reference-blocks";
    FIXED_MODULE["CONTENT_HUB"] = "contenthub";
    FIXED_MODULE["DASHBOARD"] = "dashboard";
    FIXED_MODULE["DELIVERY_RULES"] = "delivery-rules";
    FIXED_MODULE["NOTIFICATIONS"] = "notifications";
    FIXED_MODULE["EXPRESSIONS"] = "expressions";
    FIXED_MODULE["APPLICATION_CONFIGURATION"] = "application-configuration";
    FIXED_MODULE["TAGS"] = "tags";
    FIXED_MODULE["SYSTEM_SETTINGS"] = "system-settings";
    FIXED_MODULE["API_KEYS"] = "apikeys";
})(FIXED_MODULE || (FIXED_MODULE = {}));
export const MAX_PLAYBOOK_RECORDS = 250;
export const DEFAULT_GRID_ROWS = 20;
export const DEFAULT_LOOKUP_RECORDS = 30;
export const DEFAULT_CACHE_BLOCK_SIZE = 30;
export const MAX_TEXT_LENGTH = 10485761;
export const MIN_NUMBER_LIMIT = -2147483648;
export const SORT_ORDER = [{
        value: 'ASC',
        label: 'Ascending'
    }, {
        value: 'DESC',
        label: 'Descending'
    }];
export var CS_USER_TYPE;
(function (CS_USER_TYPE) {
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_SECADMIN"] = 1] = "CS_USERTYPE_SECADMIN";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_USER"] = 2] = "CS_USERTYPE_USER";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_APPLIANCE"] = 3] = "CS_USERTYPE_APPLIANCE";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_MSSP"] = 4] = "CS_USERTYPE_MSSP";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_NO_IDLE"] = 5] = "CS_USERTYPE_NO_IDLE";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_SAML"] = 6] = "CS_USERTYPE_SAML";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_LDAP"] = 7] = "CS_USERTYPE_LDAP";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_RADIUS"] = 8] = "CS_USERTYPE_RADIUS";
})(CS_USER_TYPE || (CS_USER_TYPE = {}));
export var USER_ACCESS_TYPE;
(function (USER_ACCESS_TYPE) {
    USER_ACCESS_TYPE["NAMED"] = "Named";
    USER_ACCESS_TYPE["CONCURRENT"] = "Concurrent";
})(USER_ACCESS_TYPE || (USER_ACCESS_TYPE = {}));
export const BRANDING_FALLBACK = {
    light: {
        'largeLogo': 'data:image/png;base64,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'
    },
    dark: {
        'largeLogo': 'data:image/png;base64,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'
    },
    'favicon': 'data:image/vnd.microsoft.icon;base64,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',
};
export const CONTENTHUB = {
    CONTENT_TYPE: { CONNECTOR: 'connector', WIDGET: 'widget', SOLUTION_PACK: 'solutionpack' },
    CONTENT_PERMISSION: { CONNECTOR: 'connectors', WIDGET: 'widgets', SOLUTION_PACK: 'solution-packs' },
    CONTENT_LABEL: { CONNECTOR: 'Connectors', WIDGET: 'Widgets', SOLUTION_PACK: 'Solution Packs' },
    CONTENT_TYPE_LABEL: { connector: 'Connector', widget: 'Widget', solutionpack: 'Solution Pack' },
    CONTENT_TYPE_LABEL_PLURAL: { connectors: 'Connectors', widgets: 'Widgets', solutionpacks: 'Solution Packs' }
};
export const CONFIGURATION_LABELS = {
    dependency: 'Dependency(s)',
    prerequisite: 'Prerequisite(s)',
    modules: 'Module Schema(s)',
    recordSets: 'Record Set(s)',
    viewTemplates: 'Module View(s)',
    views: 'System View(s)',
    reports: 'Report(s)',
    dashboards: 'Dashboard(s)',
    picklistNames: 'Picklist(s)',
    roles: 'Role(s)',
    teams: 'Team(s)',
    actors: 'User(s)',
    playbooks: 'Playbook Collection(s)',
    playbookCollections: 'Playbook Collection(s)',
    playbookBlocks: 'Playbook Block(s)',
    globalVariables: 'Global Variable(s)',
    rules: 'Rule(s)',
    ruleChannels: 'Rule Channel(s)',
    connectors: 'Connector(s)',
    widgets: 'Widget(s)',
    appSettings: 'Administrative Setting(s)'
};
export const CONFIG_IMPORT_ORDER = [
    'starting',
    'picklistNames',
    'modules',
    'viewTemplates',
    'views',
    'roles',
    'actors',
    'teams',
    'playbooks',
    'rules',
    'ruleChannels',
    'reports',
    'dashboards',
    'connectors',
    'widgets',
    'recordSets',
    'appSettings',
    'completed'
];
export const APP_SETTINGS = [{
        name: 'systemSettings',
        title: 'Application Configuration (theme, branding, notifications, and more)'
    }, {
        name: 'LDAP',
        title: 'LDAP Configuration'
    }, {
        name: 'RADIUS',
        title: 'RADIUS Configuration'
    }, {
        name: 'TOKEN',
        title: 'Account Configuration (timeouts and token refresh)'
    }, {
        name: 'HA',
        title: 'System & Cluster Health Monitoring'
    }, {
        name: 'sso',
        title: 'SAML Configuration'
    }, {
        name: 'syslog',
        title: 'Logging Configuration'
    }, {
        name: 'proxy',
        title: 'Proxy & Environment Variables'
    }];
export const LANGUAGE_DATA = [
    {
        "id": "en",
        "label": "English"
    },
    {
        "id": "es",
        "label": "Spanish"
    },
    {
        "id": "hi",
        "label": "Hindi"
    }
];
export const REGEX = {
    ATTACHMENT_IRI: /^\/api\/3\/attachments\/[a-z0-9-]+$/,
    FILE_IRI: /^\/api\/3\/files\/[a-z0-9-]+$/,
    XSS_SVG_FILTER: /<img\s+[^>]*src="((ftp|http)s?:\/\/.*?\.(svg))"[^>]*>/g,
    HTML_ENTITIES_XSS_SVG_FILTER: /\&lt\;img\s+[^>]*src=[^>]*((ftp|http)s?:\/\/.*?\.(svg))[^>]*\&gt\;/g,
    ALPHA_NUMERIC_UNDERSCORE: /^[a-zA-Z_0-9]*$/g,
    ALPHA_NUMERIC_UNDERSCORE_SPACE: /^[a-zA-Z_0-9\s]*$/g,
    PB_STEP_NAME: /^[A-Za-z0-9`~!@#$%^&*()\-_=+|{}:;'<>,./?\s]*$/
};
export const COMMENT_TYPES = {
    ACTION_LOG: '/api/3/picklists/1165899b-7091-4291-aafc-487c4309e8ff',
    COMMENT: '/api/3/picklists/ff599189-3eeb-4c86-acb0-a7915e85ac3b'
};
export const UUID_REGEX = /^[0-9A-F]{8}-[0-9A-F]{4}-[4][0-9A-F]{3}-[89AB][0-9A-F]{3}-[0-9A-F]{12}$/i;
export const JINJA_REGEX = /\{\{(.*?)\}\}/g;
export const TOKEN_STORAGE_KEY = 'token';
export const TITLE_POSTFIX = 'FortiSOAR Cloud Platform';
export const TITLE_POSTFIX_ABBR = 'FCP';
export const AGENT_CONFIG_HEALTH = { 'in_progress': 'fb340c77-c2c6-471d-8081-77c9302b4bfb', 'complete_on_message_exchange': 'b5566a53-7af5-48f6-9dbd-5bf5fc9f432b', 'remote_node_connected': 'ab6a1713-9280-4619-9fbd-7694edad2159', 'missed_heartbeats': '0b916872-03d7-49aa-b809-e5471fa970df', 'failed_on_message_exchange': '4b7645c0-cafa-45dd-ad57-44882ce57f21', 'message_exchange_unreachable': '945621cd-f169-44b8-bc28-807a6f17d00a', 'remote_node_unreachable': '135030fa-1b0b-453d-9fed-df9be5d4397f' };
export var CONNECTOR_STATUS;
(function (CONNECTOR_STATUS) {
    CONNECTOR_STATUS["INSTALLED"] = "installed";
})(CONNECTOR_STATUS || (CONNECTOR_STATUS = {}));
export const CHANNEL_UUIDS = { 'IN_APP': '7a04788b-5128-4288-a0fc-6e82d18c3b7b', 'EMAIL': '2a817063-e12a-496d-934d-381d22a95b3b', 'QUEUE': '44fd54ca-f82d-431e-a6fa-dfde019a1ed6', 'RESUME_CONDITIONAL_PB_STEP': 'e2ce87c2-c55a-11ec-9d64-0242ac120002', 'ON_PLAYBOOK_FAILURE': '4c7f3cd4-b9a4-44c9-b372-de68070d0d67' };
export const POLL_INTERVAL = 5000;
export var PERMISSION;
(function (PERMISSION) {
    PERMISSION["READ"] = "read";
    PERMISSION["CREATE"] = "create";
    PERMISSION["UPDATE"] = "update";
    PERMISSION["DELETE"] = "delete";
    PERMISSION["EXECUTE"] = "execute";
    PERMISSION["DEBUG"] = "debug";
    PERMISSION["INSTALL"] = "install";
    PERMISSION["RETRY"] = "retry";
})(PERMISSION || (PERMISSION = {}));
export const ERROR_OBJECTS = {
    404: {
        code: 404,
        icon: 'assets/images/404_icon.png',
        error: 'Page Not Found',
        errorText: 'Sorry, we could not find the page you are looking for.',
        description: 'This error occurs when the server cannot find the requested resource. The user may have entered a incorrect URL, or the resource may have been deleted or moved.'
    },
    403: {
        code: 403,
        icon: 'assets/images/403_icon.png',
        error: 'Access Denied',
        errorText: 'You do not have permission to access this resource.',
        description: 'The request could not be fulfilled by the server due to insufficient access privileges. If you believe this is an error, please contact the website administrator for assistance.'
    },
    500: {
        code: 500,
        icon: 'assets/images/500_icon.png',
        error: 'Internal server error',
        errorText: 'Sorry for the inconvenience. Please report this message. Thank you very much!',
    },
    501: {
        code: 501,
        icon: 'assets/images/501_icon.png',
        error: 'Not Implemented',
        errorText: 'Sorry, the page you were looking for cannot be accessed as the server does not support the requested method. Please try again later or contact the website administrator if you need assistance. Thank you for your understanding.',
    },
    502: {
        code: 502,
        icon: 'assets/images/502_icon.png',
        error: 'Bad gateway',
        errorText: 'Error indicates a bad gateway, typically caused by server communication issues.',
        description: 'Try refreshing the page, clearing the browser cache, or contact the administrator if the issue persists.'
    },
    503: {
        code: 503,
        icon: 'assets/images/503_icon.png',
        error: 'Service unavailable',
        errorText: 'We apologize for the inconvenience. Our team is working to resolve the issue as quickly as possible. ',
    },
    504: {
        code: 504,
        icon: 'assets/images/504_icon.png',
        error: 'Gateway timeout',
        errorText: 'This error signifies a gateway timeout, indicating that a server didn\'t receive a timely response from another server it was accessing.',
        description: 'Try refreshing the page, checking their internet connection, or contacting the administrator if the issue persists'
    }
};
export const IGNORE_ERRORS = new HttpContextToken(() => false);
export const MODULE_MAPPING = {
    manualinput: "User Input",
    playbook_log: "Playbook Log"
};
export const DEFAULT_SCHEDULE_TASKS = {
    AUDIT: {
        SETTING: 'purge_audit_task',
        TASK: 'tasks.default_tasks.purge_audit_task'
    },
    PLAYBOOK: {
        SETTING: 'purge_workflow_task',
        TASK: 'tasks.default_tasks.purge_workflow_task'
    },
    SYSTEM_NOTOFICATIONS: {
        SETTING: 'purge_system_notifications',
        TASK: 'tasks.default_tasks.purge_system_notifications'
    },
    FAILURE_NOTOFICATIONS: {
        SETTING: 'purge_failed_notifications',
        TASK: 'tasks.default_tasks.purge_failed_notifications'
    }
};
export const MASK_KEY_FORMAT = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxx';
export const cloudURL = 'https://platform.fortisoar.forticloud.com/';
//# sourceMappingURL=data:application/json;base64,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