/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { CheckboxField } from "../../form-fields/field-types/checkbox";
import { DatetimeField } from "../../form-fields/field-types/datetime";
import { DecimalField } from "../../form-fields/field-types/decimal";
import { DomainField } from "../../form-fields/field-types/domain";
import { EmailField } from "../../form-fields/field-types/email";
import { FileField } from "../../form-fields/field-types/file";
import { FilehashField } from "../../form-fields/field-types/fileHash";
import { IntegerField } from "../../form-fields/field-types/integer";
import { IPv4Field } from "../../form-fields/field-types/ipv4";
import { IPv6Field } from "../../form-fields/field-types/ipv6";
import { JSONField } from "../../form-fields/field-types/json";
import { LookupField } from "../../form-fields/field-types/lookup";
import { ManyToManyField } from "../../form-fields/field-types/manytomany";
import { MultiSelectField } from "../../form-fields/field-types/multiselect";
import { MultiselectPicklistField } from "../../form-fields/field-types/multiselect-picklist";
import { OneToManyField } from "../../form-fields/field-types/onetomany";
import { PasswordField } from "../../form-fields/field-types/password";
import { PhoneField } from "../../form-fields/field-types/phone";
import { PicklistField } from "../../form-fields/field-types/picklist";
import { RichtextHTMLField } from "../../form-fields/field-types/richtext-html";
import { RichtextMarkdownField } from "../../form-fields/field-types/richtext-markdown";
import { SelectField } from "../../form-fields/field-types/select";
import { TagsField } from "../../form-fields/field-types/tags";
import { TextField } from "../../form-fields/field-types/text";
import { TextareaField } from "../../form-fields/field-types/textarea";
import { URLField } from "../../form-fields/field-types/url";
export const ModuleAttributeMap = {
    text: {
        formType: 'text',
        title: 'Text Field',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: true
        },
        field: TextField,
    },
    password: {
        formType: 'password',
        title: 'Password',
        type: 'string',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: PasswordField
    },
    checkbox: {
        formType: 'checkbox',
        title: 'Checkbox',
        type: 'boolean',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: CheckboxField
    },
    integer: {
        formType: 'integer',
        title: 'Integer Field',
        type: 'integer',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: IntegerField
    },
    decimal: {
        formType: 'decimal',
        title: 'Decimal Field',
        type: 'number',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: DecimalField
    },
    datetime: {
        formType: 'datetime',
        title: 'Date/Time Field',
        type: 'integer',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: DatetimeField
    },
    phone: {
        formType: 'phone',
        title: 'Phone Field',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: PhoneField
    },
    email: {
        formType: 'email',
        title: 'Email Field',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: EmailField
    },
    picklist: {
        formType: 'picklist',
        title: 'Picklist',
        type: 'picklists',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: PicklistField,
        dataSource: {
            model: 'picklists',
            query: {
                logic: 'AND',
                filters: [{
                        field: 'listName__name',
                        operator: 'eq',
                        value: null
                    }],
                sort: [{
                        field: 'orderIndex',
                        direction: 'ASC'
                    }]
            }
        },
        displayTemplate: '{{ itemValue }}'
    },
    multiselectpicklist: {
        formType: 'multiselectPicklist',
        title: 'Multiselect Picklist',
        type: 'picklists',
        isFormField: true,
        usable: false,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        dataSource: {
            model: 'picklists',
            query: {
                logic: 'AND',
                filters: [{
                        field: 'listName__name',
                        operator: 'eq',
                        value: null
                    }],
                sort: [{
                        field: 'orderIndex',
                        direction: 'ASC'
                    }]
            }
        },
        displayTemplate: '{{ itemValue }}',
        collection: true,
        ownsRelationship: false,
        field: MultiselectPicklistField
    },
    domain: {
        formType: 'domain',
        title: 'Domain',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: DomainField
    },
    url: {
        formType: 'url',
        title: 'URL',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: URLField
    },
    file: {
        formType: 'file',
        title: 'File Field',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        dataSource: {
            model: 'files'
        },
        field: FileField
    },
    fileHash: {
        formType: 'fileHash',
        title: 'FileHash',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: FilehashField
    },
    ipv4: {
        formType: 'ipv4',
        title: 'IPv4',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: IPv4Field
    },
    ipv6: {
        formType: 'ipv6',
        title: 'IPv6',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: IPv6Field
    },
    json: {
        formType: 'json',
        title: 'JSON Field',
        type: 'string',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: JSONField
    },
    lookup: {
        formType: 'lookup',
        title: 'Lookup (One to Many or One to One)',
        type: null,
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        dataSource: {
            model: null
        },
        field: LookupField
    },
    manyToMany: {
        formType: 'manyToMany',
        title: 'Many to Many',
        type: null,
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        collection: true,
        field: ManyToManyField
    },
    oneToMany: {
        formType: 'oneToMany',
        title: 'One To Many', // previously Many to One changing it as per form type // need to confirm
        type: null,
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        dataSource: {
            model: null
        },
        field: OneToManyField
    },
    html: {
        formType: 'html',
        title: 'Rich Text (HTML)',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: RichtextHTMLField
    },
    richtext: {
        formType: 'richtext',
        title: 'Rich Text (Markdown)',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: RichtextMarkdownField
    },
    tags: {
        formType: 'tags',
        title: 'Tags',
        type: 'tags',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: TagsField
    },
    textarea: {
        formType: 'textarea',
        title: 'Text Area',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: TextareaField
    },
    select: {
        formType: 'select',
        title: 'Select Field',
        type: 'select',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField
    },
    multiselect: {
        formType: 'multiselect',
        title: 'Multiselect Field',
        type: 'array',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: MultiSelectField
    },
    dynamicList: {
        formType: 'dynamicList',
        title: 'Dynamic List',
        type: 'array',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with dynamicList Field
    },
    array: {
        formType: 'text',
        title: 'Array Field',
        type: 'string',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with dynamicList Field
    },
    object: {
        formType: 'object',
        title: 'JSON',
        type: 'object',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with dynamicList Field
    },
    image: {
        formType: 'image',
        title: 'Image',
        type: null,
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with image Field
    },
    toManyList: {
        formType: 'manyToMany',
        title: 'Many to Many',
        type: null,
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        dataSource: {
            model: null
        },
        collection: true,
        field: SelectField // replace this with toManyList Field
    },
    label: {
        formType: 'label',
        title: 'Label',
        type: 'string',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with label Field
    },
    livesync: {
        formType: 'livesync',
        title: 'Live Sync',
        type: null,
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with licesync Field
    },
    certificate: {
        formType: 'certificate',
        title: 'Certificate',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: TextareaField // replace this with certificate Field
    },
    codeEditor: {
        formType: 'codeEditor',
        title: 'Code Editor',
        type: 'codeEditor',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: true
        },
        field: TextareaField
    },
    emailTemplate: {
        formType: 'emailTemplate',
        title: 'Email Template Field',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField
    }
};
//     .attribute('checkbox.select', {
//       templateUrl: 'app/components/form/fields/checkbox.select.html'
//     })
//     .attribute('datetime.advance', {
//       templateUrl: 'app/components/form/fields/datetime.advance.html'
//     })
//     .attribute('datetime.quick', {
//       templateUrl: 'app/components/form/fields/datetime.quick.html'
//     })
//     .attribute('datetime.grid', {
//       templateUrl: 'app/components/form/fields/datetime.grid.html'
//     })
//     .attribute('datetime.defaultValue', {
//       templateUrl: 'app/components/form/fields/datetime.defaultValue.html'
//     })
//     .attribute('datetime.playbook', {
//       templateUrl: 'app/components/form/fields/datetime.playbook.html'
//     })
//     .attribute('select.input', {
//       formType: 'select',
//       title: 'Select Input',
//       type: 'string',
//       templateUrl: 'app/components/form/fields/selectInput.html'
//     })
//     .attribute('jinja.input', {
//       formType: 'text',
//       title: 'Text Field',
//       type: 'string',
//       templateUrl: 'app/components/form/fields/input.html'
//     })
//     .attribute('picklist.multi', {
//       templateUrl: 'app/components/form/fields/picklist.multi.html'
//     })
//     .attribute('relationshipFields.playbook', {
//       templateUrl: 'app/components/form/fields/input.html'
//     })
// }
//# sourceMappingURL=data:application/json;base64,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