import { __decorate } from "tslib";
/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Expose } from "class-transformer";
import { API, FIXED_MODULE } from "../constants";
export class Channel {
    constructor(name) {
        this.description = '';
        this.config = {};
        this.type = 'connector';
        this.defaultParams = {};
        this.isActive = true;
        this.name = name;
    }
    get iri() {
        return `${API.RULE_ENGINE}${FIXED_MODULE.CHANNEL}/${this.uuid}/`;
    }
    asSaved() {
        return {
            uuid: this.uuid,
            name: this.name,
            default_params: this.defaultParams,
            is_active: this.isActive,
            config: this.config,
            description: this.description,
            type: this.type
        };
    }
}
__decorate([
    Expose({ name: 'default_params' })
], Channel.prototype, "defaultParams", void 0);
__decorate([
    Expose({ name: 'is_active' })
], Channel.prototype, "isActive", void 0);
//# sourceMappingURL=data:application/json;base64,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