import { plainToInstance } from "class-transformer";
import { InputFieldComponent } from "../../form-fields/field-renderers/built-ins/input/input-field.component";
import { InputViewComponent } from "../../form-fields/field-renderers/built-ins/input/input-view.component";
import { Filter } from "../../query-filters/models/filter";
import { Operator } from "../../query-filters/models/operator";
import { Query } from "../../query-filters/models/query";
import { SearchableItem } from "../../components/searchable-dropdown/searchable-item";
import { DatetimeFieldComponent } from "../../form-fields/field-renderers/built-ins/datetime/datetime-field/datetime-field.component";
import { CheckboxFieldComponent } from "../../form-fields/field-renderers/built-ins/checkbox/checkbox-field.component";
import { TagsFieldComponent } from "../../form-fields/field-renderers/built-ins/tags/tags-field.component";
export class Field {
    get visibility() {
        return this._visibility;
    }
    set visibility(value) {
        if (Array.isArray(value)) {
            value = value[0];
        }
        this._visibility = plainToInstance(Query, value);
    }
    getFlatValue(value, operator) {
        return value;
    }
    getViewValue(value) {
        return value;
    }
    static { this.listOperators = [
        new Operator('in', 'Is In List', TagsFieldComponent, this.evaluateIsInList),
        new Operator('nin', 'Is Not In List', TagsFieldComponent, this.evaluateIsNotInList),
    ]; }
    static { this.nullOperator = [
        new Operator('isnull', 'Is Null', CheckboxFieldComponent, this.evaluateIsNull),
    ]; }
    static { this.equalOperators = [
        new Operator('eq', 'Equals', InputFieldComponent, this.evaluateEqual),
        new Operator('neq', 'Not Equals', InputFieldComponent, this.evaluateNotEqual),
    ]; }
    static { this.greaterThanLessThanOperators = [
        new Operator('lt', 'Before', DatetimeFieldComponent, this.evaluateBefore),
        new Operator('lte', 'On or Before', DatetimeFieldComponent, this.evaluateOnOrBefore),
        new Operator('gt', 'After', DatetimeFieldComponent, this.evaluateAfter),
        new Operator('gte', 'On or After', DatetimeFieldComponent, this.evaluateOnOrAfter),
    ]; }
    static { this.numericGreaterThanLessThanOperators = [
        new Operator('lt', 'Less Than', InputFieldComponent, this.evaluateBefore),
        new Operator('lte', 'Less Than or Equal To', InputFieldComponent, this.evaluateOnOrBefore),
        new Operator('gt', 'Greater Than', InputFieldComponent, this.evaluateAfter),
        new Operator('gte', 'Greater Than or Equal To', InputFieldComponent, this.evaluateOnOrAfter),
    ]; }
    static { this.isChangedOperators = [
        new Operator('changed', 'Is Changed', '', this.evaluateIsChanged)
    ]; }
    static { this.operators = this.equalOperators; }
    getOperator(operatorId) {
        return this.operators.find((op) => {
            return op.id === operatorId;
        });
    }
    get operators() {
        return Object.getPrototypeOf(this).constructor.operators;
    }
    constructor(name, formType) {
        this.defaultValue = '';
        this.blankDisplay = '';
        this.title = '';
        this.type = '';
        this.encrypted = false;
        this.gridColumn = false;
        this.orderIndex = 0;
        this.peerReplicable = false;
        this.htmlEscape = false;
        this.inversedField = null;
        this.ownsRelationship = false;
        this.recommend = false;
        this.searchable = false;
        this.system = false;
        this.tooltip = '';
        this.subtitle = '';
        this.validation = {
            required: false
        };
        this._visibility = true;
        this.writeable = true;
        this.visible = true;
        this.required = false;
        this.isFormField = false;
        this.isRelationship = false;
        this.displayTemplate = '';
        this.readOnly = false;
        this.trackable = false;
        this.placeholder = '';
        this.OPERATOR_KEY = '$';
        this.fieldContainerClass = ''; //for field container class like specific width (w-50, w-70) or col-md-6
        this.orphanRemoval = false;
        this.allowJinjaToggle = false;
        this.alwaysJinja = false;
        this.filter = Filter; //ArrayFilter|ObjectFilter
        this.params = {};
        this.mapping = {};
        //private _relationshipFields = ['manyToMany', 'oneToMany'];
        this.alwaysEditMode = false;
        this.name = name;
        this.formType = formType;
        this.descriptions = {
            singular: ''
        };
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
    get descriptions() {
        return this._descriptions;
    }
    set descriptions(value) {
        this._descriptions = value;
        if (this._descriptions) {
            this.title = this._descriptions.singular || this.name;
        }
        else {
            this.title = this.title || this.name;
        }
    }
    get dataSource() {
        return this._dataSource;
    }
    set dataSource(value) {
        this._dataSource = value;
    }
    setMode(mode) {
        this.visibility = mode === 'archived' ? true : this.visibility;
        if (mode === 'archived') {
            this.visible = true;
            this.validation.required = false;
        }
        else {
            //this.evaluateRequired();
            //this.evaluateVisible();
        }
    }
    static evaluateIsInList(field, value) {
        return false;
    }
    static evaluateIsNotInList(field, value) {
        return false;
    }
    static evaluateIsNull(field, value) {
        return false;
    }
    ;
    static evaluateEqual(field, value) {
        return false;
    }
    static evaluateNotEqual(field, value) {
        return false;
    }
    static evaluateBefore(field, value) {
        return false;
    }
    static evaluateOnOrBefore(field, value) {
        return false;
    }
    static evaluateAfter(field, value) {
        return false;
    }
    static evaluateOnOrAfter(field, value) {
        return false;
    }
    static evaluateIsChanged(field, value) {
        return false;
    }
    asSearchableItem() {
        return new SearchableItem(this.title, this, this.name);
    }
    buildSort(order) {
        const sort = [];
        if (this.name === '@id') {
            sort.push({
                field: 'id',
                direction: order,
                _fieldName: this.name
            });
        }
        else if (!this.model) {
            sort.push({
                field: this.name,
                direction: order,
                _fieldName: this.name
            });
            return sort;
        }
        else if (this.defaultSort) {
            this.defaultSort.forEach((sortItem) => {
                sort.push({
                    field: this.name + '.' + sortItem.field,
                    direction: order,
                    _fieldName: this.name
                });
            });
        }
        return sort;
    }
    ;
    getURLQueryValue(value, operator) {
        let query = {};
        let _operator = operator.id === 'like_pattern' ? 'like' : operator.id;
        _operator = operator.id === 'notlike_pattern' ? 'notlike' : operator.id;
        query[`${this.name}${this.OPERATOR_KEY}${_operator}`] = this.getFlatValue(value, operator);
        return query;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: -1
        };
    }
}
(function (Field) {
    let BuiltInType;
    (function (BuiltInType) {
        BuiltInType["TEXT"] = "text";
        BuiltInType["PASSWORD"] = "password";
        BuiltInType["INTEGER"] = "integer";
        BuiltInType["DECIMAL"] = "decimal";
        BuiltInType["CHECKBOX"] = "checkbox";
        BuiltInType["EMAIL"] = "email";
        BuiltInType["DATETIME"] = "datetime";
        BuiltInType["LOOKUP"] = "lookup";
        BuiltInType["MULTISELECT_PICKLIST"] = "multiselectpicklist";
        BuiltInType["PICKLIST"] = "picklist";
        BuiltInType["MANY_TO_MANY"] = "manyToMany";
        BuiltInType["ONE_TO_MANY"] = "oneToMany";
        BuiltInType["FILE"] = "file";
        BuiltInType["JSON"] = "json";
        BuiltInType["JINJA"] = "jinja";
        BuiltInType["ARRAY"] = "array";
        BuiltInType["PHONE"] = "phone";
        BuiltInType["DOMAIN"] = "domain";
        BuiltInType["FILEHASH"] = "fileHash";
        BuiltInType["IPv4"] = "ipv4";
        BuiltInType["IPv6"] = "ipv6";
        BuiltInType["RICHTEXTHTML"] = "html";
        BuiltInType["RICHTEXTMARKDOWN"] = "richtext";
        BuiltInType["TEXTAREA"] = "textarea";
        BuiltInType["URL"] = "url";
        BuiltInType["TAGS"] = "tags";
        BuiltInType["SELECT"] = "select";
        BuiltInType["MULTISELECT"] = "multiselect";
        BuiltInType["RADIO"] = "radio";
        BuiltInType["TOGGLE"] = "toggle";
        BuiltInType["MULTISELECTCHECKBOXDROPDOWN"] = "multiSelectCheckboxDropdown";
        BuiltInType["TOGGLEDROPDOWN"] = "toggleDropdown";
        BuiltInType["CERTIFICATE"] = "certificate";
    })(BuiltInType = Field.BuiltInType || (Field.BuiltInType = {}));
})(Field || (Field = {}));
//# sourceMappingURL=data:application/json;base64,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