import { API } from "../constants";
import { PagedCollectionService } from "../services/paged-collection.service";
import { Entity } from "./entity";
import { Query } from "../../query-filters/models/query";
export class PagedCollection {
    constructor(module, entity, relatedField, relatedUuid) {
        this.module = '';
        this.entity = {};
        this.currentPageNumber = 1;
        this.data = [];
        this.totalItems = 0;
        this.itemsPerPage = 30;
        this.query = new Query();
        this.service = PagedCollectionService;
        this.urlRequestType = 'post';
        this.type = 'base';
        this.module = module;
        this.entity = entity || new Entity(this.module);
        this.relatedField = relatedField;
        this.relatedUuid = relatedUuid;
    }
    getURLData(query) {
        let payload = query.getQueryObject();
        // if (!sortApplied) {
        //   query.buildOrderForPostRequest(self.entity, preparedQuery);
        // }
        // check for default query
        // let url = this.currentPageUrl || (this.urlRequestType === 'post' ? `${API.QUERY}${this.module}` : `${API.API_3_BASE}${this.module}`);
        //Integration with new PBaaS API's
        let url = this.currentPageUrl || (this.urlRequestType === 'post' ? `${API.SEALAB}+${this.module}` : `${API.SEALAB}${this.module}`);
        if (this.relatedField && this.relatedUuid) {
            url = url + '/' + this.relatedUuid + '/' + this.relatedField;
        }
        let urlParams;
        if (!this.currentPageUrl) {
            urlParams = query.getURLParameters();
        }
        return {
            requestType: this.urlRequestType,
            url: url,
            payload: payload,
            queryParams: urlParams
        };
    }
    setPage(data, query) {
        this.data = data['hydra:member'];
        // self.id = data['@id'];
        let id = data['@id'];
        // self.title = data['hydra:title'];
        //let title = data['hydra:title'];
        // self.error = data['@type'] === 'Error' || false;
        //let error = data['@type'] === 'Error' || false;
        // self.description = data['hydra:description'];
        let description = data['hydra:description'];
        // self.totalItems = data['hydra:totalItems'];
        this.totalItems = data['hydra:totalItems'];
        // self.itemsPerPage = data['hydra:itemsPerPage'] || angular.copy(self.query.limit);
        this.itemsPerPage = data['hydra:itemsPerPage'] || (query.limit);
        // if (self.id) {
        if (id) {
            //   var pageIndex = self.id.indexOf('page=');
            let pageIndex = id.indexOf('page=');
            //   if (pageIndex > 0) {
            if (pageIndex > 0) {
                //     var currentPageNum = self.id.substring(pageIndex + 5);
                var currentPageNum = id.substring(pageIndex + 5);
                //     self.currPageNum = isNaN(currentPageNum) ? self.currPageNum : currentPageNum;
                this.currentPageNumber = isNaN(currentPageNum) ? this.currentPageNumber : currentPageNum;
            }
        }
        let firstItemNum = (this.itemsPerPage * this.currentPageNumber) - this.itemsPerPage + 1;
        let lastItemNum = firstItemNum + data['hydra:member'].length - 1;
        this.totalPages = Math.ceil(this.totalItems / this.itemsPerPage);
        if (data['hydra:view']) {
            this.firstPageUrl = data['hydra:view']['hydra:first'];
            this.lastPageUrl = data['hydra:view']['hydra:last'];
            this.nextPageUrl = data['hydra:view']['hydra:next'];
            this.previousPageUrl = data['hydra:view']['hydra:previous'];
            this.gotoPageUrl = this.lastPageUrl ? this.lastPageUrl.substring(0, this.lastPageUrl.length - String(this.totalPages).length) : undefined;
        }
        else {
            this.firstPageUrl = undefined;
            this.lastPageUrl = undefined;
            this.nextPageUrl = undefined;
            this.previousPageUrl = undefined;
            this.currentPageUrl = undefined;
            this.gotoPageUrl = undefined;
        }
    }
    pageFirst() {
        this.currentPageNumber = 1;
        this.currentPageUrl = this.firstPageUrl;
    }
    pageLast() {
        this.currentPageNumber = 1;
        this.currentPageUrl = this.lastPageUrl;
    }
    pageNext() {
        this.currentPageNumber++;
        this.currentPageUrl = this.nextPageUrl;
    }
    pagePrevious() {
        this.currentPageNumber--;
        this.currentPageUrl = this.previousPageUrl;
    }
    ;
    recordPerPageChange() {
        this.currentPageNumber = 1;
        this.currentPageUrl = undefined;
    }
    gotoPage(page) {
        this.currentPageNumber = page;
        this.currentPageUrl = this.gotoPageUrl ? `${this.gotoPageUrl}${page}` : undefined;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFnZWQtY29sbGVjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zcmMvbGliL2NvcmUvbW9kZWxzL3BhZ2VkLWNvbGxlY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBT0EsT0FBTyxFQUFFLEdBQUcsRUFBRSxNQUFNLGNBQWMsQ0FBQztBQUNuQyxPQUFPLEVBQUUsc0JBQXNCLEVBQUUsTUFBTSxzQ0FBc0MsQ0FBQztBQUM5RSxPQUFPLEVBQUUsTUFBTSxFQUFFLE1BQU0sVUFBVSxDQUFDO0FBQ2xDLE9BQU8sRUFBRSxLQUFLLEVBQUUsTUFBTSxrQ0FBa0MsQ0FBQztBQUV6RCxNQUFNLE9BQU8sZUFBZTtJQXFCMUIsWUFBWSxNQUFjLEVBQUUsTUFBZSxFQUFFLFlBQXFCLEVBQUUsV0FBb0I7UUFwQnhGLFdBQU0sR0FBVyxFQUFFLENBQUM7UUFDcEIsV0FBTSxHQUFXLEVBQVksQ0FBQztRQUM5QixzQkFBaUIsR0FBWSxDQUFDLENBQUM7UUFDL0IsU0FBSSxHQUFVLEVBQUUsQ0FBQztRQUNqQixlQUFVLEdBQVksQ0FBQyxDQUFDO1FBQ3hCLGlCQUFZLEdBQVksRUFBRSxDQUFDO1FBUTNCLFVBQUssR0FBVSxJQUFJLEtBQUssRUFBRSxDQUFDO1FBRzNCLFlBQU8sR0FBaUMsc0JBQXNCLENBQUM7UUFFL0QsbUJBQWMsR0FBbUIsTUFBTSxDQUFDO1FBQ3hDLFNBQUksR0FBZ0MsTUFBTSxDQUFDO1FBRXpDLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDO1FBQ3JCLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxJQUFJLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUNoRCxJQUFJLENBQUMsWUFBWSxHQUFHLFlBQVksQ0FBQztRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLFdBQVcsQ0FBQztJQUNqQyxDQUFDO0lBRUQsVUFBVSxDQUFDLEtBQVk7UUFDckIsSUFBSSxPQUFPLEdBQVEsS0FBSyxDQUFDLGNBQWMsRUFBRSxDQUFDO1FBQzFDLHNCQUFzQjtRQUN0QixnRUFBZ0U7UUFDaEUsSUFBSTtRQUNKLDBCQUEwQjtRQUMxQix3SUFBd0k7UUFDeEksa0NBQWtDO1FBQ2xDLElBQUksR0FBRyxHQUFHLElBQUksQ0FBQyxjQUFjLElBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxLQUFLLE1BQU0sQ0FBQyxDQUFDLENBQUUsR0FBRyxHQUFHLENBQUMsTUFBTSxJQUFJLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDLENBQUMsR0FBRyxHQUFHLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDO1FBRXBJLElBQUksSUFBSSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7WUFDMUMsR0FBRyxHQUFHLEdBQUcsR0FBRyxHQUFHLEdBQUcsSUFBSSxDQUFDLFdBQVcsR0FBRyxHQUFHLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztRQUMvRCxDQUFDO1FBQ0QsSUFBSSxTQUFTLENBQUM7UUFDZCxJQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO1lBQ3pCLFNBQVMsR0FBRyxLQUFNLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztRQUN4QyxDQUFDO1FBQ0QsT0FBTztZQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNoQyxHQUFHLEVBQUUsR0FBRztZQUNSLE9BQU8sRUFBRSxPQUFPO1lBQ2hCLFdBQVcsRUFBRSxTQUFTO1NBQ3ZCLENBQUM7SUFDSixDQUFDO0lBRUQsT0FBTyxDQUFDLElBQVMsRUFBRSxLQUFZO1FBQzdCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ2pDLHlCQUF5QjtRQUN6QixJQUFJLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDckIsb0NBQW9DO1FBQ3BDLGtDQUFrQztRQUNsQyxtREFBbUQ7UUFDbkQsaURBQWlEO1FBQ2pELGdEQUFnRDtRQUNoRCxJQUFJLFdBQVcsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQztRQUM1Qyw4Q0FBOEM7UUFDOUMsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUMzQyxvRkFBb0Y7UUFDcEYsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNoRSxpQkFBaUI7UUFDakIsSUFBSSxFQUFFLEVBQUUsQ0FBQztZQUNQLDhDQUE4QztZQUM5QyxJQUFJLFNBQVMsR0FBRyxFQUFFLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1lBQ3BDLHlCQUF5QjtZQUN6QixJQUFJLFNBQVMsR0FBRyxDQUFDLEVBQUUsQ0FBQztnQkFDbEIsNkRBQTZEO2dCQUM3RCxJQUFJLGNBQWMsR0FBRyxFQUFFLENBQUMsU0FBUyxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUMsQ0FBQztnQkFDakQsb0ZBQW9GO2dCQUNwRixJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLGNBQWMsQ0FBQztZQUMzRixDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksWUFBWSxHQUFHLENBQUMsSUFBSSxDQUFDLFlBQWEsR0FBRyxJQUFJLENBQUMsaUJBQWtCLENBQUMsR0FBRyxJQUFJLENBQUMsWUFBYSxHQUFHLENBQUMsQ0FBQztRQUMzRixJQUFJLFdBQVcsR0FBRyxZQUFZLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUM7UUFDakUsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFXLEdBQUcsSUFBSSxDQUFDLFlBQWEsQ0FBQyxDQUFDO1FBRW5FLElBQUksSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQUM7WUFDdkIsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDdEQsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsWUFBWSxDQUFDLENBQUM7WUFDcEQsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsWUFBWSxDQUFDLENBQUM7WUFDcEQsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztZQUM1RCxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLENBQUMsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7UUFDNUksQ0FBQzthQUFNLENBQUM7WUFDTixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztZQUM5QixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztZQUM3QixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztZQUM3QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztZQUNqQyxJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztZQUNoQyxJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztRQUMvQixDQUFDO0lBQ0gsQ0FBQztJQUVELFNBQVM7UUFDUCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsQ0FBQyxDQUFDO1FBQzNCLElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMxQyxDQUFDO0lBRUQsUUFBUTtRQUNOLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxDQUFDLENBQUM7UUFDM0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQ3pDLENBQUM7SUFFRCxRQUFRO1FBQ04sSUFBSSxDQUFDLGlCQUFrQixFQUFFLENBQUM7UUFDMUIsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQ3pDLENBQUM7SUFFRCxZQUFZO1FBQ1YsSUFBSSxDQUFDLGlCQUFrQixFQUFFLENBQUM7UUFDMUIsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzdDLENBQUM7SUFBQSxDQUFDO0lBRUYsbUJBQW1CO1FBQ2pCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxDQUFDLENBQUM7UUFDM0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUVELFFBQVEsQ0FBQyxJQUFZO1FBQ25CLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUM7UUFDOUIsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxFQUFFLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUNwRixDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBDb3B5cmlnaHQgc3RhcnRcbiAgQ29weXJpZ2h0IChDKSAyMDA4IC0gMjAyNSBGb3J0aW5ldCBJbmMuXG4gIEFsbCByaWdodHMgcmVzZXJ2ZWQuXG4gIEZPUlRJTkVUIENPTkZJREVOVElBTCAmIEZPUlRJTkVUIFBST1BSSUVUQVJZIFNPVVJDRSBDT0RFXG4gIENvcHlyaWdodCBlbmQgKi9cbmltcG9ydCB7IFR5cGUgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xuaW1wb3J0IHsgU3ViamVjdCB9IGZyb20gXCJyeGpzXCI7XG5pbXBvcnQgeyBBUEkgfSBmcm9tIFwiLi4vY29uc3RhbnRzXCI7XG5pbXBvcnQgeyBQYWdlZENvbGxlY3Rpb25TZXJ2aWNlIH0gZnJvbSBcIi4uL3NlcnZpY2VzL3BhZ2VkLWNvbGxlY3Rpb24uc2VydmljZVwiO1xuaW1wb3J0IHsgRW50aXR5IH0gZnJvbSBcIi4vZW50aXR5XCI7XG5pbXBvcnQgeyBRdWVyeSB9IGZyb20gXCIuLi8uLi9xdWVyeS1maWx0ZXJzL21vZGVscy9xdWVyeVwiO1xuXG5leHBvcnQgY2xhc3MgUGFnZWRDb2xsZWN0aW9uIHtcbiAgbW9kdWxlOiBzdHJpbmcgPSAnJztcbiAgZW50aXR5OiBFbnRpdHkgPSB7fSBhcyBFbnRpdHk7XG4gIGN1cnJlbnRQYWdlTnVtYmVyPzogbnVtYmVyID0gMTtcbiAgZGF0YTogYW55W10gPSBbXTtcbiAgdG90YWxJdGVtcz86IG51bWJlciA9IDA7XG4gIGl0ZW1zUGVyUGFnZT86IG51bWJlciA9IDMwO1xuICB0b3RhbFBhZ2VzPzogbnVtYmVyO1xuICBmaXJzdFBhZ2VVcmw/OiBzdHJpbmc7XG4gIGxhc3RQYWdlVXJsPzogc3RyaW5nO1xuICBuZXh0UGFnZVVybD86IHN0cmluZztcbiAgcHJldmlvdXNQYWdlVXJsPzogc3RyaW5nO1xuICBnb3RvUGFnZVVybD86IHN0cmluZztcbiAgY3VycmVudFBhZ2VVcmw/OiBzdHJpbmc7XG4gIHF1ZXJ5OiBRdWVyeSA9IG5ldyBRdWVyeSgpO1xuICByZWxhdGVkRmllbGQ/OiBzdHJpbmc7XG4gIHJlbGF0ZWRVdWlkPzogc3RyaW5nO1xuICBzZXJ2aWNlOiBUeXBlPFBhZ2VkQ29sbGVjdGlvblNlcnZpY2U+ID0gUGFnZWRDb2xsZWN0aW9uU2VydmljZTtcbiAgc3ViamVjdD86IFN1YmplY3Q8YW55PjtcbiAgdXJsUmVxdWVzdFR5cGU6ICdwb3N0JyB8ICdnZXQnID0gJ3Bvc3QnO1xuICB0eXBlOiAnYmFzZScgfCAnYWN0b3InIHwgJ2RqYW5nbycgPSAnYmFzZSc7XG4gIGNvbnN0cnVjdG9yKG1vZHVsZTogc3RyaW5nLCBlbnRpdHk/OiBFbnRpdHksIHJlbGF0ZWRGaWVsZD86IHN0cmluZywgcmVsYXRlZFV1aWQ/OiBzdHJpbmcpIHtcbiAgICB0aGlzLm1vZHVsZSA9IG1vZHVsZTtcbiAgICB0aGlzLmVudGl0eSA9IGVudGl0eSB8fCBuZXcgRW50aXR5KHRoaXMubW9kdWxlKTtcbiAgICB0aGlzLnJlbGF0ZWRGaWVsZCA9IHJlbGF0ZWRGaWVsZDtcbiAgICB0aGlzLnJlbGF0ZWRVdWlkID0gcmVsYXRlZFV1aWQ7XG4gIH1cblxuICBnZXRVUkxEYXRhKHF1ZXJ5OiBRdWVyeSkge1xuICAgIGxldCBwYXlsb2FkOiBhbnkgPSBxdWVyeS5nZXRRdWVyeU9iamVjdCgpO1xuICAgIC8vIGlmICghc29ydEFwcGxpZWQpIHtcbiAgICAvLyAgIHF1ZXJ5LmJ1aWxkT3JkZXJGb3JQb3N0UmVxdWVzdChzZWxmLmVudGl0eSwgcHJlcGFyZWRRdWVyeSk7XG4gICAgLy8gfVxuICAgIC8vIGNoZWNrIGZvciBkZWZhdWx0IHF1ZXJ5XG4gICAgLy8gbGV0IHVybCA9IHRoaXMuY3VycmVudFBhZ2VVcmwgfHwgKHRoaXMudXJsUmVxdWVzdFR5cGUgPT09ICdwb3N0JyA/IGAke0FQSS5RVUVSWX0ke3RoaXMubW9kdWxlfWAgOiBgJHtBUEkuQVBJXzNfQkFTRX0ke3RoaXMubW9kdWxlfWApO1xuICAgIC8vSW50ZWdyYXRpb24gd2l0aCBuZXcgUEJhYVMgQVBJJ3NcbiAgICBsZXQgdXJsID0gdGhpcy5jdXJyZW50UGFnZVVybCB8fCAodGhpcy51cmxSZXF1ZXN0VHlwZSA9PT0gJ3Bvc3QnID8gIGAke0FQSS5TRUFMQUJ9KyR7dGhpcy5tb2R1bGV9YCA6IGAke0FQSS5TRUFMQUJ9JHt0aGlzLm1vZHVsZX1gKTtcblxuICAgIGlmICh0aGlzLnJlbGF0ZWRGaWVsZCAmJiB0aGlzLnJlbGF0ZWRVdWlkKSB7XG4gICAgICB1cmwgPSB1cmwgKyAnLycgKyB0aGlzLnJlbGF0ZWRVdWlkICsgJy8nICsgdGhpcy5yZWxhdGVkRmllbGQ7XG4gICAgfVxuICAgIGxldCB1cmxQYXJhbXM7XG4gICAgaWYgKCF0aGlzLmN1cnJlbnRQYWdlVXJsKSB7XG4gICAgICB1cmxQYXJhbXMgPSBxdWVyeSEuZ2V0VVJMUGFyYW1ldGVycygpO1xuICAgIH1cbiAgICByZXR1cm4ge1xuICAgICAgcmVxdWVzdFR5cGU6IHRoaXMudXJsUmVxdWVzdFR5cGUsXG4gICAgICB1cmw6IHVybCxcbiAgICAgIHBheWxvYWQ6IHBheWxvYWQsXG4gICAgICBxdWVyeVBhcmFtczogdXJsUGFyYW1zXG4gICAgfTtcbiAgfVxuXG4gIHNldFBhZ2UoZGF0YTogYW55LCBxdWVyeTogUXVlcnkpIHtcbiAgICB0aGlzLmRhdGEgPSBkYXRhWydoeWRyYTptZW1iZXInXTtcbiAgICAvLyBzZWxmLmlkID0gZGF0YVsnQGlkJ107XG4gICAgbGV0IGlkID0gZGF0YVsnQGlkJ107XG4gICAgLy8gc2VsZi50aXRsZSA9IGRhdGFbJ2h5ZHJhOnRpdGxlJ107XG4gICAgLy9sZXQgdGl0bGUgPSBkYXRhWydoeWRyYTp0aXRsZSddO1xuICAgIC8vIHNlbGYuZXJyb3IgPSBkYXRhWydAdHlwZSddID09PSAnRXJyb3InIHx8IGZhbHNlO1xuICAgIC8vbGV0IGVycm9yID0gZGF0YVsnQHR5cGUnXSA9PT0gJ0Vycm9yJyB8fCBmYWxzZTtcbiAgICAvLyBzZWxmLmRlc2NyaXB0aW9uID0gZGF0YVsnaHlkcmE6ZGVzY3JpcHRpb24nXTtcbiAgICBsZXQgZGVzY3JpcHRpb24gPSBkYXRhWydoeWRyYTpkZXNjcmlwdGlvbiddO1xuICAgIC8vIHNlbGYudG90YWxJdGVtcyA9IGRhdGFbJ2h5ZHJhOnRvdGFsSXRlbXMnXTtcbiAgICB0aGlzLnRvdGFsSXRlbXMgPSBkYXRhWydoeWRyYTp0b3RhbEl0ZW1zJ107XG4gICAgLy8gc2VsZi5pdGVtc1BlclBhZ2UgPSBkYXRhWydoeWRyYTppdGVtc1BlclBhZ2UnXSB8fCBhbmd1bGFyLmNvcHkoc2VsZi5xdWVyeS5saW1pdCk7XG4gICAgdGhpcy5pdGVtc1BlclBhZ2UgPSBkYXRhWydoeWRyYTppdGVtc1BlclBhZ2UnXSB8fCAocXVlcnkubGltaXQpO1xuICAgIC8vIGlmIChzZWxmLmlkKSB7XG4gICAgaWYgKGlkKSB7XG4gICAgICAvLyAgIHZhciBwYWdlSW5kZXggPSBzZWxmLmlkLmluZGV4T2YoJ3BhZ2U9Jyk7XG4gICAgICBsZXQgcGFnZUluZGV4ID0gaWQuaW5kZXhPZigncGFnZT0nKTtcbiAgICAgIC8vICAgaWYgKHBhZ2VJbmRleCA+IDApIHtcbiAgICAgIGlmIChwYWdlSW5kZXggPiAwKSB7XG4gICAgICAgIC8vICAgICB2YXIgY3VycmVudFBhZ2VOdW0gPSBzZWxmLmlkLnN1YnN0cmluZyhwYWdlSW5kZXggKyA1KTtcbiAgICAgICAgdmFyIGN1cnJlbnRQYWdlTnVtID0gaWQuc3Vic3RyaW5nKHBhZ2VJbmRleCArIDUpO1xuICAgICAgICAvLyAgICAgc2VsZi5jdXJyUGFnZU51bSA9IGlzTmFOKGN1cnJlbnRQYWdlTnVtKSA/IHNlbGYuY3VyclBhZ2VOdW0gOiBjdXJyZW50UGFnZU51bTtcbiAgICAgICAgdGhpcy5jdXJyZW50UGFnZU51bWJlciA9IGlzTmFOKGN1cnJlbnRQYWdlTnVtKSA/IHRoaXMuY3VycmVudFBhZ2VOdW1iZXIgOiBjdXJyZW50UGFnZU51bTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBsZXQgZmlyc3RJdGVtTnVtID0gKHRoaXMuaXRlbXNQZXJQYWdlISAqIHRoaXMuY3VycmVudFBhZ2VOdW1iZXIhKSAtIHRoaXMuaXRlbXNQZXJQYWdlISArIDE7XG4gICAgbGV0IGxhc3RJdGVtTnVtID0gZmlyc3RJdGVtTnVtICsgZGF0YVsnaHlkcmE6bWVtYmVyJ10ubGVuZ3RoIC0gMTtcbiAgICB0aGlzLnRvdGFsUGFnZXMgPSBNYXRoLmNlaWwodGhpcy50b3RhbEl0ZW1zISAvIHRoaXMuaXRlbXNQZXJQYWdlISk7XG5cbiAgICBpZiAoZGF0YVsnaHlkcmE6dmlldyddKSB7XG4gICAgICB0aGlzLmZpcnN0UGFnZVVybCA9IGRhdGFbJ2h5ZHJhOnZpZXcnXVsnaHlkcmE6Zmlyc3QnXTtcbiAgICAgIHRoaXMubGFzdFBhZ2VVcmwgPSBkYXRhWydoeWRyYTp2aWV3J11bJ2h5ZHJhOmxhc3QnXTtcbiAgICAgIHRoaXMubmV4dFBhZ2VVcmwgPSBkYXRhWydoeWRyYTp2aWV3J11bJ2h5ZHJhOm5leHQnXTtcbiAgICAgIHRoaXMucHJldmlvdXNQYWdlVXJsID0gZGF0YVsnaHlkcmE6dmlldyddWydoeWRyYTpwcmV2aW91cyddO1xuICAgICAgdGhpcy5nb3RvUGFnZVVybCA9IHRoaXMubGFzdFBhZ2VVcmwgPyB0aGlzLmxhc3RQYWdlVXJsLnN1YnN0cmluZygwLCB0aGlzLmxhc3RQYWdlVXJsLmxlbmd0aCAtIFN0cmluZyh0aGlzLnRvdGFsUGFnZXMpLmxlbmd0aCkgOiB1bmRlZmluZWQ7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuZmlyc3RQYWdlVXJsID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5sYXN0UGFnZVVybCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMubmV4dFBhZ2VVcmwgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLnByZXZpb3VzUGFnZVVybCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuY3VycmVudFBhZ2VVcmwgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLmdvdG9QYWdlVXJsID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgfVxuXG4gIHBhZ2VGaXJzdCgpIHtcbiAgICB0aGlzLmN1cnJlbnRQYWdlTnVtYmVyID0gMTtcbiAgICB0aGlzLmN1cnJlbnRQYWdlVXJsID0gdGhpcy5maXJzdFBhZ2VVcmw7XG4gIH1cblxuICBwYWdlTGFzdCgpIHtcbiAgICB0aGlzLmN1cnJlbnRQYWdlTnVtYmVyID0gMTtcbiAgICB0aGlzLmN1cnJlbnRQYWdlVXJsID0gdGhpcy5sYXN0UGFnZVVybDtcbiAgfVxuXG4gIHBhZ2VOZXh0KCkge1xuICAgIHRoaXMuY3VycmVudFBhZ2VOdW1iZXIhKys7XG4gICAgdGhpcy5jdXJyZW50UGFnZVVybCA9IHRoaXMubmV4dFBhZ2VVcmw7XG4gIH1cblxuICBwYWdlUHJldmlvdXMoKSB7XG4gICAgdGhpcy5jdXJyZW50UGFnZU51bWJlciEtLTtcbiAgICB0aGlzLmN1cnJlbnRQYWdlVXJsID0gdGhpcy5wcmV2aW91c1BhZ2VVcmw7XG4gIH07XG5cbiAgcmVjb3JkUGVyUGFnZUNoYW5nZSgpIHtcbiAgICB0aGlzLmN1cnJlbnRQYWdlTnVtYmVyID0gMTtcbiAgICB0aGlzLmN1cnJlbnRQYWdlVXJsID0gdW5kZWZpbmVkO1xuICB9XG5cbiAgZ290b1BhZ2UocGFnZTogbnVtYmVyKSB7XG4gICAgdGhpcy5jdXJyZW50UGFnZU51bWJlciA9IHBhZ2U7XG4gICAgdGhpcy5jdXJyZW50UGFnZVVybCA9IHRoaXMuZ290b1BhZ2VVcmwgPyBgJHt0aGlzLmdvdG9QYWdlVXJsfSR7cGFnZX1gIDogdW5kZWZpbmVkO1xuICB9XG59XG4iXX0=