/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import * as i0 from "@angular/core";
export class EmbedService {
    constructor() {
        this.eventData = new BehaviorSubject(null);
        window.isEmbed = false;
    }
    getEventData() {
        return this.eventData.asObservable();
    }
    setEventData(data) {
        this.eventData.next(data);
    }
    sendEventData(message) {
        parent.postMessage(message, window.parentOrigin);
    }
    setEmbedContext() {
        window.isEmbed = true;
        window.parentOrigin = new URLSearchParams(location.search).get('origin');
    }
    static { this.ɵfac = function EmbedService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EmbedService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: EmbedService, factory: EmbedService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EmbedService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();
//# sourceMappingURL=data:application/json;base64,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