import { Injectable } from '@angular/core';
import { map } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "ngx-filesaver";
export class FileService {
    constructor(http, fileSaverService) {
        this.http = http;
        this.fileSaverService = fileSaverService;
    }
    download(file) {
        return this.downloadBinaryFromIri(file.iri, file.mimeType, file.filename);
    }
    downloadBinaryFromIri(filePath, mimeType = '', filename = 'file') {
        return this.http.get(filePath, {
            responseType: 'arraybuffer',
            headers: {
            // 'Accept': 'application/octet-stream'
            }
        }).pipe(map((response) => {
            let blob = new Blob([response], {
                type: mimeType
            });
            this.fileSaverService.save(blob, filename);
        }));
    }
    upload(file, iri) {
        const formData = new FormData();
        formData.append('file', file);
        return this.http.post(iri, formData);
    }
    downloadJsonFile(data, fileName) {
        let json = JSON.stringify(data);
        let blob = new Blob([json], {
            type: 'application/json;charset=utf-8;'
        });
        this.fileSaverService.save(blob, fileName + '.json');
    }
    static { this.ɵfac = function FileService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FileService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.FileSaverService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FileService, factory: FileService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FileService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.FileSaverService }], null); })();
//# sourceMappingURL=data:application/json;base64,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