import { Injectable } from '@angular/core';
import { forkJoin, of } from 'rxjs';
import { map } from 'rxjs/operators';
import { ALL_RECORDS_SIZE, API, MMD } from '../constants';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./storage.service";
export class ModelMetadataService {
    constructor(http, storage) {
        this.http = http;
        this.storage = storage;
    }
    loadAllModules(forceUpdate = false) {
        return forkJoin([
            this.getModuleList(false, forceUpdate),
            this.getSystemModules(),
        ]);
    }
    getModuleList(staging = false, forceUpdateModelMeta = false) {
        const KEY = staging ? MMD.STAGING_METADATAS_KEY : MMD.MODEL_METADATAS_KEY;
        const modelMetadatas = (staging || forceUpdateModelMeta) ? null : this.storage.getItem(KEY);
        if (modelMetadatas === null) {
            return this.http
                .get(API.BASE + KEY, {
                params: {
                    limit: ALL_RECORDS_SIZE,
                    $relationships: true,
                    $orderby: 'type',
                },
            })
                .pipe(map((response) => {
                const metadata = response['hydra:member'];
                if (staging === false) {
                    this.storage.setItem(KEY, modelMetadatas);
                    metadata.forEach((model) => {
                        this.storage.setItem('metadata.' + model.type, model);
                    });
                }
                return metadata;
            }));
        }
        else {
            return of(modelMetadatas);
        }
    }
    getSystemModules() {
        return this.http.get(API.SYSTEM_MODULES).pipe(map((systemModelMetadatas) => {
            if (systemModelMetadatas) {
                systemModelMetadatas.forEach((systemModel) => {
                    this.storage.setItem('metadata.' + systemModel.type, systemModel);
                });
            }
            return systemModelMetadatas;
        }));
    }
    getMetadataByModuleType(type) {
        let modelMetadata = this.storage.getItem('metadata.' + type);
        if (!modelMetadata) {
            console.warn(type + ' module metadata not found');
            return;
        }
        //modelMetadata.attributes = modelMetadata.attributes.filter((attribute: any) => attribute.name !== 'uuid');
        return modelMetadata;
    }
    static { this.ɵfac = function ModelMetadataService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ModelMetadataService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ModelMetadataService, factory: ModelMetadataService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModelMetadataService, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.StorageService }], null); })();
//# sourceMappingURL=data:application/json;base64,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