import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import { map } from 'rxjs/operators';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
export class PagedCollectionService {
    constructor(http) {
        this.http = http;
        this.countCache = {};
    }
    getCount(uuid) {
        this.countCache[uuid] = this.countCache[uuid] || new BehaviorSubject(0);
        return this.countCache[uuid];
    }
    setCount(uuid, count) {
        this.countCache[uuid] = this.countCache[uuid] || new BehaviorSubject(0);
        this.countCache[uuid].next(count);
    }
    load(pagedCollection, query, uuid) {
        if (uuid) {
            this.countCache[uuid] = this.countCache[uuid] || new BehaviorSubject(0);
        }
        let params = pagedCollection.getURLData(query);
        // if (params.requestType === 'post') {
        //   return this.http.post(params.url, params.payload, { params: params.queryParams }).pipe(
        //     map((result: any) => {
        //       pagedCollection.setPage(result, query);
        //       if (uuid) {
        //         this.setCount(uuid, pagedCollection.totalItems || 0);
        //       }
        //       return pagedCollection;
        //     })
        //   );
        // } else {
        let queryParams = query.getURLQuery(pagedCollection.entity);
        return this.http.get(params.url, { params: queryParams }).pipe(map((result) => {
            pagedCollection.setPage(result, query);
            if (uuid) {
                this.setCount(uuid, pagedCollection.totalItems || 0);
            }
            return pagedCollection;
        }));
        // }
    }
    static { this.ɵfac = function PagedCollectionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PagedCollectionService)(i0.ɵɵinject(i1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PagedCollectionService, factory: PagedCollectionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PagedCollectionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }], null); })();
//# sourceMappingURL=data:application/json;base64,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