/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable } from '@angular/core';
import timezoneData from '../../data/timezones.json';
import * as i0 from "@angular/core";
export class TimezoneService {
    constructor() { }
    getList() {
        const timezones = timezoneData.timezones;
        return timezones;
    }
    getUtcList() {
        return this.getList().map((timezone) => {
            return timezone.utc.map((value) => {
                return {
                    value: value,
                    abbr: timezone.abbr,
                    text: `${value} (${timezone.abbr})`,
                    utcOffset: timezone.utcOffset
                };
            });
        }).flat();
    }
    getTimezoneByName(name) {
        const timezones = this.getUtcList();
        return timezones.find(timezone => timezone.value === name);
    }
    getTimezoneByAbbr(abbr) {
        const timezones = timezoneData.timezones;
        return timezones.find(timezone => timezone.abbr === abbr);
    }
    getLocalTimezone() {
        const list = this.getList();
        const localTimezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
        return list.find((timezone) => timezone.utc.indexOf(localTimezone) > -1);
    }
    static { this.ɵfac = function TimezoneService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TimezoneService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: TimezoneService, factory: TimezoneService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TimezoneService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();
//# sourceMappingURL=data:application/json;base64,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