/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, EventEmitter, inject, Input, Output, ViewChild } from '@angular/core';
import { FieldOptions } from '../../models/field-options';
import { FieldService } from '../../../core/services/field.service';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
const _c0 = ["inputField"];
export class AbstractFieldComponent {
    constructor(changeDetectorRef, formBuilder) {
        this.changeDetectorRef = changeDetectorRef;
        this.formBuilder = formBuilder;
        this.fieldOptions = new FieldOptions();
        this.autoFocus = false;
        this.jinjaToggled = new EventEmitter();
        this.onSubmit = new EventEmitter();
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.isDisabled = false;
        this.fieldService = inject(FieldService);
    }
    ngAfterViewInit() {
        if (this.autoFocus) {
            this.inputField?.nativeElement.focus();
            this.inputField?.nativeElement.setAttribute('ngbAutofocus', '');
        }
        if (this.isDisabled) {
            this.fieldGroup?.get('input')?.disable();
        }
    }
    ngOnInit() {
        this.fieldGroup = this.formBuilder.group({
            input: [this.value, this.fieldService.getValidators(this.field)]
        });
    }
    setDisabledState(isDisabled) {
        this.isDisabled = isDisabled;
        if (isDisabled) {
            this.fieldGroup?.get('input')?.disable();
        }
        else {
            this.fieldGroup?.get('input')?.enable();
        }
    }
    get value() {
        return this._value;
    }
    set value(value) {
        if (this._value !== value) {
            this._value = value;
            this.onChange(value);
            this.changeDetectorRef.detectChanges();
        }
    }
    writeValue(value) {
        this.value = value;
        if (this.fieldGroup && this.fieldGroup.controls.input) {
            this.fieldGroup.controls.input.setValue(value);
        }
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    onBlur() {
        this.onTouched();
    }
    onFocus() {
        // setTimeout(() => {
        //   if (this.inputField && 'select' in this.inputField.nativeElement) {
        //     this.inputField.nativeElement.select();
        //   }
        // });
    }
    validate(control) {
        this.control = control;
        return this.fieldGroup?.controls.input?.valid ? null : this.fieldGroup?.controls.input?.errors ?? null;
    }
    get valid() {
        return this.fieldGroup?.valid === false ? false : true;
    }
    focus() {
        this.inputField?.nativeElement.focus();
    }
    ngDoCheck() {
        if (this.fieldGroup?.touched) {
            this.control?.markAsTouched();
            return;
        }
        if (this.control?.touched && this.fieldGroup?.controls.input) {
            this.fieldGroup?.controls.input.markAsTouched();
        }
    }
    toggleJinja(jinjaEnabled) {
        this.jinjaToggled.emit(jinjaEnabled);
    }
    static { this.ɵfac = function AbstractFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractFieldComponent, selectors: [["xf-abstract-field"]], viewQuery: function AbstractFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.inputField = _t.first);
        } }, inputs: { field: "field", fieldOptions: "fieldOptions", fieldClass: "fieldClass", autoFocus: "autoFocus" }, outputs: { jinjaToggled: "jinjaToggled", onSubmit: "onSubmit" }, decls: 0, vars: 0, template: function AbstractFieldComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractFieldComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-field',
                template: ''
            }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.FormBuilder }], { field: [{
            type: Input
        }], fieldOptions: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }], autoFocus: [{
            type: Input
        }], jinjaToggled: [{
            type: Output
        }], onSubmit: [{
            type: Output
        }], inputField: [{
            type: ViewChild,
            args: ['inputField']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractFieldComponent, { className: "AbstractFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/abstract-field.component.ts", lineNumber: 16 }); })();
//# sourceMappingURL=data:application/json;base64,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