/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, inject } from '@angular/core';
import { FormBuilder } from '@angular/forms';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
export class CheckboxFloatingFilterComponent {
    constructor() {
        this.formBuilder = inject(FormBuilder);
        this.currentValue = 'any';
        this.valueMappings = {};
        this.formGroup = this.formBuilder.group({
            value: ['any']
        });
        this.formGroup.valueChanges.subscribe((values) => {
            this.currentValue = values.value;
            this.updateFilter();
        });
    }
    agInit(params) {
        this.params = params;
        this.valueMappings = 'values' in params.filterParams ? params.filterParams.values : {};
    }
    onParentModelChanged(parentModel) {
        // When the filter is empty we will receive a null value here
        if (!parentModel) {
            this.currentValue = 'any';
        }
        else {
            this.currentValue = parentModel.filter;
        }
    }
    updateFilter() {
        this.params.parentFilterInstance((instance) => {
            instance.onFloatingFilterChanged('boolean', this.currentValue);
        });
    }
    static { this.ɵfac = function CheckboxFloatingFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || CheckboxFloatingFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CheckboxFloatingFilterComponent, selectors: [["xf-checkbox-floating-filter"]], decls: 8, vars: 6, consts: [[1, "w-100", 3, "formGroup"], ["formControlName", "value", 1, "form-select", "form-control-xs", "w-100px"], [3, "ngValue"]], template: function CheckboxFloatingFilterComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "select", 1)(2, "option", 2);
            i0.ɵɵtext(3, "Any");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "option", 2);
            i0.ɵɵtext(5);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(6, "option", 2);
            i0.ɵɵtext(7);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngValue", "any");
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngValue", true);
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate(ctx.valueMappings.true || "Checked");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngValue", false);
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate(ctx.valueMappings.false || "Unchecked");
        } }, dependencies: [i1.NgSelectOption, i1.ɵNgSelectMultipleOption, i1.SelectControlValueAccessor, i1.NgControlStatus, i1.NgControlStatusGroup, i1.FormGroupDirective, i1.FormControlName] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CheckboxFloatingFilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-checkbox-floating-filter', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"w-100\" [formGroup]=\"formGroup\">\n  <select class=\"form-select form-control-xs w-100px\" formControlName=\"value\">\n    <option [ngValue]=\"'any'\">Any</option>\n    <option [ngValue]=\"true\">{{ valueMappings.true || 'Checked' }}</option>\n    <option [ngValue]=\"false\">{{ valueMappings.false || 'Unchecked' }}</option>\n  </select>\n</div>\n" }]
    }], () => [], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(CheckboxFloatingFilterComponent, { className: "CheckboxFloatingFilterComponent", filePath: "lib/form-fields/field-renderers/built-ins/checkbox/checkbox-floating-filter/checkbox-floating-filter.component.ts", lineNumber: 16 }); })();
//# sourceMappingURL=data:application/json;base64,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