/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component } from '@angular/core';
import * as i0 from "@angular/core";
export class DatetimeGridFilterComponent {
    constructor() {
        this.currentValue = null;
    }
    agInit(params) {
        this.params = params;
    }
    isFilterActive() {
        return this.currentValue !== null;
    }
    doesFilterPass(params) {
        console.log(params);
        return params.data.year >= 2010;
    }
    getModel() {
        return this.currentValue;
    }
    setModel(model) {
        this.currentValue = model;
    }
    onFloatingFilterChanged(type, value) {
        this.currentValue = {
            filterType: 'date',
            filter: value
        };
        this.updateFilter();
    }
    updateFilter() {
        this.params.filterChangedCallback();
    }
    static { this.ɵfac = function DatetimeGridFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DatetimeGridFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DatetimeGridFilterComponent, selectors: [["xf-datetime-grid-filter"]], decls: 0, vars: 0, template: function DatetimeGridFilterComponent_Template(rf, ctx) { } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DatetimeGridFilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-datetime-grid-filter', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<!-- <h1>Should not be visible</h1> -->\n" }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(DatetimeGridFilterComponent, { className: "DatetimeGridFilterComponent", filePath: "lib/form-fields/field-renderers/built-ins/datetime/datetime-grid-filter/datetime-grid-filter.component.ts", lineNumber: 16 }); })();
//# sourceMappingURL=data:application/json;base64,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