/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { FormBuilder } from '@angular/forms';
import { isEqual, isObject } from 'lodash-es';
import { distinctUntilChanged, map } from 'rxjs/operators';
import { FieldOptions } from '../../../models/field-options';
import * as i0 from "@angular/core";
import * as i1 from "../../../../core/services/utility.service";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/common";
import * as i4 from "../form-field/form-field.component";
import * as i5 from "../form-view/form-view.component";
const _c0 = ["formField"];
const _c1 = a0 => ({ "editable": a0 });
function EditableFieldComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 6);
    i0.ɵɵlistener("click", function EditableFieldComponent_div_0_div_1_Template_div_click_0_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.toggleEditMode()); });
    i0.ɵɵelement(1, "xf-form-view", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(5, _c1, !ctx_r1.readOnly));
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r1.field)("fieldClass", ctx_r1.fieldClass)("value", ctx_r1.value)("fieldOptions", ctx_r1.fieldOptions);
} }
function EditableFieldComponent_div_0_form_2_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "form", 8);
    i0.ɵɵlistener("ngSubmit", function EditableFieldComponent_div_0_form_2_Template_form_ngSubmit_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.onSave()); });
    i0.ɵɵelement(1, "xf-form-field", 9, 0);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵclassMapInterpolate1("", ctx_r1.field.formType, "-form-type-container");
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(9, _c1, ctx_r1.field.alwaysEditMode))("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r1.field)("fieldOptions", ctx_r1.fieldOptions)("fieldClass", ctx_r1.fieldClass)("autoFocus", ctx_r1.autoFocus);
} }
function EditableFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵtemplate(1, EditableFieldComponent_div_0_div_1_Template, 2, 7, "div", 4)(2, EditableFieldComponent_div_0_form_2_Template, 3, 11, "form", 5);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.editMode && !ctx_r1.field.alwaysEditMode || ctx_r1.readOnly);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r1.editMode || ctx_r1.field.alwaysEditMode) && ctx_r1.formGroup && !ctx_r1.readOnly);
} }
function EditableFieldComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 10);
} }
export class EditableFieldComponent {
    constructor(utilityService, formBuilder, elementRef, changeDetectorRef) {
        this.utilityService = utilityService;
        this.formBuilder = formBuilder;
        this.elementRef = elementRef;
        this.changeDetectorRef = changeDetectorRef;
        this.editMode = false;
        this.readOnly = false;
        this.showLabel = false;
        this.showInline = false;
        this.disableSubmitOnEnter = false;
        this.autoFocus = false;
        this.editModeChange = new EventEmitter();
        this.valueChange = new EventEmitter();
        this.onSubmit = new EventEmitter();
    }
    ngOnChanges(changes) {
        if (changes.value && !changes.value.firstChange) {
            this.formGroup?.setValue({
                editableField: this.value
            });
        }
        this.changeDetectorRef.detectChanges();
    }
    ngDoCheck() {
        if (isObject(this.value) && this.value['@id'] !== this.oldValueIri) {
            this.oldValueIri = this.value['@id'];
            this.formGroup?.setValue({
                editableField: this.value
            });
            this.changeDetectorRef.detectChanges();
        }
    }
    ngOnInit() {
        this.formGroup = this.formBuilder.group({
            editableField: []
        });
        this.fieldOptions = new FieldOptions({
            showLabel: this.showLabel,
            size: this.size
        });
        if (this.value) {
            this.formGroup?.setValue({
                editableField: this.value
            });
        }
        this.changeDetectorRef.detectChanges();
        this.formGroup.valueChanges
            .pipe(distinctUntilChanged(), map(values => values.editableField)).subscribe((value) => {
            if (!this.field) {
                return;
            }
            if (isEqual(this.value, value)) {
                return;
            }
            this.value = value;
            this.valueChange.emit(this.value);
            if (this.field.alwaysEditMode) {
                this.onSave();
            }
        });
    }
    ngOnDestroy() {
        this.unsubscribe();
    }
    subscribe() {
        this.subscription = this.utilityService.documentClickedTarget
            .subscribe(event => this.handleClickEvent(event));
    }
    unsubscribe() {
        this.subscription?.unsubscribe();
        this.subscription = undefined;
    }
    toggleEditMode() {
        if (this.readOnly) {
            return;
        }
        this.editMode = true;
        this.editModeChange.emit(this.editMode);
        this.changeDetectorRef.detectChanges();
        this.formField.focus();
        this.unsubscribe();
        setTimeout(() => this.subscribe());
    }
    handleClickEvent(event) {
        if (!this.elementRef.nativeElement.contains(event.target) && this.editMode) {
            this.onSave();
        }
    }
    onSave() {
        if (this.formGroup?.invalid) {
            return;
        }
        this.value = this.formGroup?.value.editableField;
        this.valueChange.emit(this.value);
        this.editMode = false;
        this.editModeChange.emit(this.editMode);
        this.onSubmit.emit();
        this.unsubscribe();
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function EditableFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EditableFieldComponent)(i0.ɵɵdirectiveInject(i1.UtilityService), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: EditableFieldComponent, selectors: [["xf-editable-field"]], viewQuery: function EditableFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formField = _t.first);
        } }, inputs: { editMode: "editMode", readOnly: "readOnly", showLabel: "showLabel", size: "size", showInline: "showInline", disableSubmitOnEnter: "disableSubmitOnEnter", autoFocus: "autoFocus", field: "field", value: "value", fieldOptions: "fieldOptions", fieldClass: "fieldClass" }, outputs: { editModeChange: "editModeChange", valueChange: "valueChange", onSubmit: "onSubmit" }, features: [i0.ɵɵProvidersFeature([FormBuilder]), i0.ɵɵNgOnChangesFeature], decls: 2, vars: 2, consts: [["formField", ""], ["class", "editable-field-container", 4, "ngIf"], ["class", "bg-shimmer title-line", 4, "ngIf"], [1, "editable-field-container"], [3, "ngClass", "click", 4, "ngIf"], [3, "ngClass", "class", "formGroup", "ngSubmit", 4, "ngIf"], [3, "click", "ngClass"], [3, "field", "fieldClass", "value", "fieldOptions"], [3, "ngSubmit", "ngClass", "formGroup"], ["formControlName", "editableField", 3, "field", "fieldOptions", "fieldClass", "autoFocus"], [1, "bg-shimmer", "title-line"]], template: function EditableFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, EditableFieldComponent_div_0_Template, 3, 2, "div", 1)(1, EditableFieldComponent_div_1_Template, 1, 0, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.field && ctx.fieldOptions);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.editMode && (!ctx.field || ctx.value === undefined));
        } }, dependencies: [i3.NgClass, i3.NgIf, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i4.FormFieldComponent, i5.FormViewComponent], styles: [".editable-field-container[_ngcontent-%COMP%]   .editable[_ngcontent-%COMP%]:hover{background:var(--form-default-bg-color);cursor:pointer}.editable-field-container[_ngcontent-%COMP%]   .editable[_ngcontent-%COMP%]:hover.form-select{background:inherit}.editable-field-container[_ngcontent-%COMP%]   .editable.picklist-form-type-container[_ngcontent-%COMP%]:hover{background:none}.editable-field-container[_ngcontent-%COMP%]   .form-control[_ngcontent-%COMP%]:focus, .editable-field-container[_ngcontent-%COMP%]   .form-control[_ngcontent-%COMP%]:active{background:var(--form-default-bg-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EditableFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-editable-field', providers: [FormBuilder], changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div *ngIf=\"field && fieldOptions\" class=\"editable-field-container\">\n  <div [ngClass]=\"{'editable': !readOnly}\" *ngIf=\"(!editMode && !field.alwaysEditMode) || readOnly\" (click)=\"toggleEditMode()\">\n    <xf-form-view [field]=\"field\" [fieldClass]=\"fieldClass\" [value]=\"value\" [fieldOptions]=\"fieldOptions\"></xf-form-view>\n  </div>\n  <form *ngIf=\"(editMode || field.alwaysEditMode) && formGroup && !readOnly\" [ngClass]=\"{'editable': field.alwaysEditMode}\" class=\"{{field.formType}}-form-type-container\" [formGroup]=\"formGroup\" (ngSubmit)=\"onSave()\">\n    <xf-form-field formControlName=\"editableField\" [field]=\"field\" [fieldOptions]=\"fieldOptions\" [fieldClass]=\"fieldClass\" #formField [autoFocus]=\"autoFocus\"></xf-form-field>\n  </form>\n</div>\n<div *ngIf=\"!editMode && (!field || value === undefined)\" class=\"bg-shimmer title-line\"></div>\n", styles: [".editable-field-container .editable:hover{background:var(--form-default-bg-color);cursor:pointer}.editable-field-container .editable:hover.form-select{background:inherit}.editable-field-container .editable.picklist-form-type-container:hover{background:none}.editable-field-container .form-control:focus,.editable-field-container .form-control:active{background:var(--form-default-bg-color)}\n"] }]
    }], () => [{ type: i1.UtilityService }, { type: i2.FormBuilder }, { type: i0.ElementRef }, { type: i0.ChangeDetectorRef }], { editMode: [{
            type: Input
        }], readOnly: [{
            type: Input
        }], showLabel: [{
            type: Input
        }], size: [{
            type: Input
        }], showInline: [{
            type: Input
        }], disableSubmitOnEnter: [{
            type: Input
        }], autoFocus: [{
            type: Input
        }], editModeChange: [{
            type: Output
        }], valueChange: [{
            type: Output
        }], onSubmit: [{
            type: Output
        }], field: [{
            type: Input
        }], value: [{
            type: Input
        }], formField: [{
            type: ViewChild,
            args: ['formField']
        }], fieldOptions: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(EditableFieldComponent, { className: "EditableFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/editable-field/editable-field.component.ts", lineNumber: 24 }); })();
//# sourceMappingURL=data:application/json;base64,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