/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, EventEmitter, forwardRef, Input, Output, ViewChild } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR } from '@angular/forms';
import { FieldOptions } from '../../../models/field-options';
import { ViewContainerDirective } from '../../../../utility/directives/view-container.directive';
import * as i0 from "@angular/core";
import * as i1 from "../../../../utility/directives/view-container.directive";
function FormFieldComponent_ng_template_0_Template(rf, ctx) { }
export class FormFieldComponent {
    constructor() {
        this.autoFocus = false;
        this.fieldOptions = new FieldOptions();
        this.jinjaToggled = new EventEmitter();
        this.onSubmit = new EventEmitter();
    }
    ngOnInit() {
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        if (this.field) {
            this.componentRef = viewContainerRef.createComponent(this.field.fieldComponent);
            this.componentRef.instance.field = this.field;
            this.componentRef.instance.autoFocus = this.autoFocus;
            this.componentRef.instance.fieldOptions = this.fieldOptions;
            this.componentRef.instance.fieldClass = this.fieldClass;
            this.componentRef.instance.jinjaToggled = this.jinjaToggled;
            this.componentRef.instance.onSubmit = this.onSubmit;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
    }
    ngOnChanges(changes) {
        if (this.componentRef) {
            if (!changes.field?.firstChange && changes.field?.currentValue.formType !== changes.field?.previousValue.formType) {
                this.ngOnInit();
                return;
            }
        }
    }
    writeValue(value) {
        if (this.componentRef) {
            this.componentRef.instance.writeValue(value);
        }
    }
    setDisabledState(isDisabled) {
        if (this.componentRef) {
            this.componentRef.instance.setDisabledState(isDisabled);
        }
    }
    registerOnChange(fn) {
        if (this.componentRef) {
            this.componentRef.instance.registerOnChange(fn);
        }
    }
    registerOnTouched(fn) {
        if (this.componentRef) {
            this.componentRef.instance.registerOnTouched(fn);
        }
    }
    validate(control) {
        if (this.componentRef) {
            return this.componentRef.instance.validate(control);
        }
        else {
            return null;
        }
    }
    get valid() {
        return this.componentRef.instance.valid;
    }
    focus() {
        if (this.componentRef) {
            this.componentRef.instance.focus();
        }
    }
    static { this.ɵfac = function FormFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FormFieldComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FormFieldComponent, selectors: [["xf-form-field"]], viewQuery: function FormFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
        } }, inputs: { field: "field", autoFocus: "autoFocus", fieldOptions: "fieldOptions", fieldClass: "fieldClass" }, outputs: { jinjaToggled: "jinjaToggled", onSubmit: "onSubmit" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => FormFieldComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => FormFieldComponent),
                    multi: true
                }]), i0.ɵɵNgOnChangesFeature], decls: 1, vars: 0, consts: [["xfViewContainer", ""]], template: function FormFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FormFieldComponent_ng_template_0_Template, 0, 0, "ng-template", 0);
        } }, dependencies: [i1.ViewContainerDirective] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FormFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-form-field', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => FormFieldComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => FormFieldComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<ng-template xfViewContainer></ng-template>\n" }]
    }], () => [], { field: [{
            type: Input
        }], autoFocus: [{
            type: Input
        }], fieldOptions: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }], jinjaToggled: [{
            type: Output
        }], onSubmit: [{
            type: Output
        }], xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: true }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FormFieldComponent, { className: "FormFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/form-field/form-field.component.ts", lineNumber: 27 }); })();
//# sourceMappingURL=data:application/json;base64,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