/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, ViewChild, inject } from '@angular/core';
import { Subject } from 'rxjs';
import { map } from 'rxjs/operators';
import { SearchableDropdownComponent } from '../../../../components/searchable-dropdown/searchable-dropdown.component';
import { SearchableItem } from '../../../../components/searchable-dropdown/searchable-item';
import { ApiService } from '../../../../core/services/api.service';
import { EntityService } from '../../../../core/services/entity.service';
import { Query } from '../../../../query-filters/models/query';
import { AbstractFieldComponent } from '../abstract-field.component';
import { DEFAULT_LOOKUP_RECORDS } from '../../../../core/constants';
import { plainToInstance } from 'class-transformer';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "../../../../utility/pipes/interpolate.pipe";
import * as i3 from "@angular/common";
import * as i4 from "../../../../components/searchable-dropdown/searchable-dropdown.component";
import * as i5 from "@ng-bootstrap/ng-bootstrap";
const _c0 = ["searchInput"];
function LookupFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 8);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function LookupFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 9);
    i0.ɵɵelement(1, "i", 10);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r1.field.tooltip);
} }
function LookupFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 5);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, LookupFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 6)(3, LookupFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", ctx_r1.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("", ctx_r1.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.validation == null ? null : ctx_r1.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.tooltip);
} }
function LookupFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, LookupFieldComponent_div_0_label_1_Template, 4, 4, "label", 2);
    i0.ɵɵelementStart(2, "div", 3)(3, "xf-searchable-dropdown", 4);
    i0.ɵɵlistener("searchQueryChange", function LookupFieldComponent_div_0_Template_xf_searchable_dropdown_searchQueryChange_3_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.loadItems($event)); });
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r1.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("items", ctx_r1.items)("buttonStyle", ctx_r1.field.params == null ? null : ctx_r1.field.params.style)("placeholder", ctx_r1.field.placeholder)("clearText", ctx_r1.field.params == null ? null : ctx_r1.field.params.clearText);
} }
export class LookupFieldComponent extends AbstractFieldComponent {
    constructor(_changeDetectorRef, _formBuilder, interpolate) {
        super(_changeDetectorRef, _formBuilder);
        this.interpolate = interpolate;
        this.searchText = '';
        this.loading = false;
        this.searchQueryChange = new Subject();
        this.items = [];
        this.entityService = inject(EntityService);
        this.apiService = inject(ApiService);
    }
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((item) => {
            this.value = item?.value || null;
        });
    }
    ngAfterViewInit() {
        if (this.field && this.field.model) {
            this.entityService.build(this.field.model).subscribe((entity) => {
                this.entity = entity;
                if (this._value) {
                    this.setDisplayValue(this._value);
                }
            });
        }
    }
    loadItems(search) {
        if (!this.field.dataSource) {
            console.warn('No model specified for lookup');
            return;
        }
        let queryObject = new Query({
            filters: [],
            logic: 'AND'
        });
        if (this.field.dataSource.query) {
            queryObject.filters.push(this.field.dataSource.query);
        }
        if (search) {
            let searchQuery = this.entityService.buildSearchQueryFromDisplayName(this.entity, search);
            queryObject.filters.push(searchQuery.asFilterGroup());
        }
        const query = plainToInstance(Query, queryObject);
        this.apiService.query(this.entity, query.getQueryObject(), {
            limit: DEFAULT_LOOKUP_RECORDS
        }).pipe(map((response) => {
            let data = response['hydra:member'];
            let searchableItems = data.map((item) => {
                const display = this.interpolate.transform(this.entity.displayName, item);
                return new SearchableItem(display, item, item.uuid);
            });
            return searchableItems;
        }))
            .subscribe((searchableItems) => {
            this.items = searchableItems;
            this.changeDetectorRef.detectChanges();
        });
    }
    set value(value) {
        if (this._value !== value) {
            this._value = value;
            this.setDisplayValue(value);
            this.onChange(value);
            this.changeDetectorRef.detectChanges();
        }
    }
    writeValue(value) {
        this.value = value;
        this.setDisplayValue(value);
    }
    setDisplayValue(value) {
        if (value && this.entity) {
            const display = this.interpolate.transform(this.entity.displayName, value);
            this.fieldGroup?.get('input')?.setValue(new SearchableItem(display, value, value.uuid));
        }
    }
    selectItem(item) {
        this.value = item;
        this.inputField?.nativeElement.focus();
    }
    focus() {
        this.dropdown.focus();
    }
    static { this.ɵfac = function LookupFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LookupFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.FormBuilder), i0.ɵɵdirectiveInject(i2.InterpolatePipe)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LookupFieldComponent, selectors: [["xf-field-lookup"]], viewQuery: function LookupFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(SearchableDropdownComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchInput = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdown = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label", 3, "for", 4, "ngIf"], [1, "picklist-field-container"], ["container", "body", "formControlName", "input", 3, "searchQueryChange", "items", "buttonStyle", "placeholder", "clearText"], [1, "form-label", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"]], template: function LookupFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LookupFieldComponent_div_0_Template, 4, 6, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i3.NgIf, i1.NgControlStatus, i1.NgControlStatusGroup, i1.FormGroupDirective, i1.FormControlName, i4.SearchableDropdownComponent, i5.NgbTooltip] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LookupFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-lookup', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"field.name\" *ngIf=\"fieldOptions.showLabel\" class=\"form-label\">{{ field.title}}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"picklist-field-container\">\n    <xf-searchable-dropdown container=\"body\" formControlName=\"input\" [items]=\"items\"\n      (searchQueryChange)=\"loadItems($event)\" [buttonStyle]=\"field.params?.style\"\n      [placeholder]=\"field.placeholder\" [clearText]=\"field.params?.clearText\"></xf-searchable-dropdown>\n  </div>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.FormBuilder }, { type: i2.InterpolatePipe }], { searchInput: [{
            type: ViewChild,
            args: ['searchInput']
        }], dropdown: [{
            type: ViewChild,
            args: [SearchableDropdownComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LookupFieldComponent, { className: "LookupFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/lookup/lookup-field.component.ts", lineNumber: 26 }); })();
//# sourceMappingURL=data:application/json;base64,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