import { Component, Input, ViewChild } from '@angular/core';
import { of } from 'rxjs';
import { concatMap, map } from 'rxjs/operators';
import { API } from '../../../../core/constants';
import { AbstractFieldComponent } from '../abstract-field.component';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "../../../../core/services/entity.service";
import * as i3 from "@angular/forms";
import * as i4 from "@angular/common";
import * as i5 from "ng-multiselect-dropdown";
import * as i6 from "@ng-bootstrap/ng-bootstrap";
import * as i7 from "../../../form-messages/form-messages.component";
const _c0 = ["multiselect"];
const _c1 = a0 => ({ "pe-0": a0 });
const _c2 = a0 => ({ "is-invalid": a0 });
function MultiselectFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 12);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function MultiselectFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 13);
    i0.ɵɵelement(1, "i", 14);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function MultiselectFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 9);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, MultiselectFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 10)(3, MultiselectFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 11);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "multiselect-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function MultiselectFieldComponent_div_0_xf_form_messages_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 15);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input);
} }
function MultiselectFieldComponent_div_0_div_7_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 18);
    i0.ɵɵlistener("click", function MultiselectFieldComponent_div_0_div_7_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r0.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function MultiselectFieldComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵtemplate(1, MultiselectFieldComponent_div_0_div_7_button_1_Template, 2, 3, "button", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
function MultiselectFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, MultiselectFieldComponent_div_0_label_1_Template, 4, 4, "label", 3);
    i0.ɵɵelementStart(2, "div", 4)(3, "div", 5);
    i0.ɵɵelement(4, "ng-multiselect-dropdown", 6, 0);
    i0.ɵɵtemplate(6, MultiselectFieldComponent_div_0_xf_form_messages_6_Template, 1, 1, "xf-form-messages", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, MultiselectFieldComponent_div_0_div_7_Template, 2, 1, "div", 8);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(10, _c1, ctx_r0.field.allowJinjaToggle));
    i0.ɵɵadvance();
    i0.ɵɵproperty("id", "multiselect-" + ctx_r0.field.name)("placeholder", ctx_r0.field.placeholder || "")("settings", ctx_r0.dropdownSettings)("data", ctx_r0.options)("ngClass", i0.ɵɵpureFunction1(12, _c2, ctx_r0.fieldGroup.controls.input.invalid && ctx_r0.fieldGroup.controls.input.touched));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showError);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
export class MultiselectFieldComponent extends AbstractFieldComponent {
    constructor(http, entityService, changeDetectorRef, formBuilder) {
        super(changeDetectorRef, formBuilder);
        this.http = http;
        this.entityService = entityService;
        this.options = [];
        this.dropdownSettings = {
            singleSelection: false,
            idField: 'value',
            textField: 'label',
            selectAllText: 'Select All',
            unSelectAllText: 'Deselect All',
            allowSearchFilter: true
        };
    }
    get value() {
        return this._value;
    }
    set value(value) {
        if (this._value !== value) {
            this._value = value;
            this.onChange(value);
            this.setSelectedOptions(value);
            this.changeDetectorRef.detectChanges();
        }
    }
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((options) => {
            const value = options.map((option) => option.value);
            this.onChange(value);
        });
        let options$;
        if (this.fieldOptions.options.length || this.field.options.length) {
            let options = this.fieldOptions.options.length > 0 ? this.fieldOptions.options : this.field.options || [];
            options$ = of(options);
        }
        else if (this.field.dataSource?.model) {
            options$ = this.entityService.build(this.field.dataSource.model).pipe(concatMap((entity) => {
                const url = `${this.field.dataSource.baseURL || API.QUERY}${this.field.dataSource.model}/`;
                const request = this.field.dataSource.requestType === 'GET' ? this.http.get(url, this.field.dataSource.query) : this.http.post(url, this.field.dataSource.query);
                return request.pipe(map((response) => {
                    return response['hydra:member'].map((item) => {
                        return {
                            value: item['@id'] || item.uuid,
                            label: this.entityService.getDisplayValue(entity, item)
                        };
                    });
                }));
            }));
        }
        else {
            options$ = of([]);
        }
        options$.subscribe((options) => {
            this.options = options;
            this.setSelectedOptions(this.value, false);
            this.changeDetectorRef.detectChanges();
        });
    }
    setSelectedOptions(value, emitEvent = true) {
        if (value && this.fieldGroup && this.fieldGroup.controls.input) {
            const selectedOptions = this.options.filter((option) => value.indexOf(option.value) > -1);
            this.fieldGroup?.controls.input.setValue(selectedOptions, { emitEvent: emitEvent });
        }
    }
    focus() {
        // not possible with ng-multiselect :/
    }
    static { this.ɵfac = function MultiselectFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || MultiselectFieldComponent)(i0.ɵɵdirectiveInject(i1.HttpClient), i0.ɵɵdirectiveInject(i2.EntityService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i3.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: MultiselectFieldComponent, selectors: [["xf-multiselect-field"]], viewQuery: function MultiselectFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.multiselect = _t.first);
        } }, inputs: { field: "field" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["multiselect", ""], ["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "d-flex"], [1, "flex-grow-1", 3, "ngClass"], ["formControlName", "input", 1, "multiselect-dropdown-wrapper", 3, "id", "placeholder", "settings", "data", "ngClass"], [3, "control", 4, "ngIf"], ["class", "w-auto ps-2", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [3, "control"], [1, "w-auto", "ps-2"], ["type", "button", "class", "btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], ["type", "button", "title", "Add Custom Expression", 1, "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"]], template: function MultiselectFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, MultiselectFieldComponent_div_0_Template, 8, 14, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i4.NgClass, i4.NgIf, i3.NgControlStatus, i3.NgControlStatusGroup, i3.FormGroupDirective, i3.FormControlName, i5.MultiSelectComponent, i6.NgbTooltip, i7.FormMessagesComponent], styles: [".multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn{border-color:var(--form-default-border-color)!important;padding:8px!important;font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .selected-item{font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .selected-item a{color:rgb(var(--bs-danger-rgb))!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret{background-image:var(--form-select-dropdown-svg);background-repeat:no-repeat;background-position:right .75rem center;background-size:16px 12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret:before{content:unset!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list{background-color:var(--form-secondary-border-color);border-color:var(--form-default-border-color);box-shadow:0 1px 5px var(--form-default-border-color);margin-top:0}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .item1 .multiselect-item-checkbox{border-bottom:1px solid var(--form-default-border-color)!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .no-filtered-data h5{font-size:14px;opacity:.7}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox{border-bottom:1px solid var(--form-default-border-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox input{color:var(--form-field-input-font-color);background-color:var(--form-default-bg-color);border:1px solid var(--form-default-border-color)!important;padding:5px 5px 5px 40px!important;font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox input:focus{box-shadow:var(--form-default-box-shadow);background-color:var(--form-default-bg-color);color:var(--form-field-input-focus-font-color);border-color:var(--form-default-focus-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox:before{content:\"\\f002\";display:inline-block;position:absolute;font-family:\"Font Awesome 6 Pro\";opacity:.5;font-size:14px;top:11px;left:12px;padding:4px 8px;border-right:1px solid var(--border-primary-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]{background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);color:var(--form-field-input-font-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]:checked+div:before{background-color:var(--highlight-active-color);background-image:var(--form-checkbox-bg-svg);background-position:center}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div{color:var(--font-primary-color);font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:before{background-color:var(--form-default-bg-color);border-color:var(--form-check-border-color);color:var(--form-field-input-font-color);border-radius:4px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:after{content:unset!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox:hover{background-color:var(--element-inverse-bg-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiselectFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-multiselect-field', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'multiselect-' + field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"d-flex\">\n    <div class=\"flex-grow-1\" [ngClass]=\"{'pe-0': field.allowJinjaToggle}\">\n      <ng-multiselect-dropdown [id]=\"'multiselect-' + field.name\" [placeholder]=\"field.placeholder || ''\"\n        [settings]=\"dropdownSettings\" [data]=\"options\" formControlName=\"input\" class=\"multiselect-dropdown-wrapper\"\n        [ngClass]=\"{'is-invalid': fieldGroup.controls.input.invalid && fieldGroup.controls.input.touched}\"\n        #multiselect></ng-multiselect-dropdown>\n      <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.input\"></xf-form-messages>\n    </div>\n    <div class=\"w-auto ps-2\" *ngIf=\"field.allowJinjaToggle\">\n      <button type=\"button\" class=\"btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n  </div>\n\n</div>\n", styles: [".multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn{border-color:var(--form-default-border-color)!important;padding:8px!important;font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .selected-item{font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .selected-item a{color:rgb(var(--bs-danger-rgb))!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret{background-image:var(--form-select-dropdown-svg);background-repeat:no-repeat;background-position:right .75rem center;background-size:16px 12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret:before{content:unset!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list{background-color:var(--form-secondary-border-color);border-color:var(--form-default-border-color);box-shadow:0 1px 5px var(--form-default-border-color);margin-top:0}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .item1 .multiselect-item-checkbox{border-bottom:1px solid var(--form-default-border-color)!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .no-filtered-data h5{font-size:14px;opacity:.7}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox{border-bottom:1px solid var(--form-default-border-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox input{color:var(--form-field-input-font-color);background-color:var(--form-default-bg-color);border:1px solid var(--form-default-border-color)!important;padding:5px 5px 5px 40px!important;font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox input:focus{box-shadow:var(--form-default-box-shadow);background-color:var(--form-default-bg-color);color:var(--form-field-input-focus-font-color);border-color:var(--form-default-focus-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox:before{content:\"\\f002\";display:inline-block;position:absolute;font-family:\"Font Awesome 6 Pro\";opacity:.5;font-size:14px;top:11px;left:12px;padding:4px 8px;border-right:1px solid var(--border-primary-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]{background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);color:var(--form-field-input-font-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]:checked+div:before{background-color:var(--highlight-active-color);background-image:var(--form-checkbox-bg-svg);background-position:center}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div{color:var(--font-primary-color);font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:before{background-color:var(--form-default-bg-color);border-color:var(--form-check-border-color);color:var(--form-field-input-font-color);border-radius:4px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:after{content:unset!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox:hover{background-color:var(--element-inverse-bg-color)}\n"] }]
    }], () => [{ type: i1.HttpClient }, { type: i2.EntityService }, { type: i0.ChangeDetectorRef }, { type: i3.FormBuilder }], { field: [{
            type: Input
        }], multiselect: [{
            type: ViewChild,
            args: ['multiselect']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(MultiselectFieldComponent, { className: "MultiselectFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/multiselect/multiselect-field.component.ts", lineNumber: 28 }); })();
//# sourceMappingURL=data:application/json;base64,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