/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, Input } from '@angular/core';
import { map } from 'rxjs/operators';
import { AbstractFieldComponent } from '../abstract-field.component';
import { isString } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "./picklist.service";
import * as i2 from "@angular/forms";
import * as i3 from "../../../../core/services/theme.service";
import * as i4 from "@angular/common";
import * as i5 from "@ng-bootstrap/ng-bootstrap";
import * as i6 from "../../../../utility/pipes/is-hex-color-light.pipe";
const _c0 = (a0, a1, a2) => ({ "form-select-lg": a0, "form-select-xs": a1, "colored": a2 });
const _c1 = (a0, a1) => ({ "background": a0, "color": a1 });
function PicklistFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 10);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function PicklistFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 11);
    i0.ɵɵelement(1, "i", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function PicklistFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 7);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, PicklistFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 8)(3, PicklistFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 9);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function PicklistFieldComponent_div_0_option_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 5);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r2 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", option_r2.uuid);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(option_r2.itemValue);
} }
function PicklistFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, PicklistFieldComponent_div_0_label_1_Template, 4, 4, "label", 3);
    i0.ɵɵelementStart(2, "select", 4, 0);
    i0.ɵɵpipe(4, "isHexColorLight");
    i0.ɵɵelementStart(5, "option", 5);
    i0.ɵɵtext(6, "Select");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, PicklistFieldComponent_div_0_option_7_Template, 2, 2, "option", 6);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("form-select picklist ", ctx_r0.fieldClass, "");
    i0.ɵɵproperty("name", "picklist-" + ctx_r0.field.picklistName)("ngClass", i0.ɵɵpureFunction3(12, _c0, ctx_r0.fieldOptions.size === "large", ctx_r0.fieldOptions.size === "small", !!(ctx_r0.fieldGroup.value.input == null ? null : ctx_r0.fieldGroup.value.input.color)))("ngStyle", i0.ɵɵpureFunction2(16, _c1, (ctx_r0.fieldGroup.value.input == null ? null : ctx_r0.fieldGroup.value.input.color) ? ctx_r0.fieldGroup.value.input == null ? null : ctx_r0.fieldGroup.value.input.color : "", (ctx_r0.value == null ? null : ctx_r0.value.color) && i0.ɵɵpipeBind1(4, 10, ctx_r0.value == null ? null : ctx_r0.value.color) ? "rgba(0, 0, 0, 0.8)" : (ctx_r0.value == null ? null : ctx_r0.value.color) ? "rgba(255, 255, 255, 0.8)" : !(ctx_r0.value == null ? null : ctx_r0.value.color) && ctx_r0.currentTheme === "light" ? "rgba(0, 0, 0, 0.8)" : "rgba(255, 255, 255, 0.8)"));
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngValue", null);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r0.picklistItems);
} }
export class PicklistFieldComponent extends AbstractFieldComponent {
    constructor(picklistService, _changeDetectorRef, _formBuilder, themeService) {
        super(_changeDetectorRef, _formBuilder);
        this.picklistService = picklistService;
        this._changeDetectorRef = _changeDetectorRef;
        this._formBuilder = _formBuilder;
        this.themeService = themeService;
        this.picklistItems = [];
        this.currentTheme = this.themeService.getTheme();
    }
    ngAfterViewInit() {
        if (!this.field) {
            return;
        }
        if (this.field.picklistName == '') {
            console.warn('Picklist name not specified');
            return;
        }
        this.picklistService.loadPicklistName(this.field.picklistName).subscribe((picklistName) => {
            if (!picklistName) {
                console.warn(`Picklist ${this.field.picklistName} not found`);
                return;
            }
            this.picklistItems = picklistName.picklists;
            if (this.value || this.field.defaultValue) {
                this.value = this.picklistItems.find((item) => (this.field.defaultValue || this.value) && (this.value.uuid || this.field.defaultValue) === item.uuid);
            }
            this.changeDetectorRef.detectChanges();
        });
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((value) => {
            this.value = isString(value) ? value : value.uuid;
        });
    }
    writeValue(value) {
        if (value && this.picklistItems.length) {
            this.value = this.picklistItems.find((item) => value && value.uuid === value.uuid);
        }
        else {
            this.value = value;
        }
    }
    static { this.ɵfac = function PicklistFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PicklistFieldComponent)(i0.ɵɵdirectiveInject(i1.PicklistService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i3.ThemeService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PicklistFieldComponent, selectors: [["xf-field-picklist"]], inputs: { field: "field", fieldClass: "fieldClass" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["inputField", ""], ["class", "form-group w-fit-content", 3, "formGroup", 4, "ngIf"], [1, "form-group", "w-fit-content", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], ["formControlName", "input", 3, "name", "ngClass", "ngStyle"], [3, "ngValue"], [3, "ngValue", 4, "ngFor", "ngForOf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"]], template: function PicklistFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, PicklistFieldComponent_div_0_Template, 8, 19, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i4.NgClass, i4.NgForOf, i4.NgIf, i4.NgStyle, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i5.NgbTooltip, i6.IsHexColorLightPipe], styles: [".max-width-200[_ngcontent-%COMP%]{width:100%;max-width:200px}.picklist-search[_ngcontent-%COMP%]{width:90%;margin:10px 5% 0}.picklist[_ngcontent-%COMP%]{cursor:pointer;border-radius:4px}.picklist.colored[_ngcontent-%COMP%]{color:#ffffffb3;text-align:center}.picklist[_ngcontent-%COMP%]:focus{box-shadow:none}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PicklistFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-picklist', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group w-fit-content\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n        <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <select [name]=\"'picklist-' + field.picklistName\"\n    [ngClass]=\"{'form-select-lg': fieldOptions.size === 'large', 'form-select-xs': fieldOptions.size === 'small', 'colored': !!fieldGroup.value.input?.color}\"\n    class=\"form-select picklist {{fieldClass}}\" formControlName=\"input\" #inputField [ngStyle]=\"{\n      'background': fieldGroup.value.input?.color ? fieldGroup.value.input?.color : '',\n      'color': (value?.color) && (value?.color | isHexColorLight) ? 'rgba(0, 0, 0, 0.8)' : value?.color ? 'rgba(255, 255, 255, 0.8)' : (!value?.color && currentTheme === 'light') ? 'rgba(0, 0, 0, 0.8)' : 'rgba(255, 255, 255, 0.8)'\n    }\">\n    <option [ngValue]=\"null\">Select</option>\n    <option *ngFor=\"let option of picklistItems\" [ngValue]=\"option.uuid\">{{ option.itemValue }}</option>\n  </select>\n</div>\n", styles: [".max-width-200{width:100%;max-width:200px}.picklist-search{width:90%;margin:10px 5% 0}.picklist{cursor:pointer;border-radius:4px}.picklist.colored{color:#ffffffb3;text-align:center}.picklist:focus{box-shadow:none}\n"] }]
    }], () => [{ type: i1.PicklistService }, { type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }, { type: i3.ThemeService }], { field: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PicklistFieldComponent, { className: "PicklistFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/picklist/picklist-field.component.ts", lineNumber: 22 }); })();
//# sourceMappingURL=data:application/json;base64,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