/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component } from '@angular/core';
import { isString } from 'lodash-es';
import { AbstractViewComponent } from '../abstract-view.component';
import * as i0 from "@angular/core";
import * as i1 from "../../../../core/services/theme.service";
import * as i2 from "./picklist.service";
import * as i3 from "@angular/common";
import * as i4 from "../../../../utility/pipes/is-hex-color-light.pipe";
const _c0 = (a0, a1) => ({ "background": a0, "color": a1 });
function PicklistViewComponent_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 3);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
} }
export class PicklistViewComponent extends AbstractViewComponent {
    constructor(themeService, _changeDetectorRef, picklistService) {
        super(_changeDetectorRef);
        this.themeService = themeService;
        this._changeDetectorRef = _changeDetectorRef;
        this.picklistService = picklistService;
        this.currentTheme = this.themeService.getTheme();
    }
    ngOnInit() {
        super.ngOnInit();
        if (isString(this.value)) {
            this.picklistService.getPicklistByUUID(this.value).subscribe((value) => {
                this.value = value;
                this._changeDetectorRef.detectChanges();
            });
        }
    }
    static { this.ɵfac = function PicklistViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PicklistViewComponent)(i0.ɵɵdirectiveInject(i1.ThemeService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.PicklistService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PicklistViewComponent, selectors: [["xf-picklist-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 5, vars: 12, consts: [[1, "form-group"], ["class", "form-label margin-bottom-4px d-block", 3, "for", 4, "ngIf"], [3, "ngClass", "ngStyle"], [1, "form-label", "margin-bottom-4px", "d-block", 3, "for"]], template: function PicklistViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, PicklistViewComponent_label_1_Template, 2, 2, "label", 1);
            i0.ɵɵelementStart(2, "p", 2);
            i0.ɵɵpipe(3, "isHexColorLight");
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.fieldOptions.showLabel);
            i0.ɵɵadvance();
            i0.ɵɵclassMapInterpolate1("d-inline-block font-size-14px lh-1 minw-100px mw-fit-content picklist-view text-center ", ctx.fieldClass, "");
            i0.ɵɵproperty("ngClass", (ctx.value == null ? null : ctx.value.color) ? "content-font" : "")("ngStyle", i0.ɵɵpureFunction2(9, _c0, (ctx.value == null ? null : ctx.value.color) ? ctx.value.color : "", (ctx.value == null ? null : ctx.value.color) && i0.ɵɵpipeBind1(3, 7, ctx.value == null ? null : ctx.value.color) ? "rgba(0, 0, 0, 0.8)" : (ctx.value == null ? null : ctx.value.color) ? "rgba(255, 255, 255, 0.8)" : !(ctx.value == null ? null : ctx.value.color) && ctx.currentTheme === "light" ? "rgba(0, 0, 0, 0.8)" : "rgba(255, 255, 255, 0.8)"));
            i0.ɵɵadvance(2);
            i0.ɵɵtextInterpolate(ctx.value ? ctx.value.itemValue : "--");
        } }, dependencies: [i3.NgClass, i3.NgIf, i3.NgStyle, i4.IsHexColorLightPipe], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PicklistViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-picklist-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px d-block\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n  </label>\n  <p class=\"d-inline-block font-size-14px lh-1 minw-100px mw-fit-content picklist-view text-center {{fieldClass}}\"\n    [ngClass]=\"value?.color ? 'content-font' : ''\" [ngStyle]=\"{\n    'background': value?.color ? value.color : '',\n    'color': (value?.color) && (value?.color | isHexColorLight) ? 'rgba(0, 0, 0, 0.8)' : value?.color ? 'rgba(255, 255, 255, 0.8)' : (!value?.color && currentTheme === 'light') ? 'rgba(0, 0, 0, 0.8)' : 'rgba(255, 255, 255, 0.8)'\n  }\">{{ value ? value.itemValue : '--' }}</p>\n</div>\n" }]
    }], () => [{ type: i1.ThemeService }, { type: i0.ChangeDetectorRef }, { type: i2.PicklistService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PicklistViewComponent, { className: "PicklistViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/picklist/picklist-view.component.ts", lineNumber: 19 }); })();
//# sourceMappingURL=data:application/json;base64,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