/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
/**
 * Copyright (c) 2017-present, Ephox, Inc.
 *
 * This source code is licensed under the Apache 2 license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import { fromEvent, shareReplay, switchMap, BehaviorSubject, first, filter, map } from 'rxjs';
const firstEmission = () => (source) => source.pipe(first(), map(() => undefined));
const CreateScriptLoader = () => {
    const params$ = new BehaviorSubject(null);
    const loaded$ = params$.pipe(filter(Boolean), switchMap(([doc, url]) => {
        const scriptTag = doc.createElement('script');
        scriptTag.referrerPolicy = 'origin';
        scriptTag.type = 'application/javascript';
        scriptTag.src = url;
        doc.head.appendChild(scriptTag);
        return fromEvent(scriptTag, 'load').pipe(firstEmission());
    }), 
    // Caretaker note: `loaded$` is a multicast observable since it's piped with `shareReplay`,
    // so if there're multiple editor components simultaneously on the page, they'll subscribe to the internal
    // `ReplaySubject`. The script will be loaded only once, and `ReplaySubject` will cache the result.
    shareReplay({ bufferSize: 1, refCount: true }));
    return {
        load: (...args) => {
            if (!params$.getValue()) {
                params$.next(args);
            }
            return loaded$;
        },
        reinitialize: () => {
            params$.next(null);
        },
    };
};
const ScriptLoader = CreateScriptLoader();
export { ScriptLoader };
//# sourceMappingURL=data:application/json;base64,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