/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, ViewChild } from '@angular/core';
import { exampleSetup } from "prosemirror-example-setup";
import { defaultMarkdownParser, schema, defaultMarkdownSerializer } from "prosemirror-markdown";
import { EditorState } from 'prosemirror-state';
import { EditorView } from 'prosemirror-view';
import { AbstractFieldComponent } from '../abstract-field.component';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
import * as i3 from "@ng-bootstrap/ng-bootstrap";
import * as i4 from "../../../form-messages/form-messages.component";
const _c0 = ["editor"];
const _c1 = (a0, a1) => ({ "form-floating": a0, "form-group": a1 });
const _c2 = a0 => ({ "is-invalid": a0 });
const _c3 = a0 => ({ "pe-0": a0 });
function RichtextMarkdownFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 11);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function RichtextMarkdownFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 12);
    i0.ɵɵelement(1, "i", 13);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function RichtextMarkdownFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 8);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, RichtextMarkdownFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 9)(3, RichtextMarkdownFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 10);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "md-label-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function RichtextMarkdownFieldComponent_div_0_xf_form_messages_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 14);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input);
} }
function RichtextMarkdownFieldComponent_div_0_div_7_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 17);
    i0.ɵɵlistener("click", function RichtextMarkdownFieldComponent_div_0_div_7_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r0.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function RichtextMarkdownFieldComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 15);
    i0.ɵɵtemplate(1, RichtextMarkdownFieldComponent_div_0_div_7_button_1_Template, 2, 3, "button", 16);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
function RichtextMarkdownFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, RichtextMarkdownFieldComponent_div_0_label_1_Template, 4, 4, "label", 3);
    i0.ɵɵelementStart(2, "div", 4)(3, "div", 5);
    i0.ɵɵelement(4, "div", null, 0);
    i0.ɵɵtemplate(6, RichtextMarkdownFieldComponent_div_0_xf_form_messages_6_Template, 1, 1, "xf-form-messages", 6);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, RichtextMarkdownFieldComponent_div_0_div_7_Template, 2, 1, "div", 7);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(7, _c1, ctx_r0.fieldOptions.showLabel, !ctx_r0.fieldOptions.showLabel))("ngClass", i0.ɵɵpureFunction1(10, _c2, ctx_r0.fieldGroup.controls.input.invalid))("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(12, _c3, ctx_r0.field.allowJinjaToggle));
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showError);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
export class RichtextMarkdownFieldComponent extends AbstractFieldComponent {
    ngAfterViewInit() {
        // Initialize ProseMirror view with Markdown schema and plugins
        const state = EditorState.create({
            doc: defaultMarkdownParser.parse(this.value || '') ?? undefined,
            plugins: exampleSetup({ schema }),
        });
        this.view = new EditorView(this.editorElement.nativeElement, {
            state: state,
            dispatchTransaction: (transaction) => {
                const newState = this.view?.state.apply(transaction);
                this.view?.updateState(newState);
                if (transaction.docChanged) {
                    this.handleInputChange();
                }
            }
        });
    }
    handleInputChange() {
        const newContent = defaultMarkdownSerializer.serialize(this.view.state.doc);
        this.fieldGroup?.controls.input.setValue(newContent);
        this.value = newContent;
    }
    ngOnDestroy() {
        // Destroy ProseMirror view on component destruction
        this.view?.destroy();
    }
    // Implement ControlValueAccessor interface methods
    writeValue(value) {
        this.view?.dispatch(this.view.state.tr.replaceWith(0, this.view.state.doc.content.size, schema.node(value)));
        this.value = value;
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵRichtextMarkdownFieldComponent_BaseFactory; return function RichtextMarkdownFieldComponent_Factory(__ngFactoryType__) { return (ɵRichtextMarkdownFieldComponent_BaseFactory || (ɵRichtextMarkdownFieldComponent_BaseFactory = i0.ɵɵgetInheritedFactory(RichtextMarkdownFieldComponent)))(__ngFactoryType__ || RichtextMarkdownFieldComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RichtextMarkdownFieldComponent, selectors: [["xf-richtext-markdown-field"]], viewQuery: function RichtextMarkdownFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.editorElement = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["editor", ""], [3, "ngClass", "formGroup", 4, "ngIf"], [3, "ngClass", "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "d-flex"], [1, "flex-grow-1", 3, "ngClass"], [3, "control", 4, "ngIf"], ["class", "w-auto ps-2", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [3, "control"], [1, "w-auto", "ps-2"], ["type", "button", "class", "btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], ["type", "button", "title", "Add Custom Expression", 1, "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"]], template: function RichtextMarkdownFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, RichtextMarkdownFieldComponent_div_0_Template, 8, 14, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgIf, i2.NgControlStatusGroup, i2.FormGroupDirective, i3.NgbTooltip, i4.FormMessagesComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RichtextMarkdownFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-richtext-markdown-field', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div [ngClass]=\"{'form-floating': fieldOptions.showLabel, 'form-group': !fieldOptions.showLabel }\"\n  [ngClass]=\"{'is-invalid': fieldGroup.controls.input.invalid}\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'md-label-'+ field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"d-flex\">\n    <div class=\"flex-grow-1\" [ngClass]=\"{'pe-0': field.allowJinjaToggle}\">\n      <div #editor></div>\n      <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.input\"></xf-form-messages>\n    </div>\n    <div class=\"w-auto ps-2\" *ngIf=\"field.allowJinjaToggle\">\n      <button type=\"button\" class=\"btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n  </div>\n</div>\n\n" }]
    }], null, { editorElement: [{
            type: ViewChild,
            args: ['editor']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(RichtextMarkdownFieldComponent, { className: "RichtextMarkdownFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/richtext-markdown/richtext-markdown-field.component.ts", lineNumber: 18 }); })();
//# sourceMappingURL=data:application/json;base64,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