/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, ViewChild } from '@angular/core';
import { AbstractViewComponent } from '../abstract-view.component';
import { defaultMarkdownParser, schema } from 'prosemirror-markdown';
import { DOMSerializer } from 'prosemirror-model';
import * as i0 from "@angular/core";
const _c0 = ["mdWrapper"];
export class RichtextMarkdownViewComponent extends AbstractViewComponent {
    ngOnInit() {
        super.ngOnInit();
        if (this.value) {
            this.parseValueToHTML();
        }
        else {
            this.mdWrapper.nativeElement.innerHTML = '--';
        }
    }
    parseValueToHTML() {
        const doc = defaultMarkdownParser.parse(this.value);
        const serializer = DOMSerializer.fromSchema(schema);
        this.mdWrapper.nativeElement.innerHTML = '';
        serializer.serializeFragment(doc?.content, {}, this.mdWrapper.nativeElement);
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵRichtextMarkdownViewComponent_BaseFactory; return function RichtextMarkdownViewComponent_Factory(__ngFactoryType__) { return (ɵRichtextMarkdownViewComponent_BaseFactory || (ɵRichtextMarkdownViewComponent_BaseFactory = i0.ɵɵgetInheritedFactory(RichtextMarkdownViewComponent)))(__ngFactoryType__ || RichtextMarkdownViewComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RichtextMarkdownViewComponent, selectors: [["xf-richtext-markdown-view"]], viewQuery: function RichtextMarkdownViewComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.mdWrapper = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 0, consts: [["mdWrapper", ""], [1, "mb-0"]], template: function RichtextMarkdownViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelement(0, "p", 1, 0);
        } }, changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RichtextMarkdownViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-richtext-markdown-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<p class=\"mb-0\" #mdWrapper></p>\n" }]
    }], null, { mdWrapper: [{
            type: ViewChild,
            args: ['mdWrapper', { static: true }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(RichtextMarkdownViewComponent, { className: "RichtextMarkdownViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/richtext-markdown/richtext-markdown-view.component.ts", lineNumber: 17 }); })();
//# sourceMappingURL=data:application/json;base64,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