/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ALL_RECORDS_SIZE, MIN_NUMBER_LIMIT } from "../../core/constants";
import { Field } from "../../core/models/field";
import { InputFieldComponent } from "../field-renderers/built-ins/input/input-field.component";
import { InputViewComponent } from "../field-renderers/built-ins/input/input-view.component";
export class IntegerField extends Field {
    static { this.operators = [...Field.equalOperators, ...Field.greaterThanLessThanOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.INTEGER);
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^[0-9]+$/;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
    getFieldLength() {
        return {
            minlength: MIN_NUMBER_LIMIT,
            maxlength: ALL_RECORDS_SIZE
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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