/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { isObject } from "lodash-es";
import { Field } from "../../core/models/field";
import { PicklistField } from "./picklist";
export class MultiselectPicklistField extends PicklistField {
    constructor(name) {
        super(name, Field.BuiltInType.MULTISELECT_PICKLIST);
    }
    getFlatValue(value) {
        let newValues = [];
        value.forEach((val) => {
            if (isObject(val)) {
                newValues.push(val['@id']);
            }
            else {
                newValues.push(val);
            }
        });
        return newValues;
    }
}
//# sourceMappingURL=data:application/json;base64,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