/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Field } from "../../core/models/field";
import { MAX_TEXT_LENGTH } from "../../core/constants";
import { RichtextMarkdownFieldComponent } from "../field-renderers/built-ins/richtext-markdown/richtext-markdown-field.component";
import { RichtextMarkdownViewComponent } from "../field-renderers/built-ins/richtext-markdown/richtext-markdown-view.component";
export class RichtextMarkdownField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.RICHTEXTMARKDOWN);
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = RichtextMarkdownFieldComponent;
        this.viewComponent = RichtextMarkdownViewComponent;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: MAX_TEXT_LENGTH
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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