/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Operator } from "../../query-filters/models/operator";
import { Field } from "../../core/models/field";
import { SelectFieldComponent } from "../field-renderers/built-ins/select-field/select-field.component";
import { SelectViewComponent } from "../field-renderers/built-ins/select-field/select-view.component";
export class SelectField extends Field {
    static { this.selectEqualsOperators = [
        new Operator('eq', 'Equals', SelectFieldComponent, this.evaluateEqual),
        new Operator('neq', 'Not Equals', SelectFieldComponent, this.evaluateNotEqual),
    ]; }
    static { this.operators = [...SelectField.selectEqualsOperators, ...Field.listOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.SELECT);
        this.options = [];
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = SelectFieldComponent;
        this.viewComponent = SelectViewComponent;
    }
}
//# sourceMappingURL=data:application/json;base64,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