/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Field } from "../../core/models/field";
import { Operator } from "../../query-filters/models/operator";
import { InputFieldComponent } from "../field-renderers/built-ins/input/input-field.component";
import { InputViewComponent } from "../field-renderers/built-ins/input/input-view.component";
export class TextField extends Field {
    static { this.operators = [...Field.equalOperators,
        ...[
            new Operator('like', 'Contains', InputFieldComponent, TextField.evaluateLike),
            new Operator('notlike', 'Does Not Contain', InputFieldComponent, TextField.evaluateNotLike),
            new Operator('like_pattern', 'Matches Pattern', InputFieldComponent, TextField.evaluateLikePattern, 'like'),
            new Operator('notlike_pattern', 'Does Not Match Pattern', InputFieldComponent, TextField.evaluateNotLikePattern, 'notlike'),
        ],
        ...Field.listOperators,
        ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.TEXT);
        this.alwaysJinja = true;
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
    getFlatValue(value, operator) {
        return operator?.id === 'like' || operator?.id === 'notlike' ? `%${value}%` : value;
    }
    getViewValue(value) {
        return value;
    }
    static evaluateLike(field, value) {
        return true;
    }
    static evaluateNotLike(field, value) {
        return false;
    }
    static evaluateLikePattern(field, value) {
        return false;
    }
    static evaluateNotLikePattern(field, value) {
        return false;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: 255
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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