/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, forwardRef, Input, ViewChild } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR, Validators } from '@angular/forms';
import { of } from 'rxjs';
import { map } from 'rxjs/operators';
import { Filter } from '../models/filter';
import { Operator } from '../models/operator';
import { FieldOptions } from '../../form-fields/models/field-options';
import { SearchableDropdownComponent } from '../../components/searchable-dropdown/searchable-dropdown.component';
import { ViewContainerDirective } from '../../utility/directives/view-container.directive';
import { cloneDeep, isString } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "../../core/services/entity.service";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/common";
import * as i4 from "../../utility/directives/view-container.directive";
import * as i5 from "../../components/searchable-dropdown/searchable-dropdown.component";
const _c0 = ["formField"];
const _c1 = ["filterField"];
function FilterComponent_Conditional_6_option_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 12);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const operator_r2 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", operator_r2.id);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(operator_r2.title);
} }
function FilterComponent_Conditional_6_Conditional_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 12);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngValue", ctx_r2.isChangeOpeartor.id);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r2.isChangeOpeartor.title);
} }
function FilterComponent_Conditional_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "select", 6);
    i0.ɵɵtemplate(1, FilterComponent_Conditional_6_option_1_Template, 2, 2, "option", 11)(2, FilterComponent_Conditional_6_Conditional_2_Template, 2, 2, "option", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.field.operators);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r2.includeChangedOperator ? 2 : -1);
} }
function FilterComponent_Conditional_8_ng_template_0_Template(rf, ctx) { }
function FilterComponent_Conditional_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, FilterComponent_Conditional_8_ng_template_0_Template, 0, 0, "ng-template", 7);
} }
function FilterComponent_Conditional_10_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 13);
    i0.ɵɵlistener("click", function FilterComponent_Conditional_10_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.deleteFilter()); });
    i0.ɵɵelement(1, "i", 14);
    i0.ɵɵelementEnd();
} }
function FilterComponent_Conditional_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 10);
    i0.ɵɵelement(1, "xf-filter", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r2.subEntity)("isChild", true);
} }
export class FilterComponent {
    constructor(changeDetectorRef, entityService, formBuilder) {
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.formBuilder = formBuilder;
        this.isChild = false;
        this.includeChangedOperator = false;
        this.items = [];
        this.field = null;
        this.fieldRenderer = null;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.isChangeOpeartor = new Operator('changed', 'Is Changed', '', () => { return false; });
        this.value = new Filter();
        this.fieldOptions = new FieldOptions({
            showLabel: false
        });
        this.formGroup = this.formBuilder.group({
            filterField: [null, Validators.required],
            operator: [null, Validators.required],
            value: [null],
            subDataFilter: [null]
        });
    }
    writeValue(value) {
        this.value = value || new Filter();
        let field = this.value.field;
        let subFilter = null;
        if (this.value.field && this.value.field?.indexOf('.') > -1) {
            const parts = this.value.field.split('.');
            field = parts[0];
            parts.shift();
            subFilter = cloneDeep(value);
            subFilter.field = parts.join('.');
            this.formGroup.controls.operator.clearValidators();
        }
        else {
            this.formGroup.controls.operator.setValidators(Validators.required);
        }
        this.fieldValue = field && this.entity.fields[field] ? this.entity.fields[field].asSearchableItem() : null;
        if (this.fieldValue) {
            this.setField(this.fieldValue.value);
        }
        this.formGroup.setValue({
            filterField: this.fieldValue,
            operator: this.value.operator,
            value: this.value.originalValue || this.value.value,
            subDataFilter: subFilter
        }, {
            emitEvent: false
        });
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    ngOnInit() {
        this.formGroup.controls.operator.valueChanges.subscribe((value) => this.operatorChanged(value));
        this.formGroup.controls.value.valueChanges.subscribe((value) => this.valueChanged(value));
        this.formGroup.controls.filterField.valueChanges.subscribe((value) => {
            this.fieldValue = value;
            this.fieldChanged();
        });
        this.formGroup.controls.subDataFilter.valueChanges.subscribe((value) => {
            if (!value) {
                this.onChange(null);
                return;
            }
            let fullValue = cloneDeep(value);
            fullValue.field = this.field?.name + '.' + value.field;
            this.value = fullValue;
            this.onChange(fullValue);
        });
        this.filterFields('');
    }
    filterFields(search) {
        of(this.entity.attributes).pipe(map((fields) => {
            return fields.map((field) => field.asSearchableItem());
        }), map((items) => {
            return items.filter((item) => {
                return isString(item.display) && item.display.toLowerCase().indexOf(search.toLowerCase()) > -1;
            });
        })).subscribe((items) => {
            this.items = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    setField(field) {
        if (field && this.entity.fields[field.name].formType !== field.formType) {
            // Reset view
            this.field = null;
            this.fieldRenderer = null;
            this.changeDetectorRef.detectChanges();
        }
        this.field = field;
        if (field.data) {
            this.subEntity = this.entityService.createEntityFromData(field.data, 'sub-field-' + field.name);
            this.changeDetectorRef.detectChanges();
            return;
        }
        else {
            this.subEntity = undefined;
            this.changeDetectorRef.detectChanges();
        }
        if (this.value.operator) {
            const operator = this.field?.getOperator(this.value.operator);
            this.setRenderer(operator);
        }
        else {
            const defaultOperator = field.operators[0];
            this.setRenderer(defaultOperator);
            this.formGroup.controls.operator.setValue(defaultOperator.id);
        }
        this.changeDetectorRef.detectChanges();
    }
    fieldChanged() {
        if (!this.fieldValue) {
            return;
        }
        this.value.operator = null;
        this.value.field = this.fieldValue.value.name;
        this.setField(this.fieldValue.value);
        this.onChange(this.value);
    }
    operatorChanged(newOperatorId) {
        let operator = this.field?.getOperator(newOperatorId);
        if (newOperatorId === 'changed') {
            operator = this.isChangeOpeartor;
        }
        this.value.operator = operator?.id || null;
        this.setRenderer(operator);
        this.onChange(this.value);
    }
    setRenderer(operator) {
        if (operator?.renderer) {
            this.fieldRenderer = operator.renderer;
        }
        else {
            this.fieldRenderer = null;
        }
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        if (!this.field || !this.fieldRenderer) {
            return;
        }
        let field = cloneDeep(this.field);
        field.name = field.name + '-renderer';
        this.componentRef = viewContainerRef.createComponent(this.fieldRenderer);
        this.componentRef.instance.field = field;
        this.componentRef.instance.fieldClass = 'form-control-sm';
        this.componentRef.instance.fieldOptions = this.fieldOptions;
        this.componentRef.instance.writeValue(this.value.value);
        this.componentRef.instance.onChange = (value) => this.valueChanged(value);
        if (!this.value.value && this.field.defaultValue) {
            this.componentRef.instance.value = this.field.defaultValue;
        }
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    valueChanged(value) {
        this.value.originalValue = value;
        this.value.value = this.field?.getFlatValue(value, this.field?.operators.find((operator) => this.value.operator === operator.id));
        this.onChange(this.value);
    }
    deleteFilter() {
        this.onChange(null);
    }
    validate(control) {
        return !this.value?.operator || !this.value?.field ? {
            required: true
        } : null;
    }
    focusOnFirstInvalidInput() {
        this.formGroup.markAllAsTouched();
        if (this.filterField.invalid) {
            this.filterField.setTouched();
            this.filterField.focus();
            return true;
        }
        return false;
    }
    static { this.ɵfac = function FilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FilterComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.EntityService), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FilterComponent, selectors: [["xf-filter"]], viewQuery: function FilterComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(_c1, 5);
            i0.ɵɵviewQuery(SearchableDropdownComponent, 5);
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formField = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.filterField = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.fieldSelect = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
        } }, inputs: { entity: "entity", isChild: "isChild", includeChangedOperator: "includeChangedOperator" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => FilterComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => FilterComponent),
                    multi: true
                }])], decls: 12, vars: 6, consts: [["filterField", ""], [3, "formGroup"], [1, "d-flex", "align-items-center"], [1, "col", "pe-1"], ["buttonStyle", "select", "formControlName", "filterField", "placeholder", "Select Field", 3, "searchQueryChange", "items"], [1, "col", "px-1"], ["formControlName", "operator", 1, "form-select", "form-select-sm"], ["xfViewContainer", ""], [1, "col", "col-delete", "ps-1"], ["type", "button", 1, "btn", "btn-sm", "btn-outline"], [1, "mt-2"], [3, "ngValue", 4, "ngFor", "ngForOf"], [3, "ngValue"], ["type", "button", 1, "btn", "btn-sm", "btn-outline", 3, "click"], [1, "fa", "fa-close", "text-danger"], ["formControlName", "subDataFilter", 3, "entity", "isChild"]], template: function FilterComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 1)(1, "div", 2)(2, "div", 3)(3, "xf-searchable-dropdown", 4, 0);
            i0.ɵɵlistener("searchQueryChange", function FilterComponent_Template_xf_searchable_dropdown_searchQueryChange_3_listener($event) { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.filterFields($event)); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "div", 5);
            i0.ɵɵtemplate(6, FilterComponent_Conditional_6_Template, 3, 2, "select", 6);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(7, "div", 5);
            i0.ɵɵtemplate(8, FilterComponent_Conditional_8_Template, 1, 0, null, 7);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(9, "div", 8);
            i0.ɵɵtemplate(10, FilterComponent_Conditional_10_Template, 2, 0, "button", 9);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(11, FilterComponent_Conditional_11_Template, 2, 2, "div", 10);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("items", ctx.items);
            i0.ɵɵadvance(3);
            i0.ɵɵconditional(ctx.field && !ctx.subEntity ? 6 : -1);
            i0.ɵɵadvance(2);
            i0.ɵɵconditional(!ctx.subEntity ? 8 : -1);
            i0.ɵɵadvance(2);
            i0.ɵɵconditional(!ctx.isChild ? 10 : -1);
            i0.ɵɵadvance();
            i0.ɵɵconditional(ctx.field && ctx.subEntity ? 11 : -1);
        } }, dependencies: [i3.NgForOf, i4.ViewContainerDirective, i5.SearchableDropdownComponent, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, FilterComponent], styles: [".col-delete[_ngcontent-%COMP%]{flex:0 0 0}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-filter', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => FilterComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => FilterComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div [formGroup]=\"formGroup\">\n  <div class=\"d-flex align-items-center\">\n    <div class=\"col pe-1\">\n      <xf-searchable-dropdown #filterField buttonStyle=\"select\" formControlName=\"filterField\" [items]=\"items\"\n      placeholder=\"Select Field\" (searchQueryChange)=\"filterFields($event)\"></xf-searchable-dropdown>\n    </div>\n    <div class=\"col px-1\">\n      @if (field && !subEntity) {\n        <select class=\"form-select form-select-sm\" formControlName=\"operator\">\n          <option *ngFor=\"let operator of field.operators\" [ngValue]=\"operator.id\">{{ operator.title }}</option>\n          @if (includeChangedOperator) {\n            <option [ngValue]=\"isChangeOpeartor.id\">{{ isChangeOpeartor.title }}</option>\n          }\n        </select>\n      }\n    </div>\n    <div class=\"col px-1\">\n      @if (!subEntity) {\n        <!-- <xf-form-field *ngIf=\"fieldRenderer\" formControlName=\"value\" [field]=\"fieldRenderer\" [fieldOptions]=\"fieldOptions\" [fieldClass]=\"'form-control-sm'\" #formField></xf-form-field> -->\n        <ng-template xfViewContainer></ng-template>\n      }\n    </div>\n    <div class=\"col col-delete ps-1\">\n      @if (!isChild) {\n        <button type=\"button\" class=\"btn btn-sm btn-outline\" (click)=\"deleteFilter()\">\n          <i class=\"fa fa-close text-danger\"></i>\n        </button>\n      }\n    </div>\n  </div>\n  @if (field && subEntity) {\n    <div class=\"mt-2\">\n      <xf-filter [entity]=\"subEntity\" formControlName=\"subDataFilter\" [isChild]=\"true\"></xf-filter>\n    </div>\n  }\n\n</div>\n", styles: [".col-delete{flex:0 0 0}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.EntityService }, { type: i2.FormBuilder }], { entity: [{
            type: Input
        }], isChild: [{
            type: Input
        }], includeChangedOperator: [{
            type: Input
        }], formField: [{
            type: ViewChild,
            args: ['formField', { static: false }]
        }], filterField: [{
            type: ViewChild,
            args: ['filterField', { static: false }]
        }], fieldSelect: [{
            type: ViewChild,
            args: [SearchableDropdownComponent]
        }], xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: false }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FilterComponent, { className: "FilterComponent", filePath: "lib/query-filters/filter/filter.component.ts", lineNumber: 38 }); })();
//# sourceMappingURL=data:application/json;base64,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