/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Filter } from "./filter";
export class DatetimeFilter extends Filter {
    constructor(field = null, value = null, secondValue = null) {
        super(field, null, value);
        this.secondValue = secondValue;
        this.secondValue = secondValue;
    }
    getFlatFilter() {
        let filters = [{
                field: this.field,
                operator: 'gte',
                value: this.value.toUTCString()
            }];
        if (this.secondValue) {
            filters.push({
                field: this.field,
                operator: 'lte',
                value: this.secondValue.toUTCString()
            });
        }
        return {
            logic: 'AND',
            filters: filters
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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