import { __decorate } from "tslib";
/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { plainToInstance, Transform, Type } from "class-transformer";
import { cloneDeep, forEach } from "lodash-es";
import { Filter } from "./filter";
import { FilterGroup } from "./filter-group";
import { DEFAULT_GRID_ROWS } from "../../core/constants";
export class Query {
    constructor(query) {
        this.limit = DEFAULT_GRID_ROWS;
        this.search = '';
        this.logic = 'AND';
        this.page = 1;
        this.relationships = false;
        this.selectedFields = [];
        this.filters = [];
        this.sort = [];
        this.aggregates = [];
        this.showDeleted = false;
        this.ignoreFields = [];
        this.queryParams = {};
        Object.assign(this, query);
    }
    getURLParameters() {
        let queryParams = {};
        if (this.limit) {
            queryParams.$limit = this.limit;
        }
        if (this.page > 0) {
            queryParams.$page = this.page;
        }
        if (this.relationships === true) {
            queryParams.$relationships = this.relationships;
        }
        if (this.search?.length > 0) {
            queryParams.$search = this.search;
        }
        if (this.showDeleted === true) {
            queryParams.$showDeleted = this.showDeleted;
        }
        if (this.queryParams) {
            forEach(this.queryParams, (value, key) => {
                queryParams[key] = value;
            });
        }
        if (this.sort.length > 0) {
            // if (entity) {
            //   var sorts = angular.copy(this.sort);
            //   this.sort = [];
            //   for (var i = 0, iLen = sorts.length; i < iLen; i++) {
            //     var fieldName = sorts[i].field;
            //     var fieldObj = entity.fields ? entity.fields[fieldName] : undefined;
            //     if (fieldObj) {
            //       var fieldSort = fieldObj.buildSort(sorts[i].direction || sorts[i].sort.direction);
            //       for (var fieldSortIndex = 0; fieldSortIndex < fieldSort.length; fieldSortIndex++) {
            //         this.sort.push(fieldSort[fieldSortIndex]);
            //       }
            //     }
            //   }
            // }
            let orderBy = '';
            this.sort.forEach((sortItem, index) => {
                if (index > 0) {
                    orderBy += ',';
                }
                let direction = sortItem.direction.toLowerCase() === 'desc' ? '-' : '+';
                orderBy += direction + sortItem.field;
            });
            queryParams.$orderby = orderBy;
        }
        return queryParams;
    }
    mergeQueries(queries) {
        forEach(queries, (query) => {
            this.filters.push(...query.filters);
            this.sort.push(...query.sort);
        });
    }
    getQueryObject(useValue = false) {
        let query = {
            sort: [],
            logic: this.logic,
            page: this.page
        };
        if (this.search.length > 0) {
            query.search = this.search;
        }
        if (this.showDeleted === true) {
            query.showDeleted = this.showDeleted;
        }
        query.filters = cloneDeep(this.filters);
        if (this.relationships) {
            query.$relationships = this.relationships;
        }
        if (query.filters.length > 0) {
            query.logic = this.logic;
            query.filters = this.transformFilters(query.filters, useValue);
        }
        if (this.aggregates && this.aggregates.length > 0) {
            query.aggregates = this.aggregates;
        }
        if (this.selectedFields.length > 0) {
            query.fields = this.selectedFields;
        }
        if (this.ignoreFields?.length > 0) {
            query.__ignoreFields = this.ignoreFields;
        }
        if (this.sort.length > 0) {
            query.sort = this.sort;
        }
        // else if (defaultQuery && defaultQuery.sort) {
        //   query.sort = defaultQuery.sort;
        // }
        return query;
    }
    ;
    transformFilters(filters, useValue) {
        let transFormedFilters = [];
        filters.forEach((filter) => {
            // this is a related record filter
            // if (filter.subFields) {
            //   delete filter.subFields;
            //   filter.field = filter.module + '.' + filter.field;
            //   delete filter.module;
            // }
            //if(filter.value && isString(filter.value) && filter.value.indexOf('{{') !== -1){
            //see for any query object in URL if yes then apply where ever the {{expressions}} are used.
            // if(!angular.isUndefined($state.params.qparam) && useValue){
            //   var interpolateObject = JSON.parse($state.params.qparam);
            //   interpolateObject.currentUserIri = currentUserIriService;
            //   filter.value = $interpolate(filter.value)(interpolateObject);
            //   if(filter.updateDateIntervalValue){//its a datetime filter
            //     filter.value = filter.value.indexOf('differenceType')>=0?JSON.parse(filter.value):filter.value;//this is case of dateRange where object is passed
            //     filter.updateDateIntervalValue(filter);
            //   }
            // }
            //}
            if (filter.filters?.length > 0) {
                filter = filter;
                let returnedFilter = this.transformFilters(filter.filters, useValue);
                let filterObj = {
                    logic: filter.logic,
                    filters: returnedFilter
                };
                transFormedFilters.push(filterObj);
            }
            else if (filter instanceof Filter) {
                transFormedFilters.push(filter.getFlatFilter());
            }
        });
        return transFormedFilters;
    }
    getURLQuery(entity) {
        let flatQuery = {};
        if (this.search) {
            flatQuery.$search = this.search;
        }
        Object.assign(flatQuery, this.getURLParameters());
        this.filters.forEach((filter) => {
            if (filter instanceof Filter) {
                console.log(filter.getURLQuery(entity));
                Object.assign(flatQuery, filter.getURLQuery(entity));
            }
        });
        return flatQuery;
    }
    asFilterGroup() {
        return new FilterGroup(this.filters, this.logic);
    }
}
__decorate([
    Type(() => Filter, {
        discriminator: {
            property: 'logic',
            subTypes: [
                { value: FilterGroup, name: 'AND' },
                { value: FilterGroup, name: 'OR' },
            ]
        },
        keepDiscriminatorProperty: true
    }),
    Transform(({ value }) => {
        return value.map((item) => {
            if (item.filters) {
                return plainToInstance(FilterGroup, item); // Manually convert FilterGroup if it contains filters
            }
            return plainToInstance(Filter, item); // Otherwise, convert to Filter
        });
    })
], Query.prototype, "filters", void 0);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicXVlcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9xdWVyeS1maWx0ZXJzL21vZGVscy9xdWVyeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7a0JBSWtCO0FBQ2xCLE9BQU8sRUFBRSxlQUFlLEVBQUUsU0FBUyxFQUFFLElBQUksRUFBRSxNQUFNLG1CQUFtQixDQUFDO0FBQ3JFLE9BQU8sRUFBRSxTQUFTLEVBQUUsT0FBTyxFQUFFLE1BQU0sV0FBVyxDQUFDO0FBRS9DLE9BQU8sRUFBRSxNQUFNLEVBQUUsTUFBTSxVQUFVLENBQUM7QUFDbEMsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBQzdDLE9BQU8sRUFBRSxpQkFBaUIsRUFBRSxNQUFNLHNCQUFzQixDQUFDO0FBRXpELE1BQU0sT0FBTyxLQUFLO0lBaUNoQixZQUFZLEtBQWM7UUFoQzFCLFVBQUssR0FBVyxpQkFBaUIsQ0FBQztRQUNsQyxXQUFNLEdBQVcsRUFBRSxDQUFDO1FBQ3BCLFVBQUssR0FBaUIsS0FBSyxDQUFDO1FBQzVCLFNBQUksR0FBVyxDQUFDLENBQUM7UUFDakIsa0JBQWEsR0FBWSxLQUFLLENBQUM7UUFDL0IsbUJBQWMsR0FBYSxFQUFFLENBQUM7UUFvQjlCLFlBQU8sR0FBNkIsRUFBRSxDQUFDO1FBRXZDLFNBQUksR0FBZ0IsRUFBRSxDQUFDO1FBQ3ZCLGVBQVUsR0FBVSxFQUFFLENBQUM7UUFDdkIsZ0JBQVcsR0FBWSxLQUFLLENBQUM7UUFDN0IsaUJBQVksR0FBYSxFQUFFLENBQUM7UUFDNUIsZ0JBQVcsR0FBUyxFQUFFLENBQUM7UUFFckIsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDN0IsQ0FBQztJQUVELGdCQUFnQjtRQUNkLElBQUksV0FBVyxHQUFRLEVBQUUsQ0FBQztRQUMxQixJQUFJLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQztZQUNmLFdBQVcsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQztRQUNsQyxDQUFDO1FBQ0QsSUFBSSxJQUFJLENBQUMsSUFBSSxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQ2xCLFdBQVcsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQztRQUNoQyxDQUFDO1FBQ0QsSUFBSSxJQUFJLENBQUMsYUFBYSxLQUFLLElBQUksRUFBRSxDQUFDO1lBQ2hDLFdBQVcsQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUNsRCxDQUFDO1FBQ0QsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUM1QixXQUFXLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUM7UUFDcEMsQ0FBQztRQUNELElBQUksSUFBSSxDQUFDLFdBQVcsS0FBSyxJQUFJLEVBQUUsQ0FBQztZQUM5QixXQUFXLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUM7UUFDOUMsQ0FBQztRQUNELElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO1lBQ3JCLE9BQU8sQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUMsS0FBVSxFQUFFLEdBQVEsRUFBRSxFQUFFO2dCQUNqRCxXQUFXLENBQUMsR0FBRyxDQUFDLEdBQUcsS0FBSyxDQUFBO1lBQzFCLENBQUMsQ0FBQyxDQUFDO1FBQ0wsQ0FBQztRQUVELElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDekIsZ0JBQWdCO1lBRWhCLHlDQUF5QztZQUN6QyxvQkFBb0I7WUFDcEIsMERBQTBEO1lBQzFELHNDQUFzQztZQUN0QywyRUFBMkU7WUFDM0Usc0JBQXNCO1lBQ3RCLDJGQUEyRjtZQUMzRiw0RkFBNEY7WUFDNUYscURBQXFEO1lBQ3JELFVBQVU7WUFDVixRQUFRO1lBQ1IsTUFBTTtZQUNOLElBQUk7WUFFSixJQUFJLE9BQU8sR0FBRyxFQUFFLENBQUM7WUFDakIsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQyxRQUFRLEVBQUUsS0FBSyxFQUFFLEVBQUU7Z0JBQ3BDLElBQUksS0FBSyxHQUFHLENBQUMsRUFBRSxDQUFDO29CQUNkLE9BQU8sSUFBSSxHQUFHLENBQUM7Z0JBQ2pCLENBQUM7Z0JBQ0QsSUFBSSxTQUFTLEdBQUcsUUFBUSxDQUFDLFNBQVMsQ0FBQyxXQUFXLEVBQUUsS0FBSyxNQUFNLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDO2dCQUN4RSxPQUFPLElBQUksU0FBUyxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7WUFDeEMsQ0FBQyxDQUFDLENBQUM7WUFFSCxXQUFXLENBQUMsUUFBUSxHQUFHLE9BQU8sQ0FBQztRQUNqQyxDQUFDO1FBQ0QsT0FBTyxXQUFXLENBQUM7SUFDckIsQ0FBQztJQUVELFlBQVksQ0FBQyxPQUFnQjtRQUMzQixPQUFPLENBQUMsT0FBTyxFQUFFLENBQUMsS0FBWSxFQUFFLEVBQUU7WUFDaEMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7WUFDcEMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDaEMsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsY0FBYyxDQUFDLFdBQW9CLEtBQUs7UUFDdEMsSUFBSSxLQUFLLEdBQVE7WUFDZixJQUFJLEVBQUUsRUFBRTtZQUNSLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztZQUNqQixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7U0FDaEIsQ0FBQztRQUVGLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDM0IsS0FBSyxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDO1FBQzdCLENBQUM7UUFDRCxJQUFJLElBQUksQ0FBQyxXQUFXLEtBQUssSUFBSSxFQUFFLENBQUM7WUFDOUIsS0FBSyxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLENBQUM7UUFDRCxLQUFLLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDeEMsSUFBSSxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUM7WUFDdkIsS0FBSyxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQzVDLENBQUM7UUFDRCxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQzdCLEtBQUssQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUN6QixLQUFLLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQ2pFLENBQUM7UUFFRCxJQUFJLElBQUksQ0FBQyxVQUFVLElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDbEQsS0FBSyxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDO1FBQ3JDLENBQUM7UUFFRCxJQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQ25DLEtBQUssQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztRQUNyQyxDQUFDO1FBRUQsSUFBSSxJQUFJLENBQUMsWUFBWSxFQUFFLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUNsQyxLQUFLLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUM7UUFDM0MsQ0FBQztRQUVELElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDekIsS0FBSyxDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDO1FBQ3pCLENBQUM7UUFDRCxnREFBZ0Q7UUFDaEQsb0NBQW9DO1FBQ3BDLElBQUk7UUFDSixPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFBQSxDQUFDO0lBRUYsZ0JBQWdCLENBQUMsT0FBaUMsRUFBRSxRQUFpQjtRQUNuRSxJQUFJLGtCQUFrQixHQUFRLEVBQUUsQ0FBQztRQUNqQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBNEIsRUFBRSxFQUFFO1lBQy9DLGtDQUFrQztZQUNsQywwQkFBMEI7WUFDMUIsNkJBQTZCO1lBQzdCLHVEQUF1RDtZQUN2RCwwQkFBMEI7WUFDMUIsSUFBSTtZQUVKLGtGQUFrRjtZQUNsRiw0RkFBNEY7WUFDNUYsOERBQThEO1lBQzlELDhEQUE4RDtZQUM5RCw4REFBOEQ7WUFDOUQsa0VBQWtFO1lBQ2xFLCtEQUErRDtZQUMvRCx3SkFBd0o7WUFDeEosOENBQThDO1lBQzlDLE1BQU07WUFDTixJQUFJO1lBQ0osR0FBRztZQUNILElBQUssTUFBc0IsQ0FBQyxPQUFPLEVBQUUsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO2dCQUNoRCxNQUFNLEdBQUcsTUFBcUIsQ0FBQztnQkFDL0IsSUFBSSxjQUFjLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxPQUFPLEVBQUUsUUFBUSxDQUFDLENBQUM7Z0JBQ3JFLElBQUksU0FBUyxHQUFHO29CQUNkLEtBQUssRUFBRSxNQUFNLENBQUMsS0FBSztvQkFDbkIsT0FBTyxFQUFFLGNBQWM7aUJBQ3hCLENBQUM7Z0JBQ0Ysa0JBQWtCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1lBQ3JDLENBQUM7aUJBQU0sSUFBSSxNQUFNLFlBQVksTUFBTSxFQUFFLENBQUM7Z0JBQ3BDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsYUFBYSxFQUFFLENBQUMsQ0FBQztZQUNsRCxDQUFDO1FBQ0gsQ0FBQyxDQUFDLENBQUM7UUFFSCxPQUFPLGtCQUFrQixDQUFDO0lBQzVCLENBQUM7SUFFRCxXQUFXLENBQUMsTUFBYztRQUN4QixJQUFJLFNBQVMsR0FBUSxFQUFFLENBQUM7UUFFeEIsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDaEIsU0FBUyxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDO1FBQ2xDLENBQUM7UUFFRCxNQUFNLENBQUMsTUFBTSxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQyxDQUFDO1FBRWxELElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBNEIsRUFBRSxFQUFFO1lBQ3BELElBQUksTUFBTSxZQUFZLE1BQU0sRUFBRSxDQUFDO2dCQUM3QixPQUFPLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztnQkFDeEMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO1lBQ3ZELENBQUM7UUFDSCxDQUFDLENBQUMsQ0FBQztRQUVILE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7SUFFRCxhQUFhO1FBQ1gsT0FBTyxJQUFJLFdBQVcsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNuRCxDQUFDO0NBRUY7QUFoTEM7SUFsQkMsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDLE1BQU0sRUFBRTtRQUNsQixhQUFhLEVBQUU7WUFDYixRQUFRLEVBQUUsT0FBTztZQUNqQixRQUFRLEVBQUU7Z0JBQ1IsRUFBRSxLQUFLLEVBQUUsV0FBVyxFQUFFLElBQUksRUFBRSxLQUFLLEVBQUU7Z0JBQ25DLEVBQUUsS0FBSyxFQUFFLFdBQVcsRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFO2FBQ25DO1NBQ0Y7UUFDRCx5QkFBeUIsRUFBRSxJQUFJO0tBQ2hDLENBQUM7SUFDRCxTQUFTLENBQUMsQ0FBQyxFQUFFLEtBQUssRUFBRSxFQUFFLEVBQUU7UUFDdkIsT0FBTyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsSUFBUyxFQUFFLEVBQUU7WUFDN0IsSUFBSSxJQUFJLENBQUMsT0FBTyxFQUFFLENBQUM7Z0JBQ2pCLE9BQU8sZUFBZSxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQyxDQUFDLHNEQUFzRDtZQUNuRyxDQUFDO1lBQ0QsT0FBTyxlQUFlLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxDQUFDLENBQUMsK0JBQStCO1FBQ3ZFLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQyxDQUFDO3NDQUNxQyIsInNvdXJjZXNDb250ZW50IjpbIi8qIENvcHlyaWdodCBzdGFydFxuICBDb3B5cmlnaHQgKEMpIDIwMDggLSAyMDI1IEZvcnRpbmV0IEluYy5cbiAgQWxsIHJpZ2h0cyByZXNlcnZlZC5cbiAgRk9SVElORVQgQ09ORklERU5USUFMICYgRk9SVElORVQgUFJPUFJJRVRBUlkgU09VUkNFIENPREVcbiAgQ29weXJpZ2h0IGVuZCAqL1xuaW1wb3J0IHsgcGxhaW5Ub0luc3RhbmNlLCBUcmFuc2Zvcm0sIFR5cGUgfSBmcm9tIFwiY2xhc3MtdHJhbnNmb3JtZXJcIjtcbmltcG9ydCB7IGNsb25lRGVlcCwgZm9yRWFjaCB9IGZyb20gXCJsb2Rhc2gtZXNcIjtcbmltcG9ydCB7IEVudGl0eSB9IGZyb20gXCIuLi8uLi9jb3JlL21vZGVscy9lbnRpdHlcIjtcbmltcG9ydCB7IEZpbHRlciB9IGZyb20gXCIuL2ZpbHRlclwiO1xuaW1wb3J0IHsgRmlsdGVyR3JvdXAgfSBmcm9tIFwiLi9maWx0ZXItZ3JvdXBcIjtcbmltcG9ydCB7IERFRkFVTFRfR1JJRF9ST1dTIH0gZnJvbSBcIi4uLy4uL2NvcmUvY29uc3RhbnRzXCI7XG5cbmV4cG9ydCBjbGFzcyBRdWVyeSB7XG4gIGxpbWl0OiBudW1iZXIgPSBERUZBVUxUX0dSSURfUk9XUztcbiAgc2VhcmNoOiBzdHJpbmcgPSAnJztcbiAgbG9naWM6ICdBTkQnIHwgJ09SJyA9ICdBTkQnO1xuICBwYWdlOiBudW1iZXIgPSAxO1xuICByZWxhdGlvbnNoaXBzOiBib29sZWFuID0gZmFsc2U7XG4gIHNlbGVjdGVkRmllbGRzOiBzdHJpbmdbXSA9IFtdO1xuICBtb2R1bGUhOiBzdHJpbmc7XG4gIEBUeXBlKCgpID0+IEZpbHRlciwge1xuICAgIGRpc2NyaW1pbmF0b3I6IHtcbiAgICAgIHByb3BlcnR5OiAnbG9naWMnLFxuICAgICAgc3ViVHlwZXM6IFtcbiAgICAgICAgeyB2YWx1ZTogRmlsdGVyR3JvdXAsIG5hbWU6ICdBTkQnIH0sXG4gICAgICAgIHsgdmFsdWU6IEZpbHRlckdyb3VwLCBuYW1lOiAnT1InIH0sXG4gICAgICBdXG4gICAgfSxcbiAgICBrZWVwRGlzY3JpbWluYXRvclByb3BlcnR5OiB0cnVlXG4gIH0pXG4gIEBUcmFuc2Zvcm0oKHsgdmFsdWUgfSkgPT4ge1xuICAgIHJldHVybiB2YWx1ZS5tYXAoKGl0ZW06IGFueSkgPT4ge1xuICAgICAgaWYgKGl0ZW0uZmlsdGVycykge1xuICAgICAgICByZXR1cm4gcGxhaW5Ub0luc3RhbmNlKEZpbHRlckdyb3VwLCBpdGVtKTsgLy8gTWFudWFsbHkgY29udmVydCBGaWx0ZXJHcm91cCBpZiBpdCBjb250YWlucyBmaWx0ZXJzXG4gICAgICB9XG4gICAgICByZXR1cm4gcGxhaW5Ub0luc3RhbmNlKEZpbHRlciwgaXRlbSk7IC8vIE90aGVyd2lzZSwgY29udmVydCB0byBGaWx0ZXJcbiAgICB9KTtcbiAgfSlcbiAgZmlsdGVyczogKEZpbHRlciB8IEZpbHRlckdyb3VwKVtdID0gW107XG5cbiAgc29ydDogUXVlcnlTb3J0W10gPSBbXTtcbiAgYWdncmVnYXRlczogYW55W10gPSBbXTtcbiAgc2hvd0RlbGV0ZWQ6IGJvb2xlYW4gPSBmYWxzZTtcbiAgaWdub3JlRmllbGRzOiBzdHJpbmdbXSA9IFtdO1xuICBxdWVyeVBhcmFtcz86IGFueSA9IHt9O1xuICBjb25zdHJ1Y3RvcihxdWVyeT86IG9iamVjdCkge1xuICAgIE9iamVjdC5hc3NpZ24odGhpcywgcXVlcnkpO1xuICB9XG5cbiAgZ2V0VVJMUGFyYW1ldGVycygpIHtcbiAgICBsZXQgcXVlcnlQYXJhbXM6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLmxpbWl0KSB7XG4gICAgICBxdWVyeVBhcmFtcy4kbGltaXQgPSB0aGlzLmxpbWl0O1xuICAgIH1cbiAgICBpZiAodGhpcy5wYWdlID4gMCkge1xuICAgICAgcXVlcnlQYXJhbXMuJHBhZ2UgPSB0aGlzLnBhZ2U7XG4gICAgfVxuICAgIGlmICh0aGlzLnJlbGF0aW9uc2hpcHMgPT09IHRydWUpIHtcbiAgICAgIHF1ZXJ5UGFyYW1zLiRyZWxhdGlvbnNoaXBzID0gdGhpcy5yZWxhdGlvbnNoaXBzO1xuICAgIH1cbiAgICBpZiAodGhpcy5zZWFyY2g/Lmxlbmd0aCA+IDApIHtcbiAgICAgIHF1ZXJ5UGFyYW1zLiRzZWFyY2ggPSB0aGlzLnNlYXJjaDtcbiAgICB9XG4gICAgaWYgKHRoaXMuc2hvd0RlbGV0ZWQgPT09IHRydWUpIHtcbiAgICAgIHF1ZXJ5UGFyYW1zLiRzaG93RGVsZXRlZCA9IHRoaXMuc2hvd0RlbGV0ZWQ7XG4gICAgfVxuICAgIGlmICh0aGlzLnF1ZXJ5UGFyYW1zKSB7XG4gICAgICBmb3JFYWNoKHRoaXMucXVlcnlQYXJhbXMsICh2YWx1ZTogYW55LCBrZXk6IGFueSkgPT4ge1xuICAgICAgICBxdWVyeVBhcmFtc1trZXldID0gdmFsdWVcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIGlmICh0aGlzLnNvcnQubGVuZ3RoID4gMCkge1xuICAgICAgLy8gaWYgKGVudGl0eSkge1xuXG4gICAgICAvLyAgIHZhciBzb3J0cyA9IGFuZ3VsYXIuY29weSh0aGlzLnNvcnQpO1xuICAgICAgLy8gICB0aGlzLnNvcnQgPSBbXTtcbiAgICAgIC8vICAgZm9yICh2YXIgaSA9IDAsIGlMZW4gPSBzb3J0cy5sZW5ndGg7IGkgPCBpTGVuOyBpKyspIHtcbiAgICAgIC8vICAgICB2YXIgZmllbGROYW1lID0gc29ydHNbaV0uZmllbGQ7XG4gICAgICAvLyAgICAgdmFyIGZpZWxkT2JqID0gZW50aXR5LmZpZWxkcyA/IGVudGl0eS5maWVsZHNbZmllbGROYW1lXSA6IHVuZGVmaW5lZDtcbiAgICAgIC8vICAgICBpZiAoZmllbGRPYmopIHtcbiAgICAgIC8vICAgICAgIHZhciBmaWVsZFNvcnQgPSBmaWVsZE9iai5idWlsZFNvcnQoc29ydHNbaV0uZGlyZWN0aW9uIHx8IHNvcnRzW2ldLnNvcnQuZGlyZWN0aW9uKTtcbiAgICAgIC8vICAgICAgIGZvciAodmFyIGZpZWxkU29ydEluZGV4ID0gMDsgZmllbGRTb3J0SW5kZXggPCBmaWVsZFNvcnQubGVuZ3RoOyBmaWVsZFNvcnRJbmRleCsrKSB7XG4gICAgICAvLyAgICAgICAgIHRoaXMuc29ydC5wdXNoKGZpZWxkU29ydFtmaWVsZFNvcnRJbmRleF0pO1xuICAgICAgLy8gICAgICAgfVxuICAgICAgLy8gICAgIH1cbiAgICAgIC8vICAgfVxuICAgICAgLy8gfVxuXG4gICAgICBsZXQgb3JkZXJCeSA9ICcnO1xuICAgICAgdGhpcy5zb3J0LmZvckVhY2goKHNvcnRJdGVtLCBpbmRleCkgPT4ge1xuICAgICAgICBpZiAoaW5kZXggPiAwKSB7XG4gICAgICAgICAgb3JkZXJCeSArPSAnLCc7XG4gICAgICAgIH1cbiAgICAgICAgbGV0IGRpcmVjdGlvbiA9IHNvcnRJdGVtLmRpcmVjdGlvbi50b0xvd2VyQ2FzZSgpID09PSAnZGVzYycgPyAnLScgOiAnKyc7XG4gICAgICAgIG9yZGVyQnkgKz0gZGlyZWN0aW9uICsgc29ydEl0ZW0uZmllbGQ7XG4gICAgICB9KTtcblxuICAgICAgcXVlcnlQYXJhbXMuJG9yZGVyYnkgPSBvcmRlckJ5O1xuICAgIH1cbiAgICByZXR1cm4gcXVlcnlQYXJhbXM7XG4gIH1cblxuICBtZXJnZVF1ZXJpZXMocXVlcmllczogUXVlcnlbXSkge1xuICAgIGZvckVhY2gocXVlcmllcywgKHF1ZXJ5OiBRdWVyeSkgPT4ge1xuICAgICAgdGhpcy5maWx0ZXJzLnB1c2goLi4ucXVlcnkuZmlsdGVycyk7XG4gICAgICB0aGlzLnNvcnQucHVzaCguLi5xdWVyeS5zb3J0KTtcbiAgICB9KTtcbiAgfVxuXG4gIGdldFF1ZXJ5T2JqZWN0KHVzZVZhbHVlOiBib29sZWFuID0gZmFsc2UpIHtcbiAgICBsZXQgcXVlcnk6IGFueSA9IHtcbiAgICAgIHNvcnQ6IFtdLFxuICAgICAgbG9naWM6IHRoaXMubG9naWMsXG4gICAgICBwYWdlOiB0aGlzLnBhZ2VcbiAgICB9O1xuXG4gICAgaWYgKHRoaXMuc2VhcmNoLmxlbmd0aCA+IDApIHtcbiAgICAgIHF1ZXJ5LnNlYXJjaCA9IHRoaXMuc2VhcmNoO1xuICAgIH1cbiAgICBpZiAodGhpcy5zaG93RGVsZXRlZCA9PT0gdHJ1ZSkge1xuICAgICAgcXVlcnkuc2hvd0RlbGV0ZWQgPSB0aGlzLnNob3dEZWxldGVkO1xuICAgIH1cbiAgICBxdWVyeS5maWx0ZXJzID0gY2xvbmVEZWVwKHRoaXMuZmlsdGVycyk7XG4gICAgaWYgKHRoaXMucmVsYXRpb25zaGlwcykge1xuICAgICAgcXVlcnkuJHJlbGF0aW9uc2hpcHMgPSB0aGlzLnJlbGF0aW9uc2hpcHM7XG4gICAgfVxuICAgIGlmIChxdWVyeS5maWx0ZXJzLmxlbmd0aCA+IDApIHtcbiAgICAgIHF1ZXJ5LmxvZ2ljID0gdGhpcy5sb2dpYztcbiAgICAgIHF1ZXJ5LmZpbHRlcnMgPSB0aGlzLnRyYW5zZm9ybUZpbHRlcnMocXVlcnkuZmlsdGVycywgdXNlVmFsdWUpO1xuICAgIH1cblxuICAgIGlmICh0aGlzLmFnZ3JlZ2F0ZXMgJiYgdGhpcy5hZ2dyZWdhdGVzLmxlbmd0aCA+IDApIHtcbiAgICAgIHF1ZXJ5LmFnZ3JlZ2F0ZXMgPSB0aGlzLmFnZ3JlZ2F0ZXM7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuc2VsZWN0ZWRGaWVsZHMubGVuZ3RoID4gMCkge1xuICAgICAgcXVlcnkuZmllbGRzID0gdGhpcy5zZWxlY3RlZEZpZWxkcztcbiAgICB9XG5cbiAgICBpZiAodGhpcy5pZ25vcmVGaWVsZHM/Lmxlbmd0aCA+IDApIHtcbiAgICAgIHF1ZXJ5Ll9faWdub3JlRmllbGRzID0gdGhpcy5pZ25vcmVGaWVsZHM7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuc29ydC5sZW5ndGggPiAwKSB7XG4gICAgICBxdWVyeS5zb3J0ID0gdGhpcy5zb3J0O1xuICAgIH1cbiAgICAvLyBlbHNlIGlmIChkZWZhdWx0UXVlcnkgJiYgZGVmYXVsdFF1ZXJ5LnNvcnQpIHtcbiAgICAvLyAgIHF1ZXJ5LnNvcnQgPSBkZWZhdWx0UXVlcnkuc29ydDtcbiAgICAvLyB9XG4gICAgcmV0dXJuIHF1ZXJ5O1xuICB9O1xuXG4gIHRyYW5zZm9ybUZpbHRlcnMoZmlsdGVyczogKEZpbHRlciB8IEZpbHRlckdyb3VwKVtdLCB1c2VWYWx1ZTogYm9vbGVhbikge1xuICAgIGxldCB0cmFuc0Zvcm1lZEZpbHRlcnM6IGFueSA9IFtdO1xuICAgIGZpbHRlcnMuZm9yRWFjaCgoZmlsdGVyOiBGaWx0ZXIgfCBGaWx0ZXJHcm91cCkgPT4ge1xuICAgICAgLy8gdGhpcyBpcyBhIHJlbGF0ZWQgcmVjb3JkIGZpbHRlclxuICAgICAgLy8gaWYgKGZpbHRlci5zdWJGaWVsZHMpIHtcbiAgICAgIC8vICAgZGVsZXRlIGZpbHRlci5zdWJGaWVsZHM7XG4gICAgICAvLyAgIGZpbHRlci5maWVsZCA9IGZpbHRlci5tb2R1bGUgKyAnLicgKyBmaWx0ZXIuZmllbGQ7XG4gICAgICAvLyAgIGRlbGV0ZSBmaWx0ZXIubW9kdWxlO1xuICAgICAgLy8gfVxuXG4gICAgICAvL2lmKGZpbHRlci52YWx1ZSAmJiBpc1N0cmluZyhmaWx0ZXIudmFsdWUpICYmIGZpbHRlci52YWx1ZS5pbmRleE9mKCd7eycpICE9PSAtMSl7XG4gICAgICAvL3NlZSBmb3IgYW55IHF1ZXJ5IG9iamVjdCBpbiBVUkwgaWYgeWVzIHRoZW4gYXBwbHkgd2hlcmUgZXZlciB0aGUge3tleHByZXNzaW9uc319IGFyZSB1c2VkLlxuICAgICAgLy8gaWYoIWFuZ3VsYXIuaXNVbmRlZmluZWQoJHN0YXRlLnBhcmFtcy5xcGFyYW0pICYmIHVzZVZhbHVlKXtcbiAgICAgIC8vICAgdmFyIGludGVycG9sYXRlT2JqZWN0ID0gSlNPTi5wYXJzZSgkc3RhdGUucGFyYW1zLnFwYXJhbSk7XG4gICAgICAvLyAgIGludGVycG9sYXRlT2JqZWN0LmN1cnJlbnRVc2VySXJpID0gY3VycmVudFVzZXJJcmlTZXJ2aWNlO1xuICAgICAgLy8gICBmaWx0ZXIudmFsdWUgPSAkaW50ZXJwb2xhdGUoZmlsdGVyLnZhbHVlKShpbnRlcnBvbGF0ZU9iamVjdCk7XG4gICAgICAvLyAgIGlmKGZpbHRlci51cGRhdGVEYXRlSW50ZXJ2YWxWYWx1ZSl7Ly9pdHMgYSBkYXRldGltZSBmaWx0ZXJcbiAgICAgIC8vICAgICBmaWx0ZXIudmFsdWUgPSBmaWx0ZXIudmFsdWUuaW5kZXhPZignZGlmZmVyZW5jZVR5cGUnKT49MD9KU09OLnBhcnNlKGZpbHRlci52YWx1ZSk6ZmlsdGVyLnZhbHVlOy8vdGhpcyBpcyBjYXNlIG9mIGRhdGVSYW5nZSB3aGVyZSBvYmplY3QgaXMgcGFzc2VkXG4gICAgICAvLyAgICAgZmlsdGVyLnVwZGF0ZURhdGVJbnRlcnZhbFZhbHVlKGZpbHRlcik7XG4gICAgICAvLyAgIH1cbiAgICAgIC8vIH1cbiAgICAgIC8vfVxuICAgICAgaWYgKChmaWx0ZXIgYXMgRmlsdGVyR3JvdXApLmZpbHRlcnM/Lmxlbmd0aCA+IDApIHtcbiAgICAgICAgZmlsdGVyID0gZmlsdGVyIGFzIEZpbHRlckdyb3VwO1xuICAgICAgICBsZXQgcmV0dXJuZWRGaWx0ZXIgPSB0aGlzLnRyYW5zZm9ybUZpbHRlcnMoZmlsdGVyLmZpbHRlcnMsIHVzZVZhbHVlKTtcbiAgICAgICAgbGV0IGZpbHRlck9iaiA9IHtcbiAgICAgICAgICBsb2dpYzogZmlsdGVyLmxvZ2ljLFxuICAgICAgICAgIGZpbHRlcnM6IHJldHVybmVkRmlsdGVyXG4gICAgICAgIH07XG4gICAgICAgIHRyYW5zRm9ybWVkRmlsdGVycy5wdXNoKGZpbHRlck9iaik7XG4gICAgICB9IGVsc2UgaWYgKGZpbHRlciBpbnN0YW5jZW9mIEZpbHRlcikge1xuICAgICAgICB0cmFuc0Zvcm1lZEZpbHRlcnMucHVzaChmaWx0ZXIuZ2V0RmxhdEZpbHRlcigpKTtcbiAgICAgIH1cbiAgICB9KTtcblxuICAgIHJldHVybiB0cmFuc0Zvcm1lZEZpbHRlcnM7XG4gIH1cblxuICBnZXRVUkxRdWVyeShlbnRpdHk6IEVudGl0eSkge1xuICAgIGxldCBmbGF0UXVlcnk6IGFueSA9IHt9O1xuXG4gICAgaWYgKHRoaXMuc2VhcmNoKSB7XG4gICAgICBmbGF0UXVlcnkuJHNlYXJjaCA9IHRoaXMuc2VhcmNoO1xuICAgIH1cblxuICAgIE9iamVjdC5hc3NpZ24oZmxhdFF1ZXJ5LCB0aGlzLmdldFVSTFBhcmFtZXRlcnMoKSk7XG5cbiAgICB0aGlzLmZpbHRlcnMuZm9yRWFjaCgoZmlsdGVyOiBGaWx0ZXIgfCBGaWx0ZXJHcm91cCkgPT4ge1xuICAgICAgaWYgKGZpbHRlciBpbnN0YW5jZW9mIEZpbHRlcikge1xuICAgICAgICBjb25zb2xlLmxvZyhmaWx0ZXIuZ2V0VVJMUXVlcnkoZW50aXR5KSk7XG4gICAgICAgIE9iamVjdC5hc3NpZ24oZmxhdFF1ZXJ5LCBmaWx0ZXIuZ2V0VVJMUXVlcnkoZW50aXR5KSk7XG4gICAgICB9XG4gICAgfSk7XG5cbiAgICByZXR1cm4gZmxhdFF1ZXJ5O1xuICB9XG5cbiAgYXNGaWx0ZXJHcm91cCgpIHtcbiAgICByZXR1cm4gbmV3IEZpbHRlckdyb3VwKHRoaXMuZmlsdGVycywgdGhpcy5sb2dpYyk7XG4gIH1cblxufVxuXG5leHBvcnQgaW50ZXJmYWNlIFF1ZXJ5U29ydCB7XG4gIGZpZWxkOiBzdHJpbmcsXG4gIGRpcmVjdGlvbjogJ0FTQycgfCAnREVTQycgfCAnJyxcbiAgX2ZpZWxkTmFtZT86IHN0cmluZ1xufVxuIl19