/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { timer } from "rxjs";
import { last, scan, switchMap, takeWhile, tap } from "rxjs/operators";
function attemptsGuardFactory(maxAttempts) {
    return (attemptsCount) => {
        if (attemptsCount > maxAttempts) {
            throw new Error("Exceeded maxAttempts");
        }
    };
}
export function pollWhile(pollInterval, isPollingActive, maxAttempts = Infinity, emitOnlyLast = false) {
    return source$ => {
        const poll$ = timer(0, pollInterval).pipe(scan(attempts => ++attempts, 0), tap(attemptsGuardFactory(maxAttempts)), switchMap(() => source$), takeWhile(isPollingActive, true));
        return emitOnlyLast ? poll$.pipe(last()) : poll$;
    };
}
//# sourceMappingURL=data:application/json;base64,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