/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable, Pipe } from '@angular/core';
import * as i0 from "@angular/core";
export class InterpolatePipe {
    transform(stringTemplate, interpolateObject) {
        function getNestedValue(obj, keyPath) {
            return keyPath.split('.').reduce((acc, key) => (acc && acc[key] !== undefined) ? acc[key] : '', obj);
        }
        function interpolate(template, data) {
            return template.replace(/{{([\s\S]+?)}}/g, (match, p1) => getNestedValue(data, p1.trim()) || '');
        }
        const extendedContext = interpolateObject;
        return interpolate(stringTemplate, extendedContext);
    }
    static { this.ɵfac = function InterpolatePipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || InterpolatePipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "interpolate", type: InterpolatePipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: InterpolatePipe, factory: InterpolatePipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(InterpolatePipe, [{
        type: Pipe,
        args: [{
                name: 'interpolate'
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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