/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Pipe } from '@angular/core';
import * as i0 from "@angular/core";
export class IsHexColorLightPipe {
    transform(color) {
        if (!color) {
            return false;
        }
        const hex = color.replace('#', '');
        const colorRed = parseInt(hex.substring(0, 2), 16);
        const colorGreen = parseInt(hex.substring(2, 2), 16);
        const colorBlue = parseInt(hex.substring(4, 2), 16);
        const brightness = ((colorRed * 299) + (colorGreen * 587) + (colorBlue * 114)) / 1000;
        return brightness > 155;
    }
    static { this.ɵfac = function IsHexColorLightPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || IsHexColorLightPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "isHexColorLight", type: IsHexColorLightPipe, pure: true }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IsHexColorLightPipe, [{
        type: Pipe,
        args: [{
                name: 'isHexColorLight'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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