/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable, Pipe } from '@angular/core';
import * as i0 from "@angular/core";
export class SearchByPipe {
    transform(value = [], query = '', keys = []) {
        if (query === '') {
            return value;
        }
        else {
            return value.filter((val) => keys.some(key => val.hasOwnProperty(key) && new RegExp(query, 'gi').test(val[key])));
        }
    }
    static { this.ɵfac = function SearchByPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SearchByPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "searchBy", type: SearchByPipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: SearchByPipe, factory: SearchByPipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SearchByPipe, [{
        type: Pipe,
        args: [{
                name: 'searchBy',
                pure: true
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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