import { Injectable } from '@angular/core';
import { plainToInstance } from 'class-transformer';
import { concatMap, map } from 'rxjs';
import { API, FIXED_MODULE } from 'shared';
import { ExportJob } from './models/export-job';
import { ExportTemplate } from './models/export-template';
import { pollWhile } from 'shared';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
export class ExportConfigService {
    constructor(http) {
        this.http = http;
        this.OPTIONS_INTERVAL_SECONDS = 2;
        this.OPTIONS_TIMEOUT_SECONDS = 150; // 5 minutes
    }
    saveTemplate(template) {
        let observable$;
        if (template.uuid) {
            observable$ = this.http.put(API.PORTER + FIXED_MODULE.EXPORT_TEMPLATES + '/' + template.uuid + '/', template);
        }
        else {
            observable$ = this.http.post(API.PORTER + FIXED_MODULE.EXPORT_TEMPLATES + '/', template);
        }
        return observable$.pipe(map((response) => plainToInstance(ExportTemplate, response)));
    }
    runExport(template, fileName) {
        return this.http.put(API.PORTER + FIXED_MODULE.EXPORT_TEMPLATES + '/' + template.uuid + '/trigger/', null, {
            params: {
                fileName: fileName,
                template: template.uuid || ''
            }
        }).pipe(concatMap((response) => {
            let exportJob = new ExportJob(response.export_id);
            return this.loadExportJob(exportJob.uuid)
                .pipe(pollWhile(this.OPTIONS_INTERVAL_SECONDS * 1000, (exportJob) => exportJob.status !== 'Complete' && exportJob.status !== 'Error', this.OPTIONS_TIMEOUT_SECONDS));
        }));
    }
    loadExportJob(exportJobUuid) {
        return this.http.get(API.PORTER + FIXED_MODULE.EXPORT_JOBS + '/' + exportJobUuid + '/').pipe(map((response) => plainToInstance(ExportJob, response)));
    }
    static { this.ɵfac = function ExportConfigService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ExportConfigService)(i0.ɵɵinject(i1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ExportConfigService, factory: ExportConfigService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ExportConfigService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }], null); })();
//# sourceMappingURL=data:application/json;base64,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