/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, EventEmitter, Input, Output } from '@angular/core';
import * as i0 from "@angular/core";
export class AbstractImportFilterComponent {
    constructor() {
        this.dataChange = new EventEmitter();
        this.values = [];
        this.checkAlls = {
            include: false
        };
        this.sectionKey = '';
        this.configKey = '';
    }
    ngOnInit() {
        if (this.wizard.data.importJob && this.wizard.data.importJob.options[this.sectionKey]) {
            this.values = this.wizard.data.importJob.options[this.sectionKey][this.configKey] || [];
            this.checkAlls.include = !this.values.find((value) => !value.include);
        }
    }
    checkAllChanged(key = 'include') {
        this.values.forEach((option) => {
            option[key] = this.checkAlls[key];
        });
        this.onOptionsChange();
    }
    onOptionsChange() {
        if (!this.wizard.data.importJob) {
            return;
        }
        const includedOptions = this.values.filter((option) => option.include);
        this.checkAlls.include = includedOptions.length === this.values.length;
        this.wizard.data.importJob.options[this.sectionKey][this.configKey] = this.values;
        this.dataChange.emit();
    }
    buttonClicked(option, key = 'include') {
        option[key] = !option[key];
        this.onOptionsChange();
    }
    static { this.ɵfac = function AbstractImportFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractImportFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractImportFilterComponent, selectors: [["xf-abstract-filter-option"]], inputs: { wizard: "wizard" }, outputs: { dataChange: "dataChange" }, decls: 0, vars: 0, template: function AbstractImportFilterComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractImportFilterComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-filter-option',
                template: ''
            }]
    }], () => [], { wizard: [{
            type: Input
        }], dataChange: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractImportFilterComponent, { className: "AbstractImportFilterComponent", filePath: "src/import/abstract-import-filter.component.ts", lineNumber: 14 }); })();
//# sourceMappingURL=data:application/json;base64,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