import { Injectable } from '@angular/core';
import { catchError, forkJoin, from, map, of } from 'rxjs';
import { CheckboxField } from 'shared';
import { difference } from 'lodash-es';
import { loadRemoteModule } from '@angular-architects/native-federation';
import * as i0 from "@angular/core";
import * as i1 from "shared";
export class PortingService {
    constructor(manifestService, permissionService) {
        this.manifestService = manifestService;
        this.permissionService = permissionService;
    }
    getStatusColumn() {
        return (params) => {
            let className = params.data?.errorMessage ? 'text-danger' : (params.value === 'In progress' ? 'text-muted muted-40' : 'text-success');
            return `<i class="align-middle fa fa-circle fa-lg font-size-8px ${className}"></i>
              <span class="font-size-12px margin-left-8px muted-10">${params.value}
              ${params.data?.errorMessage ? '<i class="fa fa-duotone fa-info-circle"></i>' : ''}</span>`;
        };
    }
    getConfigs(type, localClassMap) {
        let manifests = this.manifestService.get();
        let configObservables$ = [];
        manifests.forEach((manifest) => {
            if (!manifest.views.portingConfigs) {
                return;
            }
            const flatPermissions = this.permissionService.getAllFlatPermissions();
            manifest.views.portingConfigs.forEach(config => {
                let observable$ = null;
                if (type === 'export') {
                    if (difference(config.permissions, flatPermissions).length === 0) {
                        observable$ = this.loadRemoteSection(manifest.remoteEntry, config.exportFilterComponent, localClassMap, 'AbstractExportFilterComponent').pipe(map((exportFilterComponent) => {
                            return {
                                exportFilterComponent: exportFilterComponent
                            };
                        }));
                    }
                }
                else {
                    observable$ = this.loadRemoteSection(manifest.remoteEntry, config.importFilterComponent, localClassMap, 'AbstractImportFilterComponent').pipe(map((importFilterComponent) => {
                        return {
                            importFilterComponent: importFilterComponent
                        };
                    }));
                }
                if (observable$ !== null) {
                    const portingConfigObservable$ = observable$.pipe(map((object) => {
                        let field = new CheckboxField(config.name);
                        field.viewMode = 'checkbox';
                        field.title = config.label;
                        let portingConfig = {
                            name: config.name,
                            label: config.label,
                            countLabel: config.countLabel,
                            field: field,
                            dataSource: config.dataSource,
                            service: config.service || manifest.name,
                            manifest: manifest.name,
                            ...object
                        };
                        return portingConfig;
                    }));
                    configObservables$.push(portingConfigObservable$);
                }
            });
        });
        return forkJoin(configObservables$);
    }
    loadRemoteSection(remoteEntry, className, localClassMap, type) {
        if (!remoteEntry) {
            return of(type === 'AbstractExportFilterComponent' ? localClassMap[className] : localClassMap[className]);
        }
        const options = {
            remoteEntry: remoteEntry,
            exposedModule: './' + className,
            className: className
        };
        return from(loadRemoteModule(options)).pipe(catchError((error) => {
            console.error(error, remoteEntry);
            return of({});
        }), map((exposedModules) => {
            return exposedModules[options.className];
        }));
    }
    static { this.ɵfac = function PortingService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PortingService)(i0.ɵɵinject(i1.ManifestService), i0.ɵɵinject(i1.PermissionService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PortingService, factory: PortingService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PortingService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.ManifestService }, { type: i1.PermissionService }], null); })();
//# sourceMappingURL=data:application/json;base64,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