import { ChangeDetectionStrategy, Component, Input, ViewChildren } from '@angular/core';
import { FormControl, Validators } from '@angular/forms';
import { plainToInstance } from 'class-transformer';
import { cloneDeep, forEach, keys } from 'lodash-es';
import { map, of, switchMap, tap } from 'rxjs';
import { FIXED_MODULE, FormFieldComponent, PERMISSION, Query, Schedule, TimezoneSelectComponent } from 'shared';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "shared";
import * as i3 from "@ng-bootstrap/ng-bootstrap";
import * as i4 from "@angular/common/http";
import * as i5 from "ngx-toastr";
import * as i6 from "@angular/common";
import * as i7 from "@jsverse/transloco";
function ScheduleDetailComponent_div_0_div_5_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "xf-form-field", 14);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.reference)("formControlName", ctx_r1.scheduleEntity.fields.reference.name)("autoFocus", true);
} }
function ScheduleDetailComponent_div_0_div_5_Conditional_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 17);
    i0.ɵɵelement(1, "i", 25);
    i0.ɵɵelementStart(2, "small");
    i0.ɵɵtext(3, "The playbook referenced is inactive. The schedule will not run it until it is changed to active.");
    i0.ɵɵelementEnd()();
} }
function ScheduleDetailComponent_div_0_div_5_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 8)(1, "form", 9, 0);
    i0.ɵɵlistener("ngSubmit", function ScheduleDetailComponent_div_0_div_5_Template_form_ngSubmit_1_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.save()); });
    i0.ɵɵelementStart(3, "div", 10)(4, "div", 11)(5, "div", 12)(6, "div", 13);
    i0.ɵɵelement(7, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(8, "div", 15);
    i0.ɵɵelement(9, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(10, ScheduleDetailComponent_div_0_div_5_div_10_Template, 2, 3, "div", 16)(11, ScheduleDetailComponent_div_0_div_5_Conditional_11_Template, 4, 0, "div", 17);
    i0.ɵɵelementStart(12, "div", 18)(13, "label", 19);
    i0.ɵɵtext(14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(15, "div", 20);
    i0.ɵɵelement(16, "xf-cron-editor", 21);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(17, "div", 15)(18, "label", 19);
    i0.ɵɵtext(19);
    i0.ɵɵelementEnd();
    i0.ɵɵelement(20, "xf-timezone-select", 22);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(21, "div", 15);
    i0.ɵɵelement(22, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(23, "div", 23)(24, "div", 24);
    i0.ɵɵelement(25, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(26, "div", 24);
    i0.ɵɵelement(27, "xf-form-field", 14);
    i0.ɵɵelementEnd()()()()()()();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext().$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance(6);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.name)("formControlName", ctx_r1.scheduleEntity.fields.name.name)("autoFocus", true);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.enabled)("formControlName", ctx_r1.scheduleEntity.fields.enabled.name)("autoFocus", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.playbookPermissions.includes(ctx_r1.permission.READ) && ctx_r1.showReference);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r1.showPBRefWarning ? 11 : -1);
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(t_r4("components.schedule.labels.frequency"));
    i0.ɵɵadvance(5);
    i0.ɵɵtextInterpolate(t_r4("components.schedule.labels.timezone"));
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("field", ctx_r1.exitRunningField)("formControlName", ctx_r1.scheduleEntity.fields.exit_if_running.name)("autoFocus", true);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.start_time)("formControlName", ctx_r1.scheduleEntity.fields.start_time.name)("autoFocus", true);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.expires)("formControlName", ctx_r1.scheduleEntity.fields.expires.name)("autoFocus", true);
} }
function ScheduleDetailComponent_div_0_div_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 26)(1, "div", 27)(2, "span", 28);
    i0.ɵɵtext(3, "Loading...");
    i0.ɵɵelementEnd()()();
} }
function ScheduleDetailComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 29)(1, "button", 30);
    i0.ɵɵlistener("click", function ScheduleDetailComponent_div_0_div_7_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.save()); });
    i0.ɵɵelement(2, "i", 31);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 32);
    i0.ɵɵlistener("click", function ScheduleDetailComponent_div_0_div_7_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelement(5, "i", 33);
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r4("buttons.save"), " ");
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r4("buttons.cancel"), " ");
} }
function ScheduleDetailComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div", 2)(2, "h4", 3);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 4);
    i0.ɵɵlistener("click", function ScheduleDetailComponent_div_0_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(5, ScheduleDetailComponent_div_0_div_5_Template, 28, 20, "div", 5)(6, ScheduleDetailComponent_div_0_div_6_Template, 4, 0, "div", 6)(7, ScheduleDetailComponent_div_0_div_7_Template, 7, 2, "div", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const t_r4 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(t_r4("components.schedule.title"));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
} }
export class ScheduleDetailComponent {
    constructor(formBuilder, scheduleService, apiService, activeOffCanvas, timezoneService, changeDetectorRef, entityService, http, toaster, systemSettingsService, permissionService) {
        this.formBuilder = formBuilder;
        this.scheduleService = scheduleService;
        this.apiService = apiService;
        this.activeOffCanvas = activeOffCanvas;
        this.timezoneService = timezoneService;
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.http = http;
        this.toaster = toaster;
        this.systemSettingsService = systemSettingsService;
        this.permissionService = permissionService;
        this.mode = 'new';
        this.showReference = false;
        this.scheduleFormFields = {};
        this.savingSchedule = false;
        this.referenceList = [];
        this.loading = true;
        this.permission = PERMISSION;
        this.showPBRefWarning = false;
        this.excludeFormControl = [];
        this.playbookPermissions = this.permissionService.getPermission(FIXED_MODULE.PLAYBOOK);
    }
    ngOnInit() {
        if (!this.showReference) {
            this.excludeFormControl.push('reference');
        }
        this.systemSettings = this.systemSettingsService.get();
        this.entityService.build(FIXED_MODULE.SCHEDULES).pipe(switchMap((entity) => {
            this.scheduleEntity = cloneDeep(entity);
            this.exitRunningField = cloneDeep(this.scheduleEntity.fields.exit_if_running);
            this.exitRunningField.viewMode = 'checkbox';
            this.timezone = this.schedule.crontab.timezone ? this.timezoneService.getTimezoneByName(this.schedule.crontab.timezone) : undefined;
            this.timezone = this.timezone ?? this.timezoneService.getTimezoneByAbbr(this.systemSettings?.preferences.defaultTimezone || 'UTC');
            this.timezone = this.timezone ?? this.timezoneService.getTimezoneByAbbr('UTC');
            this.formGroup = this.formBuilder.group({
                crontab: [this.schedule.crontab],
                timezone: [this.timezone]
            });
            this.setFormGroupControls();
            if (this.mode === 'new') {
                this.formGroup.patchValue({
                    enabled: false,
                    reference: this.referenceData ?? null
                });
                this.loading = false;
                this.changeDetectorRef.detectChanges();
            }
            else if (this.mode === 'edit') {
                return this.loadSchedule();
            }
            return of('');
        }), tap(() => {
            this.loading = false;
            this.changeDetectorRef.detectChanges();
        }), switchMap(() => this.formGroup.valueChanges), tap((values) => {
            keys(values).forEach((key) => {
                let value = values[key];
                if (value && this.scheduleEntity.fields[key] && this.scheduleEntity.fields[key].formType === 'datetime') {
                    value = new Date(value).toISOString();
                }
                if (key === 'timezone') {
                    this.timezone = value;
                }
                else {
                    this.schedule[key] = value;
                }
            });
        })).subscribe();
        this.formGroup.valueChanges.subscribe((changes) => {
            if (changes.reference) {
                this.showPBRefWarning = !changes.reference.isActive;
                this.changeDetectorRef.detectChanges();
            }
        });
    }
    setFormGroupControls() {
        forEach(this.scheduleEntity.fields, (field) => {
            if (field.isFormField && this.excludeFormControl.indexOf(field.name) === -1) {
                let fieldCtrl = new FormControl(this.schedule[field.name] || null);
                if (field.validation.required) {
                    fieldCtrl.addValidators(Validators.required);
                }
                this.formGroup.addControl(field.name, fieldCtrl);
            }
        });
    }
    loadSchedule() {
        this.formGroup.patchValue({
            name: this.schedule.name,
            enabled: this.schedule.enabled,
            timezone: this.timezoneService.getTimezoneByName(this.schedule.kwargs.timezone),
            exit_if_running: this.schedule.kwargs.exit_if_running ?? false,
            start_time: Date.parse(this.schedule.start_time) ?? null,
            expires: Date.parse(this.schedule.expires) ?? null,
            crontab: this.schedule.crontab
        });
        if (!this.schedule.kwargs.wf_iri || !this.showReference) {
            return of(null);
        }
        return this.entityService.build(FIXED_MODULE.PLAYBOOK).pipe(switchMap((playbookEntity) => {
            const playbookUuid = this.schedule.kwargs.wf_iri.split('/')[4];
            const query = plainToInstance(Query, {
                filters: [{
                        field: 'uuid',
                        operator: 'eq',
                        value: playbookUuid
                    }]
            });
            return this.apiService.query(playbookEntity, query.getQueryObject(), {}, true).pipe(map((playbookResponse) => {
                if (playbookResponse['hydra:totalItems'] === 0) {
                    console.warn('Playbook not found (' + this.schedule.kwargs.wf_iri + ')');
                    return null;
                }
                return playbookResponse['hydra:member'][0];
            }), map((playbook) => {
                this.formGroup.patchValue({
                    reference: playbook
                });
            }));
        }));
    }
    save() {
        if (this.formGroup.invalid) {
            this.formGroup.markAllAsTouched();
            for (let formField of [...this.timezoneSelectComponents, ...this.formFieldComponents]) {
                if (!formField.valid) {
                    formField.focus();
                    break;
                }
            }
            return;
        }
        this.savingSchedule = true;
        this.schedule.crontab.timezone = this.timezone?.value || '';
        let observable$;
        let toasterSuccessMessage; // i18n?
        this.schedule.crontab.hour = this.schedule.crontab.hour.toString();
        this.schedule.crontab.minute = this.schedule.crontab.minute.toString();
        let schedule = plainToInstance(Schedule, this.schedule);
        schedule.id = this.schedule.id;
        schedule.kwargs = this.schedule.kwargs;
        schedule.kwargs.exit_if_running = this.schedule.exit_if_running;
        schedule.kwargs.timezone = this.schedule.crontab.timezone;
        schedule.crontab = this.schedule.crontab;
        schedule.kwargs.utcOffset = this.timezone?.utcOffset;
        schedule.enabled = this.formGroup.value.enabled;
        if (this.schedule.reference && this.schedule.reference['@id']) {
            schedule.kwargs.wf_iri = this.schedule.reference['@id'];
        }
        if (this.mode === 'new') {
            observable$ = this.scheduleService.create(schedule);
            toasterSuccessMessage = 'Schedule Created';
        }
        else if (this.mode === 'edit') {
            // TODO : Is there a better way to do this
            observable$ = this.scheduleService.update(schedule);
            toasterSuccessMessage = 'Schedule Updated';
        }
        observable$.subscribe({
            next: ((response) => {
                this.toaster.success(toasterSuccessMessage, 'Success');
                this.activeOffCanvas.close(response);
            })
        });
    }
    cancel() {
        this.activeOffCanvas.close();
    }
    static { this.ɵfac = function ScheduleDetailComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScheduleDetailComponent)(i0.ɵɵdirectiveInject(i1.FormBuilder), i0.ɵɵdirectiveInject(i2.ScheduleService), i0.ɵɵdirectiveInject(i2.ApiService), i0.ɵɵdirectiveInject(i3.NgbActiveOffcanvas), i0.ɵɵdirectiveInject(i2.TimezoneService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.EntityService), i0.ɵɵdirectiveInject(i4.HttpClient), i0.ɵɵdirectiveInject(i5.ToastrService), i0.ɵɵdirectiveInject(i2.SystemSettingsService), i0.ɵɵdirectiveInject(i2.PermissionService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ScheduleDetailComponent, selectors: [["xf-schedule-detail"]], viewQuery: function ScheduleDetailComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(TimezoneSelectComponent, 5);
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.timezoneSelectComponents = _t);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFieldComponents = _t);
        } }, inputs: { mode: "mode", schedule: "schedule", showReference: "showReference", referenceData: "referenceData" }, decls: 1, vars: 0, consts: [["addScheduleForm", "ngForm"], [4, "transloco"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "page-title-font", "modal-title", "muted-10"], ["type", "button", "id", "close-btn", 1, "btn", "btn-close", 3, "click"], ["class", "modal-body", 4, "ngIf"], ["class", "d-flex justify-content-center align-items-center", 4, "ngIf"], ["class", "modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px", 4, "ngIf"], [1, "modal-body"], [1, "padding-top-20px", "padding-bottom-20px", 3, "ngSubmit", "formGroup"], [1, "row", "m-0"], [1, "col-md-12"], [1, "form-group"], [1, "margin-bottom-8px"], ["fieldClass", "form-control-sm margin-bottom-8px w-100", 3, "field", "formControlName", "autoFocus"], [1, "margin-bottom-12px"], [4, "ngIf"], [1, "text-warning", "content-font", "fw-medium", "line-height-15px", "margin-top-8px"], [1, "margin-bottom-12px", "margin-top-12px"], [1, "form-label", "mb-1"], [1, "mb-2"], ["formControlName", "crontab"], ["formControlName", "timezone"], [1, "margin-bottom-12px", "d-flex"], [1, "col-md-6"], [1, "fa", "fa-warning", "fa-regular", "margin-right-4px"], [1, "d-flex", "justify-content-center", "align-items-center"], ["role", "status", 1, "spinner-border"], [1, "visually-hidden"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "margin-right-8px", 3, "click"], [1, "fa", "fa-check", "margin-right-4px"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", "me-2", 3, "click"], [1, "fa", "fa-times", "margin-right-4px"]], template: function ScheduleDetailComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ScheduleDetailComponent_div_0_Template, 8, 4, "div", 1);
        } }, dependencies: [i6.NgIf, i1.ɵNgNoValidate, i1.NgControlStatus, i1.NgControlStatusGroup, i2.FormFieldComponent, i1.FormGroupDirective, i1.FormControlName, i2.CronEditorComponent, i2.TimezoneSelectComponent, i7.TranslocoDirective], styles: [".close-btn[_ngcontent-%COMP%]{left:-50px;position:absolute}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScheduleDetailComponent, [{
        type: Component,
        args: [{ selector: 'xf-schedule-detail', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div *transloco=\"let t\">\n<!-- Header -->\n<div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n  <h4 class=\"page-title-font modal-title muted-10\">{{ t('components.schedule.title') }}</h4>\n  <button type=\"button\" id=\"close-btn\" (click)=\"cancel()\" class=\"btn btn-close\"></button>\n\n</div>\n<!-- Body -->\n<div *ngIf=\"!loading\" class=\"modal-body\">\n  <form #addScheduleForm=\"ngForm\" (ngSubmit)=\"save()\" [formGroup]=\"formGroup\" class=\"padding-top-20px padding-bottom-20px\">\n    <div class=\"row m-0\">\n      <div class=\"col-md-12\">\n        <div class=\"form-group\">\n          <div class=\"margin-bottom-8px\">\n            <xf-form-field [field]=\"scheduleEntity.fields.name\"\n              [formControlName]=\"scheduleEntity.fields.name.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          <div class=\"margin-bottom-12px\">\n            <xf-form-field [field]=\"scheduleEntity.fields.enabled\"\n              [formControlName]=\"scheduleEntity.fields.enabled.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          <div *ngIf=\"playbookPermissions.includes(permission.READ) && showReference\">\n            <xf-form-field [field]=\"scheduleEntity.fields.reference\"\n              [formControlName]=\"scheduleEntity.fields.reference.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          @if (showPBRefWarning) {\n            <div class=\"text-warning content-font fw-medium line-height-15px margin-top-8px\">\n              <i class=\"fa fa-warning fa-regular margin-right-4px\"></i>\n              <small>The playbook referenced is inactive. The schedule will not run it until it is changed to active.</small>\n            </div>\n          }\n          <div class=\"margin-bottom-12px margin-top-12px\">\n            <label class=\"form-label mb-1\">{{ t('components.schedule.labels.frequency') }}</label>\n            <div class=\"mb-2\">\n              <xf-cron-editor formControlName=\"crontab\"></xf-cron-editor>\n            </div>\n          </div>\n          <div class=\"margin-bottom-12px\">\n            <label class=\"form-label mb-1\">{{ t('components.schedule.labels.timezone') }}</label>\n            <xf-timezone-select formControlName=\"timezone\"></xf-timezone-select>\n          </div>\n          <div class=\"margin-bottom-12px\">\n            <xf-form-field [field]=\"exitRunningField\"\n              [formControlName]=\"scheduleEntity.fields.exit_if_running.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          <div class=\"margin-bottom-12px d-flex\">\n            <div class=\"col-md-6\">\n              <xf-form-field [field]=\"scheduleEntity.fields.start_time\"\n                [formControlName]=\"scheduleEntity.fields.start_time.name\"\n                fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n\n            </div>\n            <div class=\"col-md-6\">\n              <xf-form-field [field]=\"scheduleEntity.fields.expires\"\n                [formControlName]=\"scheduleEntity.fields.expires.name\"\n                fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </form>\n</div>\n<div class=\"d-flex justify-content-center align-items-center\" *ngIf=\"loading\">\n  <div class=\"spinner-border\" role=\"status\">\n    <span class=\"visually-hidden\">Loading...</span>\n  </div>\n</div>\n<!-- Footer -->\n<div *ngIf=\"!loading\" class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px\">\n  <button type=\"button\" class=\"btn btn-primary btn-sm margin-right-8px\" (click)=\"save()\">\n    <i class=\"fa fa-check margin-right-4px\"></i>{{ t('buttons.save') }}\n  </button>\n  <button type=\"button\" class=\"btn btn-secondary btn-sm me-2\" (click)=\"cancel()\">\n    <i class=\"fa fa-times margin-right-4px\"></i>{{ t('buttons.cancel') }}\n  </button>\n</div>\n</div>\n", styles: [".close-btn{left:-50px;position:absolute}\n"] }]
    }], () => [{ type: i1.FormBuilder }, { type: i2.ScheduleService }, { type: i2.ApiService }, { type: i3.NgbActiveOffcanvas }, { type: i2.TimezoneService }, { type: i0.ChangeDetectorRef }, { type: i2.EntityService }, { type: i4.HttpClient }, { type: i5.ToastrService }, { type: i2.SystemSettingsService }, { type: i2.PermissionService }], { mode: [{
            type: Input
        }], schedule: [{
            type: Input
        }], showReference: [{
            type: Input
        }], referenceData: [{
            type: Input
        }], timezoneSelectComponents: [{
            type: ViewChildren,
            args: [TimezoneSelectComponent]
        }], formFieldComponents: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ScheduleDetailComponent, { className: "ScheduleDetailComponent", filePath: "src/schedule-detail/schedule-detail.component.ts", lineNumber: 22 }); })();
//# sourceMappingURL=data:application/json;base64,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