/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component } from "@angular/core";
import { FIXED_MODULE, PERMISSION } from "shared";
import { ScheduleDetailComponent } from "../../../schedule-detail/schedule-detail.component";
import { concatMap, of } from "rxjs";
import { HttpErrorResponse } from "@angular/common/http";
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "shared";
import * as i3 from "ngx-toastr";
import * as i4 from "@jsverse/transloco";
import * as i5 from "@angular/common";
function ActionsRenderer_div_1_i_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i", 13);
} }
function ActionsRenderer_div_1_i_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i", 14);
} }
function ActionsRenderer_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "button", 10);
    i0.ɵɵlistener("click", function ActionsRenderer_div_1_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.startStop(ctx_r1.cellValue.enabled)); });
    i0.ɵɵtemplate(2, ActionsRenderer_div_1_i_2_Template, 1, 0, "i", 11)(3, ActionsRenderer_div_1_i_3_Template, 1, 0, "i", 12);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.cellValue.enabled);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.cellValue.enabled);
} }
function ActionsRenderer_a_7_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "a", 15);
    i0.ɵɵlistener("click", function ActionsRenderer_a_7_Template_a_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.triggerNow()); });
    i0.ɵɵelement(1, "i", 16);
    i0.ɵɵtext(2, " Trigger Now ");
    i0.ɵɵelementEnd();
} }
function ActionsRenderer_li_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "li", 17);
} }
function ActionsRenderer_a_10_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "a", 18);
    i0.ɵɵlistener("click", function ActionsRenderer_a_10_Template_a_click_0_listener() { i0.ɵɵrestoreView(_r4); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.edit()); });
    i0.ɵɵelement(1, "i", 19);
    i0.ɵɵtext(2, " Edit ");
    i0.ɵɵelementEnd();
} }
function ActionsRenderer_li_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "li", 17);
} }
function ActionsRenderer_a_13_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "a", 20);
    i0.ɵɵlistener("click", function ActionsRenderer_a_13_Template_a_click_0_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.deleteSchedule()); });
    i0.ɵɵelement(1, "i", 21);
    i0.ɵɵtext(2, " Delete ");
    i0.ɵɵelementEnd();
} }
export class ActionsRenderer {
    constructor(offcanvasService, changeDetectorRef, scheduleService, toaster, permissionService, modalService, translocoService) {
        this.offcanvasService = offcanvasService;
        this.changeDetectorRef = changeDetectorRef;
        this.scheduleService = scheduleService;
        this.toaster = toaster;
        this.permissionService = permissionService;
        this.modalService = modalService;
        this.translocoService = translocoService;
        this.showDropdown = false;
        this.permission = PERMISSION;
        this.schedulePermissions = this.permissionService.getPermission(FIXED_MODULE.SCHEDULES);
    }
    // gets called once before the renderer is used
    agInit(params) {
        let value = this.getValueToDisplay(params);
        this.cellValue = value.data;
        this.param = params;
    }
    // gets called whenever the cell refreshes
    refresh(params) {
        // set value into cell again
        this.cellValue = this.getValueToDisplay(params);
        return true;
    }
    getValueToDisplay(params) {
        return params.valueFormatted ? params.valueFormatted : params;
    }
    edit() {
        this.offcanvasInstanceSchedule = this.offcanvasService.open(ScheduleDetailComponent, {
            animation: true,
            position: 'end',
            panelClass: 'schedule-list-modal offcanvas-slide-left',
            scroll: false,
            backdrop: false
        });
        this.offcanvasInstanceSchedule.componentInstance.showReference = true;
        this.offcanvasInstanceSchedule.componentInstance.mode = 'edit';
        this.offcanvasInstanceSchedule.componentInstance.schedule = this.cellValue.data ? this.cellValue.data : this.cellValue;
        this.offcanvasInstanceSchedule.closed.subscribe((result) => {
            if (result) {
                this.param.api.refreshServerSide();
            }
        });
    }
    deleteSchedule() {
        this.modalService.confirm(this.translocoService.translate('components.schedule.delete_confirmation', {
            scheduleName: this.cellValue.name
        })).pipe(concatMap((result) => {
            if (!result) {
                return of();
            }
            return this.scheduleService.delete(this.cellValue.id);
        })).subscribe({
            next: () => {
                this.toaster.success(this.translocoService.translate('components.schedule.delete_success', {
                    scheduleName: this.cellValue.name
                }), 'Success');
                this.param.api.refreshServerSide();
            }, error: (e) => {
                if (e instanceof HttpErrorResponse) {
                    this.toaster.error(this.translocoService.translate('components.schedule.delete_error', {
                        scheduleName: this.cellValue.name
                    }), 'Error');
                }
            }
        });
    }
    triggerNow() {
        this.scheduleService.trigger(this.cellValue.id).subscribe({
            next: (() => {
                this.toaster.success('Schedule Triggered', 'Success');
            }), error: (() => {
                this.toaster.error('Schedule Trigger Failed', 'Error');
            })
        });
    }
    showDropDown() {
        this.showDropdown = true;
    }
    startStop(startSchedule) {
        this.cellValue.enabled = !startSchedule;
        this.scheduleService.update(this.cellValue).subscribe(() => {
            this.changeDetectorRef.detectChanges();
        });
    }
    static { this.ɵfac = function ActionsRenderer_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ActionsRenderer)(i0.ɵɵdirectiveInject(i1.NgbOffcanvas), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.ScheduleService), i0.ɵɵdirectiveInject(i3.ToastrService), i0.ɵɵdirectiveInject(i2.PermissionService), i0.ɵɵdirectiveInject(i2.ModalService), i0.ɵɵdirectiveInject(i4.TranslocoService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ActionsRenderer, selectors: [["ng-component"]], decls: 14, vars: 6, consts: [[1, "d-flex"], [4, "ngIf"], ["ngbDropdown", "", "container", "body", 1, "margin-right-8px"], ["ngbDropdownToggle", "", "id", "settings-schedule", "type", "button", "title", "Settings Schedule", 1, "dropdown-toggle", "btn", "btn-secondary", "btn-sm", "dropdown-caret-off"], [1, "fa-solid", "fa-ellipsis-stroke"], ["ngbDropdownMenu", "", "aria-labelledby", "scheduleActions", 1, "dropdown-menu", "mx-0", "border-0", "shadow"], ["ngbDropdownItem", "", "id", "trigger-schedule-btn", "class", "cursor-pointer", 3, "click", 4, "ngIf"], ["class", "dropdown-divider", 4, "ngIf"], ["ngbDropdownItem", "", "id", "edit-schedule-btn", "class", "cursor-pointer", 3, "click", 4, "ngIf"], ["ngbDropdownItem", "", "id", "delete-schedule-btn", "class", "cursor-pointer", 3, "click", 4, "ngIf"], ["id", "start-stop-schedule", "type", "button", "title", "Start Schedule", 1, "btn", "btn-secondary", "btn-sm", "me-2", 3, "click"], ["class", "fa fa-play", 4, "ngIf"], ["class", "fa fa-pause", 4, "ngIf"], [1, "fa", "fa-play"], [1, "fa", "fa-pause"], ["ngbDropdownItem", "", "id", "trigger-schedule-btn", 1, "cursor-pointer", 3, "click"], ["aria-hidden", "false", 1, "fa", "fa-bolt", "margin-right-4px"], [1, "dropdown-divider"], ["ngbDropdownItem", "", "id", "edit-schedule-btn", 1, "cursor-pointer", 3, "click"], ["aria-hidden", "false", 1, "fa", "fa-pencil", "margin-right-4px"], ["ngbDropdownItem", "", "id", "delete-schedule-btn", 1, "cursor-pointer", 3, "click"], ["aria-hidden", "false", 1, "fa", "fa-trash", "margin-right-4px"]], template: function ActionsRenderer_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, ActionsRenderer_div_1_Template, 4, 2, "div", 1);
            i0.ɵɵelementStart(2, "div", 2)(3, "button", 3);
            i0.ɵɵelement(4, "i", 4);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "div", 5)(6, "li");
            i0.ɵɵtemplate(7, ActionsRenderer_a_7_Template, 3, 0, "a", 6);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(8, ActionsRenderer_li_8_Template, 1, 0, "li", 7);
            i0.ɵɵelementStart(9, "li");
            i0.ɵɵtemplate(10, ActionsRenderer_a_10_Template, 3, 0, "a", 8);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(11, ActionsRenderer_li_11_Template, 1, 0, "li", 7);
            i0.ɵɵelementStart(12, "li");
            i0.ɵɵtemplate(13, ActionsRenderer_a_13_Template, 3, 0, "a", 9);
            i0.ɵɵelementEnd()()()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.UPDATE));
            i0.ɵɵadvance(6);
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.EXECUTE));
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.EXECUTE));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.UPDATE));
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.UPDATE));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.DELETE));
        } }, dependencies: [i5.NgIf, i1.NgbDropdown, i1.NgbDropdownToggle, i1.NgbDropdownMenu, i1.NgbDropdownItem], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ActionsRenderer, [{
        type: Component,
        args: [{ changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"d-flex\">\n    <div *ngIf=\"schedulePermissions.includes(permission.UPDATE)\"><button class=\"btn btn-secondary btn-sm me-2\" id=\"start-stop-schedule\" type=\"button\" title=\"Start Schedule\" (click)=\"startStop(this.cellValue.enabled)\">\n        <i *ngIf=\"!this.cellValue.enabled\" class=\"fa fa-play\"></i>\n        <i *ngIf=\"this.cellValue.enabled\" class=\"fa fa-pause\"></i>\n    </button></div>\n    <div ngbDropdown class=\"margin-right-8px\" container=\"body\">\n        <button ngbDropdownToggle class=\"dropdown-toggle btn btn-secondary btn-sm dropdown-caret-off\" id=\"settings-schedule\" type=\"button\" title=\"Settings Schedule\">\n            <i class=\"fa-solid fa-ellipsis-stroke\"></i>\n        </button>\n        <div ngbDropdownMenu class=\"dropdown-menu mx-0 border-0 shadow\" aria-labelledby=\"scheduleActions\">\n            <li>\n              <a ngbDropdownItem id=\"trigger-schedule-btn\" class=\"cursor-pointer\" (click)=\"triggerNow()\" *ngIf=\"schedulePermissions.includes(permission.EXECUTE)\">\n                  <i class=\"fa fa-bolt margin-right-4px\" aria-hidden=\"false\"></i> Trigger Now\n              </a>\n            </li>\n            <li class=\"dropdown-divider\" *ngIf=\"schedulePermissions.includes(permission.EXECUTE)\"></li>\n            <li>\n              <a ngbDropdownItem id=\"edit-schedule-btn\" class=\"cursor-pointer\" (click)=\"edit()\" *ngIf=\"schedulePermissions.includes(permission.UPDATE)\">\n                  <i class=\"fa fa-pencil margin-right-4px\" aria-hidden=\"false\"></i> Edit\n              </a>\n            </li>\n            <li class=\"dropdown-divider\" *ngIf=\"schedulePermissions.includes(permission.UPDATE)\"></li>\n            <li>\n              <a ngbDropdownItem id=\"delete-schedule-btn\" class=\"cursor-pointer\" (click)=\"deleteSchedule()\" *ngIf=\"schedulePermissions.includes(permission.DELETE)\">\n                <i class=\"fa fa-trash margin-right-4px\" aria-hidden=\"false\"></i> Delete\n              </a>\n            </li>\n        </div>\n    </div>\n\n</div>\n" }]
    }], () => [{ type: i1.NgbOffcanvas }, { type: i0.ChangeDetectorRef }, { type: i2.ScheduleService }, { type: i3.ToastrService }, { type: i2.PermissionService }, { type: i2.ModalService }, { type: i4.TranslocoService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ActionsRenderer, { className: "ActionsRenderer", filePath: "src/schedule-list/cell-renderers/actions/actions.component.ts", lineNumber: 22 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWN0aW9ucy5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc2NoZWR1bGUvc3JjL3NjaGVkdWxlLWxpc3QvY2VsbC1yZW5kZXJlcnMvYWN0aW9ucy9hY3Rpb25zLmNvbXBvbmVudC50cyIsIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zY2hlZHVsZS9zcmMvc2NoZWR1bGUtbGlzdC9jZWxsLXJlbmRlcmVycy9hY3Rpb25zL2FjdGlvbnMuY29tcG9uZW50Lmh0bWwiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7a0JBSWtCO0FBQ2xCLE9BQU8sRUFBRSx1QkFBdUIsRUFBcUIsU0FBUyxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBS3RGLE9BQU8sRUFBTyxZQUFZLEVBQWdCLFVBQVUsRUFBdUQsTUFBTSxRQUFRLENBQUM7QUFDMUgsT0FBTyxFQUFFLHVCQUF1QixFQUFFLE1BQU0sb0RBQW9ELENBQUM7QUFFN0YsT0FBTyxFQUFFLFNBQVMsRUFBRSxFQUFFLEVBQUUsTUFBTSxNQUFNLENBQUM7QUFDckMsT0FBTyxFQUFFLGlCQUFpQixFQUFFLE1BQU0sc0JBQXNCLENBQUM7Ozs7Ozs7O0lDUGpELHdCQUEwRDs7O0lBQzFELHdCQUEwRDs7OztJQUZELEFBQTdELDJCQUE2RCxpQkFBd0o7SUFBNUMsMktBQVMsMENBQWlDLEtBQUM7SUFFaE4sQUFEQSxtRUFBc0Qsc0RBQ0E7SUFDakQsQUFBVCxpQkFBUyxFQUFNOzs7SUFGUCxlQUE2QjtJQUE3QixnREFBNkI7SUFDN0IsY0FBNEI7SUFBNUIsK0NBQTRCOzs7O0lBUTFCLDZCQUFvSjtJQUFoRixvS0FBUyxtQkFBWSxLQUFDO0lBQ3RGLHdCQUErRDtJQUFDLDZCQUNwRTtJQUFBLGlCQUFJOzs7SUFFTix5QkFBMkY7Ozs7SUFFekYsNkJBQTBJO0lBQXpFLHFLQUFTLGFBQU0sS0FBQztJQUM3RSx3QkFBaUU7SUFBQyxzQkFDdEU7SUFBQSxpQkFBSTs7O0lBRU4seUJBQTBGOzs7O0lBRXhGLDZCQUFzSjtJQUFuRixxS0FBUyx1QkFBZ0IsS0FBQztJQUMzRix3QkFBZ0U7SUFBQyx3QkFDbkU7SUFBQSxpQkFBSTs7QURUbEIsTUFBTSxPQUFPLGVBQWU7SUFReEIsWUFDWSxnQkFBOEIsRUFDOUIsaUJBQW9DLEVBQ3BDLGVBQWdDLEVBQ2hDLE9BQXNCLEVBQ3RCLGlCQUFvQyxFQUNwQyxZQUEwQixFQUMxQixnQkFBa0M7UUFObEMscUJBQWdCLEdBQWhCLGdCQUFnQixDQUFjO1FBQzlCLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBbUI7UUFDcEMsb0JBQWUsR0FBZixlQUFlLENBQWlCO1FBQ2hDLFlBQU8sR0FBUCxPQUFPLENBQWU7UUFDdEIsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFtQjtRQUNwQyxpQkFBWSxHQUFaLFlBQVksQ0FBYztRQUMxQixxQkFBZ0IsR0FBaEIsZ0JBQWdCLENBQWtCO1FBWjlDLGlCQUFZLEdBQVksS0FBSyxDQUFDO1FBRzlCLGVBQVUsR0FBRyxVQUFVLENBQUM7UUFXdEIsSUFBSSxDQUFDLG1CQUFtQixHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzFGLENBQUM7SUFFRCwrQ0FBK0M7SUFDL0MsTUFBTSxDQUFDLE1BQTJCO1FBQzlCLElBQUksS0FBSyxHQUFRLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUNoRCxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDNUIsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUM7SUFDeEIsQ0FBQztJQUVELDBDQUEwQztJQUMxQyxPQUFPLENBQUMsTUFBMkI7UUFDL0IsNEJBQTRCO1FBQzVCLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ2hELE9BQU8sSUFBSSxDQUFDO0lBQ2hCLENBQUM7SUFFRCxpQkFBaUIsQ0FBQyxNQUEyQjtRQUN6QyxPQUFPLE1BQU0sQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQztJQUNsRSxDQUFDO0lBRUQsSUFBSTtRQUNBLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLHVCQUF1QixFQUFFO1lBQ2pGLFNBQVMsRUFBRSxJQUFJO1lBQ2YsUUFBUSxFQUFFLEtBQUs7WUFDZixVQUFVLEVBQUUsMENBQTBDO1lBQ3RELE1BQU0sRUFBRSxLQUFLO1lBQ2IsUUFBUSxFQUFFLEtBQUs7U0FDaEIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLHlCQUF5QixDQUFDLGlCQUFpQixDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUM7UUFDdEUsSUFBSSxDQUFDLHlCQUF5QixDQUFDLGlCQUFpQixDQUFDLElBQUksR0FBRyxNQUFNLENBQUM7UUFDL0QsSUFBSSxDQUFDLHlCQUF5QixDQUFDLGlCQUFpQixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7UUFFdkgsSUFBSSxDQUFDLHlCQUF5QixDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsQ0FBQyxNQUFXLEVBQUUsRUFBRTtZQUM5RCxJQUFJLE1BQU0sRUFBRSxDQUFDO2dCQUNULElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7WUFDdkMsQ0FBQztRQUNILENBQUMsQ0FBQyxDQUFDO0lBQ1QsQ0FBQztJQUVELGNBQWM7UUFDZCxJQUFJLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxDQUFDLHlDQUF5QyxFQUFFO1lBQ2pHLFlBQVksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUk7U0FDaEMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUNSLFNBQVMsQ0FBQyxDQUFDLE1BQWUsRUFBRSxFQUFFO1lBQzFCLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDVixPQUFPLEVBQUUsRUFBRSxDQUFDO1lBQ2hCLENBQUM7WUFDRCxPQUFPLElBQUksQ0FBQyxlQUFlLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsRUFBRSxDQUFDLENBQUE7UUFDekQsQ0FBQyxDQUFDLENBQ0QsQ0FBQyxTQUFTLENBQUM7WUFDUixJQUFJLEVBQUUsR0FBRyxFQUFFO2dCQUNQLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsb0NBQW9DLEVBQUU7b0JBQ3ZGLFlBQVksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUk7aUJBQ3BDLENBQUMsRUFBRSxTQUFTLENBQUMsQ0FBQztnQkFDZixJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO1lBQ3ZDLENBQUMsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUE4QixFQUFDLEVBQUU7Z0JBQ3hDLElBQUcsQ0FBQyxZQUFZLGlCQUFpQixFQUFFLENBQUM7b0JBQ2hDLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsa0NBQWtDLEVBQUU7d0JBQ25GLFlBQVksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUk7cUJBQ3BDLENBQUMsRUFBRSxPQUFPLENBQUMsQ0FBQztnQkFDakIsQ0FBQztZQUNMLENBQUM7U0FDSixDQUFDLENBQUM7SUFDUCxDQUFDO0lBRUQsVUFBVTtRQUNOLElBQUksQ0FBQyxlQUFlLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsRUFBRSxDQUFDLENBQUMsU0FBUyxDQUFDO1lBQ3RELElBQUksRUFBRSxDQUFDLEdBQUcsRUFBRTtnQkFDUixJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxvQkFBb0IsRUFBRSxTQUFTLENBQUMsQ0FBQztZQUMxRCxDQUFDLENBQUMsRUFBRSxLQUFLLEVBQUUsQ0FBQyxHQUFHLEVBQUU7Z0JBQ2IsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMseUJBQXlCLEVBQUUsT0FBTyxDQUFDLENBQUM7WUFDM0QsQ0FBQyxDQUFDO1NBQ0wsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztJQUVELFlBQVk7UUFDUixJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQztJQUM3QixDQUFDO0lBRUQsU0FBUyxDQUFDLGFBQXNCO1FBQzVCLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxHQUFHLENBQUMsYUFBYSxDQUFDO1FBQ3hDLElBQUksQ0FBQyxlQUFlLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFxQixDQUFDLENBQUMsU0FBUyxDQUFDLEdBQUcsRUFBRTtZQUNuRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7UUFDM0MsQ0FBQyxDQUFDLENBQUE7SUFDTixDQUFDO2dIQXRHUSxlQUFlO29FQUFmLGVBQWU7WUNoQjVCLDhCQUFvQjtZQUNoQixnRUFBNkQ7WUFLekQsQUFESiw4QkFBMkQsZ0JBQ3NHO1lBQ3pKLHVCQUEyQztZQUMvQyxpQkFBUztZQUVMLEFBREosOEJBQWtHLFNBQzFGO1lBQ0YsNERBQW9KO1lBR3RKLGlCQUFLO1lBQ0wsOERBQXNGO1lBQ3RGLDBCQUFJO1lBQ0YsOERBQTBJO1lBRzVJLGlCQUFLO1lBQ0wsZ0VBQXFGO1lBQ3JGLDJCQUFJO1lBQ0YsOERBQXNKO1lBT3BLLEFBRkksQUFESSxBQURJLGlCQUFLLEVBQ0gsRUFDSixFQUVKOztZQTdCSSxjQUFxRDtZQUFyRCw4RUFBcUQ7WUFVMkMsZUFBc0Q7WUFBdEQsK0VBQXNEO1lBSXRILGNBQXNEO1lBQXRELCtFQUFzRDtZQUVDLGVBQXFEO1lBQXJELDhFQUFxRDtZQUk1RyxjQUFxRDtZQUFyRCw4RUFBcUQ7WUFFYyxlQUFxRDtZQUFyRCw4RUFBcUQ7OztpRkRQckosZUFBZTtjQUwzQixTQUFTO2tDQUdXLHVCQUF1QixDQUFDLE1BQU07O2tGQUV0QyxlQUFlIiwic291cmNlc0NvbnRlbnQiOlsiLyogQ29weXJpZ2h0IHN0YXJ0XG4gIENvcHlyaWdodCAoQykgMjAwOCAtIDIwMjUgRm9ydGluZXQgSW5jLlxuICBBbGwgcmlnaHRzIHJlc2VydmVkLlxuICBGT1JUSU5FVCBDT05GSURFTlRJQUwgJiBGT1JUSU5FVCBQUk9QUklFVEFSWSBTT1VSQ0UgQ09ERVxuICBDb3B5cmlnaHQgZW5kICovXG5pbXBvcnQgeyBDaGFuZ2VEZXRlY3Rpb25TdHJhdGVneSwgQ2hhbmdlRGV0ZWN0b3JSZWYsIENvbXBvbmVudCB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XG5pbXBvcnQgeyBOZ2JPZmZjYW52YXMsIE5nYk9mZmNhbnZhc1JlZiB9IGZyb20gXCJAbmctYm9vdHN0cmFwL25nLWJvb3RzdHJhcFwiO1xuaW1wb3J0IHsgSUNlbGxSZW5kZXJlckFuZ3VsYXJDb21wIH0gZnJvbSAnYWctZ3JpZC1hbmd1bGFyJztcbmltcG9ydCB7IElDZWxsUmVuZGVyZXJQYXJhbXMgfSBmcm9tIFwiYWctZ3JpZC1jb21tdW5pdHlcIjtcbmltcG9ydCB7IFRvYXN0clNlcnZpY2UgfSBmcm9tIFwibmd4LXRvYXN0clwiO1xuaW1wb3J0IHsgQVBJLCBGSVhFRF9NT0RVTEUsIE1vZGFsU2VydmljZSwgUEVSTUlTU0lPTiwgUGVybWlzc2lvblNlcnZpY2UsIFF1ZXJ5LCBTY2hlZHVsZSwgU2NoZWR1bGVTZXJ2aWNlIH0gZnJvbSBcInNoYXJlZFwiO1xuaW1wb3J0IHsgU2NoZWR1bGVEZXRhaWxDb21wb25lbnQgfSBmcm9tIFwiLi4vLi4vLi4vc2NoZWR1bGUtZGV0YWlsL3NjaGVkdWxlLWRldGFpbC5jb21wb25lbnRcIjtcbmltcG9ydCB7IFRyYW5zbG9jb1NlcnZpY2UgfSBmcm9tICdAanN2ZXJzZS90cmFuc2xvY28nO1xuaW1wb3J0IHsgY29uY2F0TWFwLCBvZiB9IGZyb20gXCJyeGpzXCI7XG5pbXBvcnQgeyBIdHRwRXJyb3JSZXNwb25zZSB9IGZyb20gXCJAYW5ndWxhci9jb21tb24vaHR0cFwiO1xuXG5AQ29tcG9uZW50KHtcbiAgICB0ZW1wbGF0ZVVybDogJy4vYWN0aW9ucy5jb21wb25lbnQuaHRtbCcsXG4gICAgc3R5bGVVcmxzOiBbJy4vYWN0aW9ucy5jb21wb25lbnQuc2NzcyddLFxuICAgIGNoYW5nZURldGVjdGlvbjogQ2hhbmdlRGV0ZWN0aW9uU3RyYXRlZ3kuT25QdXNoLFxufSlcbmV4cG9ydCBjbGFzcyBBY3Rpb25zUmVuZGVyZXIgaW1wbGVtZW50cyBJQ2VsbFJlbmRlcmVyQW5ndWxhckNvbXAge1xuICAgIHB1YmxpYyBjZWxsVmFsdWUhOiBhbnk7XG4gICAgb2ZmY2FudmFzSW5zdGFuY2VTY2hlZHVsZT86IE5nYk9mZmNhbnZhc1JlZjtcbiAgICBzaG93RHJvcGRvd246IGJvb2xlYW4gPSBmYWxzZTtcbiAgICBwYXJhbSE6IElDZWxsUmVuZGVyZXJQYXJhbXM7XG4gICAgc2NoZWR1bGVQZXJtaXNzaW9uczogc3RyaW5nW107XG4gICAgcGVybWlzc2lvbiA9IFBFUk1JU1NJT047XG5cbiAgICBjb25zdHJ1Y3RvcihcbiAgICAgICAgcHJpdmF0ZSBvZmZjYW52YXNTZXJ2aWNlOiBOZ2JPZmZjYW52YXMsXG4gICAgICAgIHByaXZhdGUgY2hhbmdlRGV0ZWN0b3JSZWY6IENoYW5nZURldGVjdG9yUmVmLFxuICAgICAgICBwcml2YXRlIHNjaGVkdWxlU2VydmljZTogU2NoZWR1bGVTZXJ2aWNlLFxuICAgICAgICBwcml2YXRlIHRvYXN0ZXI6IFRvYXN0clNlcnZpY2UsXG4gICAgICAgIHByaXZhdGUgcGVybWlzc2lvblNlcnZpY2U6IFBlcm1pc3Npb25TZXJ2aWNlLFxuICAgICAgICBwcml2YXRlIG1vZGFsU2VydmljZTogTW9kYWxTZXJ2aWNlLFxuICAgICAgICBwcml2YXRlIHRyYW5zbG9jb1NlcnZpY2U6IFRyYW5zbG9jb1NlcnZpY2UsXG4gICAgKSB7XG4gICAgICB0aGlzLnNjaGVkdWxlUGVybWlzc2lvbnMgPSB0aGlzLnBlcm1pc3Npb25TZXJ2aWNlLmdldFBlcm1pc3Npb24oRklYRURfTU9EVUxFLlNDSEVEVUxFUyk7XG4gICAgfVxuXG4gICAgLy8gZ2V0cyBjYWxsZWQgb25jZSBiZWZvcmUgdGhlIHJlbmRlcmVyIGlzIHVzZWRcbiAgICBhZ0luaXQocGFyYW1zOiBJQ2VsbFJlbmRlcmVyUGFyYW1zKTogdm9pZCB7XG4gICAgICAgIGxldCB2YWx1ZTogYW55ID0gdGhpcy5nZXRWYWx1ZVRvRGlzcGxheShwYXJhbXMpO1xuICAgICAgICB0aGlzLmNlbGxWYWx1ZSA9IHZhbHVlLmRhdGE7XG4gICAgICAgIHRoaXMucGFyYW0gPSBwYXJhbXM7XG4gICAgfVxuXG4gICAgLy8gZ2V0cyBjYWxsZWQgd2hlbmV2ZXIgdGhlIGNlbGwgcmVmcmVzaGVzXG4gICAgcmVmcmVzaChwYXJhbXM6IElDZWxsUmVuZGVyZXJQYXJhbXMpOiBib29sZWFuIHtcbiAgICAgICAgLy8gc2V0IHZhbHVlIGludG8gY2VsbCBhZ2FpblxuICAgICAgICB0aGlzLmNlbGxWYWx1ZSA9IHRoaXMuZ2V0VmFsdWVUb0Rpc3BsYXkocGFyYW1zKTtcbiAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgfVxuXG4gICAgZ2V0VmFsdWVUb0Rpc3BsYXkocGFyYW1zOiBJQ2VsbFJlbmRlcmVyUGFyYW1zKSA6IGFueSB7XG4gICAgICAgIHJldHVybiBwYXJhbXMudmFsdWVGb3JtYXR0ZWQgPyBwYXJhbXMudmFsdWVGb3JtYXR0ZWQgOiBwYXJhbXM7XG4gICAgfVxuXG4gICAgZWRpdCgpe1xuICAgICAgICB0aGlzLm9mZmNhbnZhc0luc3RhbmNlU2NoZWR1bGUgPSB0aGlzLm9mZmNhbnZhc1NlcnZpY2Uub3BlbihTY2hlZHVsZURldGFpbENvbXBvbmVudCwge1xuICAgICAgICAgICAgYW5pbWF0aW9uOiB0cnVlLFxuICAgICAgICAgICAgcG9zaXRpb246ICdlbmQnLFxuICAgICAgICAgICAgcGFuZWxDbGFzczogJ3NjaGVkdWxlLWxpc3QtbW9kYWwgb2ZmY2FudmFzLXNsaWRlLWxlZnQnLFxuICAgICAgICAgICAgc2Nyb2xsOiBmYWxzZSxcbiAgICAgICAgICAgIGJhY2tkcm9wOiBmYWxzZVxuICAgICAgICAgIH0pO1xuICAgICAgICAgIHRoaXMub2ZmY2FudmFzSW5zdGFuY2VTY2hlZHVsZS5jb21wb25lbnRJbnN0YW5jZS5zaG93UmVmZXJlbmNlID0gdHJ1ZTtcbiAgICAgICAgICB0aGlzLm9mZmNhbnZhc0luc3RhbmNlU2NoZWR1bGUuY29tcG9uZW50SW5zdGFuY2UubW9kZSA9ICdlZGl0JztcbiAgICAgICAgICB0aGlzLm9mZmNhbnZhc0luc3RhbmNlU2NoZWR1bGUuY29tcG9uZW50SW5zdGFuY2Uuc2NoZWR1bGUgPSB0aGlzLmNlbGxWYWx1ZS5kYXRhID8gdGhpcy5jZWxsVmFsdWUuZGF0YSA6IHRoaXMuY2VsbFZhbHVlO1xuXG4gICAgICAgICAgdGhpcy5vZmZjYW52YXNJbnN0YW5jZVNjaGVkdWxlLmNsb3NlZC5zdWJzY3JpYmUoKHJlc3VsdDogYW55KSA9PiB7XG4gICAgICAgICAgICBpZiAocmVzdWx0KSB7XG4gICAgICAgICAgICAgICAgdGhpcy5wYXJhbS5hcGkucmVmcmVzaFNlcnZlclNpZGUoKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9KTtcbiAgICB9XG5cbiAgICBkZWxldGVTY2hlZHVsZSgpIHtcbiAgICB0aGlzLm1vZGFsU2VydmljZS5jb25maXJtKHRoaXMudHJhbnNsb2NvU2VydmljZS50cmFuc2xhdGUoJ2NvbXBvbmVudHMuc2NoZWR1bGUuZGVsZXRlX2NvbmZpcm1hdGlvbicsIHtcbiAgICAgICAgc2NoZWR1bGVOYW1lOiB0aGlzLmNlbGxWYWx1ZS5uYW1lXG4gICAgICAgIH0pKS5waXBlKFxuICAgICAgICBjb25jYXRNYXAoKHJlc3VsdDogYm9vbGVhbikgPT4ge1xuICAgICAgICAgICAgaWYgKCFyZXN1bHQpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gb2YoKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiB0aGlzLnNjaGVkdWxlU2VydmljZS5kZWxldGUodGhpcy5jZWxsVmFsdWUuaWQpXG4gICAgICAgIH0pXG4gICAgICAgICkuc3Vic2NyaWJlKHtcbiAgICAgICAgICAgIG5leHQ6ICgpID0+IHtcbiAgICAgICAgICAgICAgICB0aGlzLnRvYXN0ZXIuc3VjY2Vzcyh0aGlzLnRyYW5zbG9jb1NlcnZpY2UudHJhbnNsYXRlKCdjb21wb25lbnRzLnNjaGVkdWxlLmRlbGV0ZV9zdWNjZXNzJywge1xuICAgICAgICAgICAgICAgICAgICBzY2hlZHVsZU5hbWU6IHRoaXMuY2VsbFZhbHVlLm5hbWVcbiAgICAgICAgICAgICAgICB9KSwgJ1N1Y2Nlc3MnKTtcbiAgICAgICAgICAgICAgICB0aGlzLnBhcmFtLmFwaS5yZWZyZXNoU2VydmVyU2lkZSgpO1xuICAgICAgICAgICAgfSwgZXJyb3I6IChlOiBIdHRwRXJyb3JSZXNwb25zZSB8IGJvb2xlYW4pPT4ge1xuICAgICAgICAgICAgICAgIGlmKGUgaW5zdGFuY2VvZiBIdHRwRXJyb3JSZXNwb25zZSkge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnRvYXN0ZXIuZXJyb3IodGhpcy50cmFuc2xvY29TZXJ2aWNlLnRyYW5zbGF0ZSgnY29tcG9uZW50cy5zY2hlZHVsZS5kZWxldGVfZXJyb3InLCB7XG4gICAgICAgICAgICAgICAgICAgICAgICBzY2hlZHVsZU5hbWU6IHRoaXMuY2VsbFZhbHVlLm5hbWVcbiAgICAgICAgICAgICAgICAgICAgfSksICdFcnJvcicpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgfVxuXG4gICAgdHJpZ2dlck5vdygpIHtcbiAgICAgICAgdGhpcy5zY2hlZHVsZVNlcnZpY2UudHJpZ2dlcih0aGlzLmNlbGxWYWx1ZS5pZCkuc3Vic2NyaWJlKHtcbiAgICAgICAgICAgIG5leHQ6ICgoKSA9PiB7XG4gICAgICAgICAgICAgICAgdGhpcy50b2FzdGVyLnN1Y2Nlc3MoJ1NjaGVkdWxlIFRyaWdnZXJlZCcsICdTdWNjZXNzJyk7XG4gICAgICAgICAgICB9KSwgZXJyb3I6ICgoKSA9PiB7XG4gICAgICAgICAgICAgICAgdGhpcy50b2FzdGVyLmVycm9yKCdTY2hlZHVsZSBUcmlnZ2VyIEZhaWxlZCcsICdFcnJvcicpO1xuICAgICAgICAgICAgfSlcbiAgICAgICAgfSk7XG4gICAgfVxuXG4gICAgc2hvd0Ryb3BEb3duKCkge1xuICAgICAgICB0aGlzLnNob3dEcm9wZG93biA9IHRydWU7XG4gICAgfVxuXG4gICAgc3RhcnRTdG9wKHN0YXJ0U2NoZWR1bGU6IGJvb2xlYW4pIHtcbiAgICAgICAgdGhpcy5jZWxsVmFsdWUuZW5hYmxlZCA9ICFzdGFydFNjaGVkdWxlO1xuICAgICAgICB0aGlzLnNjaGVkdWxlU2VydmljZS51cGRhdGUodGhpcy5jZWxsVmFsdWUgYXMgU2NoZWR1bGUpLnN1YnNjcmliZSgoKSA9PiB7XG4gICAgICAgICAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgICAgICAgfSlcbiAgICB9XG59XG4iLCI8IS0tIENvcHlyaWdodCBzdGFydFxuICBDb3B5cmlnaHQgKEMpIDIwMDggLSAyMDI1IEZvcnRpbmV0IEluYy5cbiAgQWxsIHJpZ2h0cyByZXNlcnZlZC5cbiAgRk9SVElORVQgQ09ORklERU5USUFMICYgRk9SVElORVQgUFJPUFJJRVRBUlkgU09VUkNFIENPREVcbiAgQ29weXJpZ2h0IGVuZCAtLT5cbjxkaXYgY2xhc3M9XCJkLWZsZXhcIj5cbiAgICA8ZGl2ICpuZ0lmPVwic2NoZWR1bGVQZXJtaXNzaW9ucy5pbmNsdWRlcyhwZXJtaXNzaW9uLlVQREFURSlcIj48YnV0dG9uIGNsYXNzPVwiYnRuIGJ0bi1zZWNvbmRhcnkgYnRuLXNtIG1lLTJcIiBpZD1cInN0YXJ0LXN0b3Atc2NoZWR1bGVcIiB0eXBlPVwiYnV0dG9uXCIgdGl0bGU9XCJTdGFydCBTY2hlZHVsZVwiIChjbGljayk9XCJzdGFydFN0b3AodGhpcy5jZWxsVmFsdWUuZW5hYmxlZClcIj5cbiAgICAgICAgPGkgKm5nSWY9XCIhdGhpcy5jZWxsVmFsdWUuZW5hYmxlZFwiIGNsYXNzPVwiZmEgZmEtcGxheVwiPjwvaT5cbiAgICAgICAgPGkgKm5nSWY9XCJ0aGlzLmNlbGxWYWx1ZS5lbmFibGVkXCIgY2xhc3M9XCJmYSBmYS1wYXVzZVwiPjwvaT5cbiAgICA8L2J1dHRvbj48L2Rpdj5cbiAgICA8ZGl2IG5nYkRyb3Bkb3duIGNsYXNzPVwibWFyZ2luLXJpZ2h0LThweFwiIGNvbnRhaW5lcj1cImJvZHlcIj5cbiAgICAgICAgPGJ1dHRvbiBuZ2JEcm9wZG93blRvZ2dsZSBjbGFzcz1cImRyb3Bkb3duLXRvZ2dsZSBidG4gYnRuLXNlY29uZGFyeSBidG4tc20gZHJvcGRvd24tY2FyZXQtb2ZmXCIgaWQ9XCJzZXR0aW5ncy1zY2hlZHVsZVwiIHR5cGU9XCJidXR0b25cIiB0aXRsZT1cIlNldHRpbmdzIFNjaGVkdWxlXCI+XG4gICAgICAgICAgICA8aSBjbGFzcz1cImZhLXNvbGlkIGZhLWVsbGlwc2lzLXN0cm9rZVwiPjwvaT5cbiAgICAgICAgPC9idXR0b24+XG4gICAgICAgIDxkaXYgbmdiRHJvcGRvd25NZW51IGNsYXNzPVwiZHJvcGRvd24tbWVudSBteC0wIGJvcmRlci0wIHNoYWRvd1wiIGFyaWEtbGFiZWxsZWRieT1cInNjaGVkdWxlQWN0aW9uc1wiPlxuICAgICAgICAgICAgPGxpPlxuICAgICAgICAgICAgICA8YSBuZ2JEcm9wZG93bkl0ZW0gaWQ9XCJ0cmlnZ2VyLXNjaGVkdWxlLWJ0blwiIGNsYXNzPVwiY3Vyc29yLXBvaW50ZXJcIiAoY2xpY2spPVwidHJpZ2dlck5vdygpXCIgKm5nSWY9XCJzY2hlZHVsZVBlcm1pc3Npb25zLmluY2x1ZGVzKHBlcm1pc3Npb24uRVhFQ1VURSlcIj5cbiAgICAgICAgICAgICAgICAgIDxpIGNsYXNzPVwiZmEgZmEtYm9sdCBtYXJnaW4tcmlnaHQtNHB4XCIgYXJpYS1oaWRkZW49XCJmYWxzZVwiPjwvaT4gVHJpZ2dlciBOb3dcbiAgICAgICAgICAgICAgPC9hPlxuICAgICAgICAgICAgPC9saT5cbiAgICAgICAgICAgIDxsaSBjbGFzcz1cImRyb3Bkb3duLWRpdmlkZXJcIiAqbmdJZj1cInNjaGVkdWxlUGVybWlzc2lvbnMuaW5jbHVkZXMocGVybWlzc2lvbi5FWEVDVVRFKVwiPjwvbGk+XG4gICAgICAgICAgICA8bGk+XG4gICAgICAgICAgICAgIDxhIG5nYkRyb3Bkb3duSXRlbSBpZD1cImVkaXQtc2NoZWR1bGUtYnRuXCIgY2xhc3M9XCJjdXJzb3ItcG9pbnRlclwiIChjbGljayk9XCJlZGl0KClcIiAqbmdJZj1cInNjaGVkdWxlUGVybWlzc2lvbnMuaW5jbHVkZXMocGVybWlzc2lvbi5VUERBVEUpXCI+XG4gICAgICAgICAgICAgICAgICA8aSBjbGFzcz1cImZhIGZhLXBlbmNpbCBtYXJnaW4tcmlnaHQtNHB4XCIgYXJpYS1oaWRkZW49XCJmYWxzZVwiPjwvaT4gRWRpdFxuICAgICAgICAgICAgICA8L2E+XG4gICAgICAgICAgICA8L2xpPlxuICAgICAgICAgICAgPGxpIGNsYXNzPVwiZHJvcGRvd24tZGl2aWRlclwiICpuZ0lmPVwic2NoZWR1bGVQZXJtaXNzaW9ucy5pbmNsdWRlcyhwZXJtaXNzaW9uLlVQREFURSlcIj48L2xpPlxuICAgICAgICAgICAgPGxpPlxuICAgICAgICAgICAgICA8YSBuZ2JEcm9wZG93bkl0ZW0gaWQ9XCJkZWxldGUtc2NoZWR1bGUtYnRuXCIgY2xhc3M9XCJjdXJzb3ItcG9pbnRlclwiIChjbGljayk9XCJkZWxldGVTY2hlZHVsZSgpXCIgKm5nSWY9XCJzY2hlZHVsZVBlcm1pc3Npb25zLmluY2x1ZGVzKHBlcm1pc3Npb24uREVMRVRFKVwiPlxuICAgICAgICAgICAgICAgIDxpIGNsYXNzPVwiZmEgZmEtdHJhc2ggbWFyZ2luLXJpZ2h0LTRweFwiIGFyaWEtaGlkZGVuPVwiZmFsc2VcIj48L2k+IERlbGV0ZVxuICAgICAgICAgICAgICA8L2E+XG4gICAgICAgICAgICA8L2xpPlxuICAgICAgICA8L2Rpdj5cbiAgICA8L2Rpdj5cblxuPC9kaXY+XG4iXX0=