/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, Input } from '@angular/core';
import { cloneDeep } from 'lodash-es';
import { FIXED_MODULE, PERMISSION, Schedule, Query, Filter } from 'shared';
import { concatMap, forkJoin, of } from 'rxjs';
import { ScheduleDetailComponent } from '../schedule-detail/schedule-detail.component';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "shared/grid";
import * as i3 from "@jsverse/transloco";
import * as i4 from "ngx-toastr";
import * as i5 from "@ng-bootstrap/ng-bootstrap";
import * as i6 from "@angular/common";
function ScheduleListComponent_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 6)(1, "button", 7);
    i0.ɵɵlistener("click", function ScheduleListComponent_div_7_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.createSchedule()); });
    i0.ɵɵelement(2, "i", 8);
    i0.ɵɵtext(3, "Create Schedule ");
    i0.ɵɵelementEnd()();
} }
export class ScheduleListComponent {
    constructor(entityService, gridDataSourceService, modalService, apiService, translocoService, toasterService, offcanvasService, permissionService, licenseService) {
        this.entityService = entityService;
        this.gridDataSourceService = gridDataSourceService;
        this.modalService = modalService;
        this.apiService = apiService;
        this.translocoService = translocoService;
        this.toasterService = toasterService;
        this.offcanvasService = offcanvasService;
        this.permissionService = permissionService;
        this.licenseService = licenseService;
        this.processing = false;
        this.selectedRows = [];
        this.permission = PERMISSION;
        this.defaultCron = {
            "minute": "*/5",
            "hour": "*",
            "day_of_week": "*",
            "day_of_month": "*",
            "month_of_year": "*",
            "timezone": "UTC"
        };
        this.schedulePermissions = this.permissionService.getPermission(FIXED_MODULE.SCHEDULES);
        this.licenseService.getLicenseDetails().subscribe((result) => {
            this.defaultCron.minute = `*/${result.info.polling_frequency}`;
        });
    }
    ngOnInit() {
        this.entityService.build(FIXED_MODULE.SCHEDULES).subscribe((entity) => {
            this.scheduleEntity = cloneDeep(entity);
            const query = new Query();
            query.filters.push(new Filter('task', 'eq', 'workflow.tasks.periodic_task'));
            this.dataSource = this.gridDataSourceService.getDataSource(entity, query);
        });
        this.gridConfig.options.onRegisterApi = (gridApi) => {
            this.gridApi = gridApi;
        };
        if (!this.gridConfig.options?.allowDelete) {
            this.setBulkDeleteConfig();
        }
    }
    createSchedule() {
        let schedule = new Schedule('');
        schedule.kwargs = {
            inputParameters: { query: { qparam: {} } }
        };
        schedule.crontab = this.defaultCron;
        this.offcanvasInstanceSchedule = this.offcanvasService.open(ScheduleDetailComponent, {
            animation: true,
            position: 'end',
            panelClass: 'schedule-list-modal offcanvas-slide-left',
            scroll: false,
            backdrop: false
        });
        this.offcanvasInstanceSchedule.componentInstance.showReference = true;
        this.offcanvasInstanceSchedule.componentInstance.mode = 'new'; //TODO: Do we really need mode?
        this.offcanvasInstanceSchedule.componentInstance.schedule = schedule;
        this.offcanvasInstanceSchedule.closed.subscribe((result) => {
            if (result) {
                this.gridApi?.refreshServerSide();
            }
        });
    }
    setBulkDeleteConfig() {
        this.gridConfig.options?.onRegisterApi;
        this.gridConfig.options.selectButtons = [{
                id: 'btn-delete-playbook',
                tooltip: 'Delete Playbook',
                onClick: () => {
                    this.deleteSelected();
                },
                class: 'btn-secondary margin-right-4px',
                iconClass: 'fa fa-trash fa-light',
                visible: this.schedulePermissions.includes(PERMISSION.DELETE)
            }];
    }
    rowSelectionChanged(event) {
        this.selectedRows = event;
    }
    deleteSelected() {
        this.modalService.confirm(this.translocoService.translate('components.grid.deleteMessage', {
            length: this.selectedRows.length,
            entityName: 'Schedule(s)'
        })).pipe(concatMap((result) => {
            if (!result) {
                return of();
            }
            let uuids = this.selectedRows.map((row) => row.id);
            let observables$ = [];
            uuids.forEach((uuid) => {
                observables$.push(this.apiService.deleteRecord(this.dataSource.entity, uuid));
            });
            return forkJoin(observables$);
        })).subscribe(() => {
            this.toasterService.success(this.translocoService.translate('components.grid.deletedToast', {
                length: this.selectedRows.length,
                entityName: 'Schedule(s)'
            }), 'Success');
            this.gridApi.deselectAll();
            this.selectedRows = [];
            this.gridApi.refreshServerSide();
        });
    }
    static { this.ɵfac = function ScheduleListComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScheduleListComponent)(i0.ɵɵdirectiveInject(i1.EntityService), i0.ɵɵdirectiveInject(i2.GridDataSourceService), i0.ɵɵdirectiveInject(i1.ModalService), i0.ɵɵdirectiveInject(i1.ApiService), i0.ɵɵdirectiveInject(i3.TranslocoService), i0.ɵɵdirectiveInject(i4.ToastrService), i0.ɵɵdirectiveInject(i5.NgbOffcanvas), i0.ɵɵdirectiveInject(i1.PermissionService), i0.ɵɵdirectiveInject(i1.LicenseService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ScheduleListComponent, selectors: [["xf-schedule-list"]], inputs: { gridConfig: "gridConfig", customColumnDefs: "customColumnDefs" }, decls: 10, vars: 5, consts: [[1, "align-items-center", "schedule-list-header", "d-flex", "justify-content-between", "padding-bottom-12px", "padding-left-16px", "padding-right-16px", "padding-top-12px", "ms-3", "me-3"], [1, "page-header-font", "margin-bottom-4px"], [1, "page-subheader-font"], ["class", "d-flex", 4, "ngIf"], [1, "m-3"], [3, "rowSelectionChanged", "dataSource", "gridConfig", "customColumnDefs", "suppressContextMenu"], [1, "d-flex"], ["id", "create-schedule-btn", "type", "button", "title", "Create Schedule", 1, "btn", "btn-sm", "btn-primary", "margin-right-8px", 3, "click"], ["aria-hidden", "true", 1, "fa", "fa-add", "margin-right-4px"]], template: function ScheduleListComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div")(1, "div", 0)(2, "div")(3, "h3", 1);
            i0.ɵɵtext(4, "Schedules");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "h5", 2);
            i0.ɵɵtext(6, "Utilize the Schedules module to set up and manage schedules for running playbooks at regular intervals");
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(7, ScheduleListComponent_div_7_Template, 4, 0, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 4)(9, "xf-grid", 5);
            i0.ɵɵlistener("rowSelectionChanged", function ScheduleListComponent_Template_xf_grid_rowSelectionChanged_9_listener($event) { return ctx.rowSelectionChanged($event); });
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵadvance(7);
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.CREATE));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("dataSource", ctx.dataSource)("gridConfig", ctx.gridConfig)("customColumnDefs", ctx.customColumnDefs)("suppressContextMenu", true);
        } }, dependencies: [i6.NgIf, i2.GridComponent], styles: [".schedule-list-header[_ngcontent-%COMP%]{background:var(--element-default-bg-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScheduleListComponent, [{
        type: Component,
        args: [{ selector: 'xf-schedule-list', changeDetection: ChangeDetectionStrategy.Default, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div>\n    <div\n        class=\"align-items-center schedule-list-header d-flex justify-content-between padding-bottom-12px padding-left-16px padding-right-16px padding-top-12px ms-3 me-3\">\n        <div>\n            <h3 class=\"page-header-font margin-bottom-4px\">Schedules</h3>\n            <h5 class=\"page-subheader-font\">Utilize the Schedules module to set up and manage schedules for running playbooks at regular intervals</h5>\n        </div>\n        <!-- <input type=\"text\" class=\"ms-auto margin-right-8px w-350px form-control form-control-sm\" name=\"search-schedule\"\n            id=\"search-schedule\" placeholder=\"Search by Name, Tags, Commands etc\" /> -->\n        <div class=\"d-flex\" *ngIf=\"schedulePermissions.includes(permission.CREATE)\">\n            <button class=\"btn btn-sm btn-primary margin-right-8px\" id=\"create-schedule-btn\" type=\"button\"\n                (click)=\"createSchedule()\" title=\"Create Schedule\">\n                <i class=\"fa fa-add margin-right-4px\" aria-hidden=\"true\"></i>Create Schedule\n            </button>\n        </div>\n    </div>\n    <div class=\"m-3\">\n        <xf-grid [dataSource]=\"dataSource\" [gridConfig]=\"gridConfig\" [customColumnDefs]=\"customColumnDefs\"\n    [suppressContextMenu]=\"true\" (rowSelectionChanged)=\"rowSelectionChanged($event)\"></xf-grid>\n    </div>\n</div>\n", styles: [".schedule-list-header{background:var(--element-default-bg-color)}\n"] }]
    }], () => [{ type: i1.EntityService }, { type: i2.GridDataSourceService }, { type: i1.ModalService }, { type: i1.ApiService }, { type: i3.TranslocoService }, { type: i4.ToastrService }, { type: i5.NgbOffcanvas }, { type: i1.PermissionService }, { type: i1.LicenseService }], { gridConfig: [{
            type: Input
        }], customColumnDefs: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ScheduleListComponent, { className: "ScheduleListComponent", filePath: "src/schedule-list/schedule-list.component.ts", lineNumber: 25 }); })();
//# sourceMappingURL=data:application/json;base64,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