import { v4 as uuidv4 } from 'uuid';
import { WidgetConfig } from "./widget-config";
export class ViewLayoutItem {
    constructor(type) {
        this.type = type;
        this.id = uuidv4();
    }
}
(function (ViewLayoutItem) {
    class Container extends ViewLayoutItem {
        constructor(contents) {
            super(Types.CONTAINER);
            this.contents = contents;
        }
    }
    ViewLayoutItem.Container = Container;
    class Tabs extends ViewLayoutItem {
        constructor(contents) {
            super(Types.TABS);
            this.contents = contents;
        }
    }
    ViewLayoutItem.Tabs = Tabs;
    class Tab extends ViewLayoutItem {
        constructor(name, contents) {
            super(Types.TAB);
            this.name = name;
            this.contents = contents;
        }
    }
    ViewLayoutItem.Tab = Tab;
    class Widget extends ViewLayoutItem {
        constructor(config) {
            super(Types.WIDGET);
            this.config = config;
            this.count = 0;
            if (this.config instanceof WidgetConfig) {
                this.rows = this.config.defaultHeight;
            }
        }
    }
    ViewLayoutItem.Widget = Widget;
    let Types;
    (function (Types) {
        Types["WIDGET"] = "widget";
        Types["TABS"] = "tabs";
        Types["TAB"] = "tab";
        Types["CONTAINER"] = "container";
    })(Types = ViewLayoutItem.Types || (ViewLayoutItem.Types = {}));
})(ViewLayoutItem || (ViewLayoutItem = {}));
//# sourceMappingURL=data:application/json;base64,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