/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, Input, ViewChild } from '@angular/core';
import { TextField } from "shared";
import { ViewContainerDirective } from 'shared';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "../../widgets/widget.service";
import * as i3 from "@angular/forms";
import * as i4 from "shared";
const _c0 = ["title"];
function AddWidgetComponent_ng_template_10_Template(rf, ctx) { }
export class AddWidgetComponent {
    constructor(activeModal, changeDetectorRef, widgetService, formBuilder, entityService) {
        this.activeModal = activeModal;
        this.changeDetectorRef = changeDetectorRef;
        this.widgetService = widgetService;
        this.entityService = entityService;
        this.titleField = new TextField('widget-title');
        this.titleField.validation.required = true;
        this.titleField.descriptions = {
            singular: 'Title'
        };
        this.widgetFormGroup = formBuilder.group({
            title: ['']
        });
    }
    ngOnInit() {
        this.widgetFormGroup.valueChanges.subscribe((values) => {
            if (!this.widgetConfig) {
                return;
            }
            this.widgetConfig.title = values.title;
            this.ngOnChanges();
        });
    }
    ngAfterViewInit() {
        this.loadWidget();
    }
    loadWidget() {
        this.widgetConfig.isNew = true;
        this.changeDetectorRef.detectChanges();
        const viewContainerRef = this.viewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(this.widgetConfig.editComponent);
        this.componentRef.instance.widgetConfig = this.widgetConfig;
        this.componentRef.instance.context = this.context;
        // this.titleFieldComponent.focus();
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    ngOnChanges() {
        if (this.componentRef && this.widgetConfig) {
            this.componentRef.instance.widgetConfig = this.widgetConfig;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
    }
    saveAndClose() {
        this.activeModal.close(this.widgetConfig);
    }
    cancel() {
        this.activeModal.dismiss();
    }
    static { this.ɵfac = function AddWidgetComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AddWidgetComponent)(i0.ɵɵdirectiveInject(i1.NgbActiveModal), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.WidgetService), i0.ɵɵdirectiveInject(i3.FormBuilder), i0.ɵɵdirectiveInject(i4.EntityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AddWidgetComponent, selectors: [["ng-component"]], viewQuery: function AddWidgetComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.viewContainer = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.titleFieldComponent = _t.first);
        } }, inputs: { context: "context", widgetConfig: "widgetConfig", widgetType: "widgetType" }, features: [i0.ɵɵNgOnChangesFeature], decls: 16, vars: 2, consts: [["title", ""], [3, "formGroup"], [1, "modal-header"], [1, "modal-title"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "modal-body"], [1, "p-3"], ["formControlName", "title", 3, "field"], [1, "hr", "mt-2", "mb-2"], ["xfViewContainer", ""], [1, "modal-footer"], ["type", "button", 1, "btn", "btn-outline-dark", 3, "click"], ["type", "submit", 1, "btn", "btn-outline-primary", 3, "click"]], template: function AddWidgetComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "form", 1)(1, "div", 2)(2, "h4", 3);
            i0.ɵɵtext(3, "Add a widget");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "button", 4);
            i0.ɵɵlistener("click", function AddWidgetComponent_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.cancel()); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "div", 5)(6, "div", 6);
            i0.ɵɵelement(7, "xf-form-field", 7, 0)(9, "div", 8);
            i0.ɵɵtemplate(10, AddWidgetComponent_ng_template_10_Template, 0, 0, "ng-template", 9);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(11, "div", 10)(12, "button", 11);
            i0.ɵɵlistener("click", function AddWidgetComponent_Template_button_click_12_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.cancel()); });
            i0.ɵɵtext(13, "Cancel");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(14, "button", 12);
            i0.ɵɵlistener("click", function AddWidgetComponent_Template_button_click_14_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.saveAndClose()); });
            i0.ɵɵtext(15, "Save Widget");
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.widgetFormGroup);
            i0.ɵɵadvance(7);
            i0.ɵɵproperty("field", ctx.titleField);
        } }, dependencies: [i3.ɵNgNoValidate, i3.NgControlStatus, i3.NgControlStatusGroup, i3.FormGroupDirective, i3.FormControlName, i4.FormFieldComponent, i4.ViewContainerDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AddWidgetComponent, [{
        type: Component,
        args: [{ changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<form [formGroup]=\"widgetFormGroup\">\n  <div class=\"modal-header\">\n    <h4 class=\"modal-title\">Add a widget</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"cancel()\"></button>\n  </div>\n  <div class=\"modal-body\">\n    <div class=\"p-3\">\n      <xf-form-field [field]=\"titleField\" formControlName=\"title\" #title></xf-form-field>\n      <div class=\"hr mt-2 mb-2\"></div>\n      <ng-template xfViewContainer></ng-template>\n    </div>\n  </div>\n  <div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-outline-dark\" (click)=\"cancel()\">Cancel</button>\n    <button type=\"submit\" class=\"btn btn-outline-primary\" (click)=\"saveAndClose()\">Save Widget</button>\n  </div>\n\n</form>" }]
    }], () => [{ type: i1.NgbActiveModal }, { type: i0.ChangeDetectorRef }, { type: i2.WidgetService }, { type: i3.FormBuilder }, { type: i4.EntityService }], { context: [{
            type: Input
        }], widgetConfig: [{
            type: Input
        }], widgetType: [{
            type: Input
        }], viewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: false }]
        }], titleFieldComponent: [{
            type: ViewChild,
            args: ['title', { static: false }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AddWidgetComponent, { className: "AddWidgetComponent", filePath: "src/view-template/add-widget/add-widget.component.ts", lineNumber: 27 }); })();
//# sourceMappingURL=data:application/json;base64,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