/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, Input } from '@angular/core';
import { cloneDeep, isString } from 'lodash-es';
import { map, of } from 'rxjs';
import { AddWidgetComponent } from '../add-widget/add-widget.component';
import { AbstractLayoutItemComponent } from '../../view-template/layout-item/abstract-layout-item.component';
import { ViewLayoutItem } from '../../models/view-layout-item';
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
import * as i2 from "@ng-bootstrap/ng-bootstrap";
import * as i3 from "shared";
import * as i4 from "../../widgets/widget.service";
import * as i5 from "../view-template.service";
import * as i6 from "@angular/common/http";
const _c0 = a0 => ({ "headless": a0 });
function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "xf-widget", 6);
    i0.ɵɵlistener("edit", function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template_xf_widget_edit_1_listener($event) { i0.ɵɵrestoreView(_r1); const widgetIndex_r2 = i0.ɵɵnextContext().index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.editWidget($event, widgetIndex_r2)); })("delete", function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template_xf_widget_delete_1_listener($event) { i0.ɵɵrestoreView(_r1); const widgetIndex_r2 = i0.ɵɵnextContext().index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.deleteWidget($event, widgetIndex_r2)); })("clone", function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template_xf_widget_clone_1_listener($event) { i0.ɵɵrestoreView(_r1); const widgetIndex_r2 = i0.ɵɵnextContext().index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.cloneWidget($event, widgetIndex_r2)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const content_r4 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("config", content_r4.config)("context", ctx_r2.context)("mode", ctx_r2.mode)("showLayoutControls", true)("updateHeight", ctx_r2.onUpdateGridsterHeight)("widgetId", content_r4.id);
} }
function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "xf-layout-item", 7);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const content_r4 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("context", ctx_r2.context)("layoutItem", content_r4)("viewTemplate", ctx_r2.viewTemplate)("mode", ctx_r2.mode)("widgetSelection$", ctx_r2.widgetSelection$);
} }
function ContainerLayoutComponent_ng_container_3_gridster_item_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "gridster-item", 5);
    i0.ɵɵtemplate(1, ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template, 2, 6, "ng-container", 3)(2, ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_2_Template, 2, 5, "ng-container", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const content_r4 = ctx.$implicit;
    i0.ɵɵproperty("item", content_r4);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", content_r4.type === "widget");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", content_r4.type === "tabs");
} }
function ContainerLayoutComponent_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, ContainerLayoutComponent_ng_container_3_gridster_item_1_Template, 3, 3, "gridster-item", 4);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.layoutItem.contents);
} }
export class ContainerLayoutComponent extends AbstractLayoutItemComponent {
    constructor(route, changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService, http) {
        super(changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService);
        this.route = route;
        this.changeDetectorRef = changeDetectorRef;
        this.ngbModalService = ngbModalService;
        this.entityService = entityService;
        this.widgetService = widgetService;
        this.http = http;
        this.displayHeader = true;
        this.inputs = this.route.snapshot.queryParamMap.get('inputs') || undefined;
        // this.context$ = new BehaviorSubject<ViewTemplateContext>(new ViewTemplateContext(undefined, undefined, this.inputs));
    }
    editWidget(widgetConfig, widgetIndex) {
        this.layoutItem.contents[widgetIndex].config = widgetConfig;
        this.layoutItemChange.emit(this.layoutItem);
    }
    cloneWidget(widgetConfig, widgetIndex) {
        let clonedWidgetConfig = cloneDeep(widgetConfig);
        if (isString(clonedWidgetConfig)) {
            this.http.get(clonedWidgetConfig).subscribe((widgetConfig) => {
                delete widgetConfig.uuid;
                let widget = new ViewLayoutItem.Widget(widgetConfig);
                this.layoutItem.contents.splice(widgetIndex, 0, widget);
                this.layoutItemChange.emit(this.layoutItem);
            });
        }
        else {
            delete clonedWidgetConfig.uuid;
            let widget = new ViewLayoutItem.Widget(clonedWidgetConfig);
            this.layoutItem.contents.splice(widgetIndex, 0, widget);
            this.layoutItemChange.emit(this.layoutItem);
        }
    }
    deleteWidget(widgetConfig, widgetIndex) {
        this.layoutItem.contents.splice(widgetIndex, 1);
        this.layoutItemChange.emit(this.layoutItem);
    }
    allowDrop(ev) {
        ev.preventDefault();
    }
    getWidgetConfig(widget) {
        let widgetType$;
        if (widget.remote && widget.className) {
            widgetType$ = this.widgetService.getRemoteConfig(widget);
        }
        else {
            widgetType$ = of(this.widgetService.builtInWidgetConfigs[widget?.name || '']);
        }
        return widgetType$.pipe(map((widgetType) => {
            let widgetConfig = new widgetType('', {});
            widgetConfig.type = widget?.name || '';
            widgetConfig.isNew = true;
            return widgetConfig;
        }));
    }
    onDropWidget(ev) {
        if (ev.srcElement.id === this.layoutItem.id) {
            if (this.selectedWidget.type === 'widget') {
                this.getWidgetConfig(this.selectedWidget).subscribe((widgetConfig) => {
                    let modalRef = this.ngbModalService.open(AddWidgetComponent, {
                        backdrop: 'static',
                        windowClass: 'modal-xlarge'
                    });
                    modalRef.componentInstance.widgetConfig = widgetConfig;
                    modalRef.componentInstance.context = this.context;
                    modalRef.closed.subscribe((widgetConfig) => {
                        widgetConfig.viewTemplate = this.viewTemplate?.uuid;
                        let widgetCopy = new ViewLayoutItem.Widget(widgetConfig);
                        widgetCopy.rows = widgetConfig.defaultHeight;
                        this.layoutItem?.contents.push(widgetCopy);
                        this.changeDetectorRef.detectChanges();
                    });
                });
            }
            else if (this.selectedWidget.type === 'tabs') {
                let widgetAdd = cloneDeep(this.selectedWidget);
                this.layoutItem?.contents.push(widgetAdd);
                this.changeDetectorRef.detectChanges();
            }
        }
    }
    static { this.ɵfac = function ContainerLayoutComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ContainerLayoutComponent)(i0.ɵɵdirectiveInject(i1.ActivatedRoute), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.NgbModal), i0.ɵɵdirectiveInject(i3.EntityService), i0.ɵɵdirectiveInject(i4.WidgetService), i0.ɵɵdirectiveInject(i3.UtilityService), i0.ɵɵdirectiveInject(i5.ViewTemplateService), i0.ɵɵdirectiveInject(i6.HttpClient)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ContainerLayoutComponent, selectors: [["xf-container"]], inputs: { displayHeader: "displayHeader" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 4, vars: 8, consts: [[1, "template-container", 3, "ngClass"], [1, "container-content"], [1, "gridster-layout", 3, "drop", "dragover", "options", "id"], [4, "ngIf"], ["class", "gridster-item", 3, "item", 4, "ngFor", "ngForOf"], [1, "gridster-item", 3, "item"], [3, "edit", "delete", "clone", "config", "context", "mode", "showLayoutControls", "updateHeight", "widgetId"], [3, "context", "layoutItem", "viewTemplate", "mode", "widgetSelection$"]], template: function ContainerLayoutComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1)(2, "gridster", 2);
            i0.ɵɵlistener("drop", function ContainerLayoutComponent_Template_gridster_drop_2_listener($event) { return ctx.onDropWidget($event); })("dragover", function ContainerLayoutComponent_Template_gridster_dragover_2_listener($event) { return ctx.allowDrop($event); });
            i0.ɵɵtemplate(3, ContainerLayoutComponent_ng_container_3_Template, 2, 1, "ng-container", 3);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(6, _c0, !ctx.displayHeader));
            i0.ɵɵadvance();
            i0.ɵɵstyleProp("height", ctx.gridsterHeight, "px");
            i0.ɵɵadvance();
            i0.ɵɵpropertyInterpolate("id", ctx.layoutItem.id);
            i0.ɵɵproperty("options", ctx.gridsterConfig);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.layoutItem && ctx.layoutItem.contents.length > 0);
        } }, styles: [".template-container[_ngcontent-%COMP%]{background:var(--template-container-bg-color);padding:0}.template-container.headless[_ngcontent-%COMP%]{margin:0}.template-container[_ngcontent-%COMP%]   .container-name[_ngcontent-%COMP%]{border-bottom:1px solid var(--element-secondary-border-color);height:40px}.template-container[_ngcontent-%COMP%]   .container-content[_ngcontent-%COMP%]   grdister[_ngcontent-%COMP%]   .moobile[_ngcontent-%COMP%]{overflow-y:unset;overflow-x:unset}.template-container[_ngcontent-%COMP%]   .container-content[_ngcontent-%COMP%]   .gridster-layout[_ngcontent-%COMP%], .template-container[_ngcontent-%COMP%]   .container-content[_ngcontent-%COMP%]   .gridster-layout[_ngcontent-%COMP%]   .gridster-item[_ngcontent-%COMP%]{background:inherit}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ContainerLayoutComponent, [{
        type: Component,
        args: [{ selector: 'xf-container', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"template-container\" [ngClass]=\"{'headless': !displayHeader}\">\n  <div class=\"container-content\" [style.height.px]=\"gridsterHeight\">\n    <!-- Make a directive or component -->\n\n    <gridster [options]=\"gridsterConfig\" (drop)=\"onDropWidget($event)\" (dragover)=\"allowDrop($event)\"\n      class=\"gridster-layout\" id=\"{{layoutItem.id}}\">\n      <ng-container *ngIf=\"layoutItem && layoutItem.contents.length > 0\">\n\n        <gridster-item class=\"gridster-item\" [item]=\"content\" *ngFor=\"let content of layoutItem.contents; let widgetIndex = index\">\n          <ng-container *ngIf=\"content.type === 'widget'\">\n            <xf-widget [config]=\"content.config\" [context]=\"context\" [mode]=\"mode\" [showLayoutControls]=\"true\"\n              (edit)=\"editWidget($event, widgetIndex)\" (delete)=\"deleteWidget($event, widgetIndex)\"\n              (clone)=\"cloneWidget($event, widgetIndex)\" [updateHeight]=\"onUpdateGridsterHeight\" [widgetId]=\"content.id\">\n            </xf-widget>\n          </ng-container>\n          <ng-container *ngIf=\"content.type === 'tabs'\">\n            <xf-layout-item [context]=\"context\" [layoutItem]=\"content\" [viewTemplate]=\"viewTemplate\" [mode]=\"mode\"\n              [widgetSelection$]=\"widgetSelection$\"></xf-layout-item>\n          </ng-container>\n\n\n        </gridster-item>\n      </ng-container>\n\n    </gridster>\n\n\n  </div>\n\n</div>\n", styles: [".template-container{background:var(--template-container-bg-color);padding:0}.template-container.headless{margin:0}.template-container .container-name{border-bottom:1px solid var(--element-secondary-border-color);height:40px}.template-container .container-content grdister .moobile{overflow-y:unset;overflow-x:unset}.template-container .container-content .gridster-layout,.template-container .container-content .gridster-layout .gridster-item{background:inherit}\n"] }]
    }], () => [{ type: i1.ActivatedRoute }, { type: i0.ChangeDetectorRef }, { type: i2.NgbModal }, { type: i3.EntityService }, { type: i4.WidgetService }, { type: i3.UtilityService }, { type: i5.ViewTemplateService }, { type: i6.HttpClient }], { displayHeader: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ContainerLayoutComponent, { className: "ContainerLayoutComponent", filePath: "src/view-template/container-layout/container-layout.component.ts", lineNumber: 29 }); })();
//# sourceMappingURL=data:application/json;base64,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