/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, Input, ViewChild, ViewChildren } from '@angular/core';
import { FieldOptions, FormFieldComponent, TextField } from "shared";
import { ViewContainerDirective } from 'shared';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/common";
import * as i4 from "shared";
const _c0 = ["titleElement"];
function EditWidgetComponent_xf_form_field_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-field", 16, 0);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("field", ctx_r0.titleField)("fieldOptions", ctx_r0.titleFieldOptions);
} }
function EditWidgetComponent_button_11_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 17);
    i0.ɵɵlistener("click", function EditWidgetComponent_button_11_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r0.addTitle()); });
    i0.ɵɵtext(1, "+ Add Title");
    i0.ɵɵelementEnd();
} }
function EditWidgetComponent_ng_template_13_Template(rf, ctx) { }
export class EditWidgetComponent {
    constructor(activeModal, changeDetectorRef, formBuilder, element) {
        this.activeModal = activeModal;
        this.changeDetectorRef = changeDetectorRef;
        this.element = element;
        this.showTitleField = false;
        this.titleFieldOptions = new FieldOptions();
        this.formGroup = formBuilder.group({
            title: ['']
        });
        let titleField = new TextField('widget-title');
        titleField.validation.required = false;
        titleField.descriptions = {
            singular: 'Title'
        };
        this.titleField = titleField;
        this.titleFieldOptions.showLabel = false;
    }
    ngOnInit() {
        this.formGroup.controls.title.setValue(this.widgetConfig.title);
        if (this.widgetConfig.title) {
            this.showTitleField = true;
            this.changeDetectorRef.detectChanges();
        }
        this.formGroup.controls.title.valueChanges.subscribe((title) => {
            this.widgetConfig.title = title;
        });
    }
    ngAfterViewInit() {
        const viewContainerRef = this.viewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(this.widgetConfig.editComponent);
        this.componentRef.instance.widgetConfig = this.widgetConfig;
        this.componentRef.instance.context = this.context;
        this.changeDetectorRef.detectChanges();
    }
    saveAndClose() {
        if (this.formGroup.invalid) {
            this.formGroup.markAsTouched();
            this.formFields.forEach((formField) => {
                if (!formField.valid) {
                    formField.focus();
                    return;
                }
            });
            return;
        }
        this.activeModal.close(this.widgetConfig);
    }
    addTitle() {
        this.showTitleField = true;
        this.changeDetectorRef.detectChanges();
        setTimeout(() => this.titleElement.focus());
    }
    cancel() {
        this.activeModal.dismiss();
    }
    static { this.ɵfac = function EditWidgetComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EditWidgetComponent)(i0.ɵɵdirectiveInject(i1.NgbActiveModal), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i0.ElementRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: EditWidgetComponent, selectors: [["xf-edit-widget"]], viewQuery: function EditWidgetComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.titleElement = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.viewContainer = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFields = _t);
        } }, inputs: { context: "context", widgetConfig: "widgetConfig" }, decls: 19, vars: 5, consts: [["titleElement", ""], ["focusInvalidInput", "", 3, "ngSubmit", "formGroup"], [1, "modal-header"], [1, "modal-title"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "modal-body"], [1, "p-3"], [1, "form-group"], [1, "form-label", 3, "for"], ["formControlName", "title", 3, "field", "fieldOptions", 4, "ngIf"], ["type", "button", "class", "btn btn-link d-block", 3, "click", 4, "ngIf"], [1, "hr", "mt-2", "mb-2"], ["xfViewContainer", ""], [1, "modal-footer"], ["type", "button", 1, "btn", "btn-outline-dark", 3, "click"], ["type", "submit", 1, "btn", "btn-outline-primary"], ["formControlName", "title", 3, "field", "fieldOptions"], ["type", "button", 1, "btn", "btn-link", "d-block", 3, "click"]], template: function EditWidgetComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "form", 1);
            i0.ɵɵlistener("ngSubmit", function EditWidgetComponent_Template_form_ngSubmit_0_listener() { return ctx.saveAndClose(); });
            i0.ɵɵelementStart(1, "div", 2)(2, "h4", 3);
            i0.ɵɵtext(3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "button", 4);
            i0.ɵɵlistener("click", function EditWidgetComponent_Template_button_click_4_listener() { return ctx.cancel(); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "div", 5)(6, "div", 6)(7, "div", 7)(8, "label", 8);
            i0.ɵɵtext(9, "Title");
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(10, EditWidgetComponent_xf_form_field_10_Template, 2, 2, "xf-form-field", 9)(11, EditWidgetComponent_button_11_Template, 2, 0, "button", 10);
            i0.ɵɵelementEnd();
            i0.ɵɵelement(12, "div", 11);
            i0.ɵɵtemplate(13, EditWidgetComponent_ng_template_13_Template, 0, 0, "ng-template", 12);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(14, "div", 13)(15, "button", 14);
            i0.ɵɵlistener("click", function EditWidgetComponent_Template_button_click_15_listener() { return ctx.cancel(); });
            i0.ɵɵtext(16, "Cancel");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(17, "button", 15);
            i0.ɵɵtext(18, "Save and Close");
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(3);
            i0.ɵɵtextInterpolate1("Edit Widget: ", ctx.widgetConfig.title, "");
            i0.ɵɵadvance(5);
            i0.ɵɵproperty("for", "input-title");
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.showTitleField);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.showTitleField);
        } }, dependencies: [i3.NgIf, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i4.FormFieldComponent, i4.FocusInvalidInputDirective, i4.ViewContainerDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EditWidgetComponent, [{
        type: Component,
        args: [{ selector: 'xf-edit-widget', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<form [formGroup]=\"formGroup\" (ngSubmit)=\"saveAndClose()\" focusInvalidInput>\n  <div class=\"modal-header\">\n    <h4 class=\"modal-title\">Edit Widget: {{ widgetConfig.title }}</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"cancel()\"></button>\n  </div>\n  <div class=\"modal-body\">\n    <div class=\"p-3\">\n      <div class=\"form-group\">\n        <label class=\"form-label\" [for]=\"'input-title'\">Title</label>\n        <xf-form-field *ngIf=\"showTitleField\" [field]=\"titleField\" formControlName=\"title\" #titleElement [fieldOptions]=\"titleFieldOptions\"></xf-form-field>\n        <button type=\"button\" class=\"btn btn-link d-block\" *ngIf=\"!showTitleField\" (click)=\"addTitle()\">+ Add Title</button>\n      </div>\n      <div class=\"hr mt-2 mb-2\"></div>\n      <ng-template xfViewContainer></ng-template>\n    </div>\n  </div>\n  <div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-outline-dark\" (click)=\"cancel()\">Cancel</button>\n    <button type=\"submit\" class=\"btn btn-outline-primary\">Save and Close</button>\n  </div>\n</form>\n" }]
    }], () => [{ type: i1.NgbActiveModal }, { type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }, { type: i0.ElementRef }], { context: [{
            type: Input
        }], widgetConfig: [{
            type: Input
        }], titleElement: [{
            type: ViewChild,
            args: ['titleElement', { static: false }]
        }], viewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: false }]
        }], formFields: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(EditWidgetComponent, { className: "EditWidgetComponent", filePath: "src/view-template/edit-widget/edit-widget.component.ts", lineNumber: 21 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWRpdC13aWRnZXQuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc2hhcmVkL3ZpZXctdGVtcGxhdGVzL3NyYy92aWV3LXRlbXBsYXRlL2VkaXQtd2lkZ2V0L2VkaXQtd2lkZ2V0LmNvbXBvbmVudC50cyIsIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC92aWV3LXRlbXBsYXRlcy9zcmMvdmlldy10ZW1wbGF0ZS9lZGl0LXdpZGdldC9lZGl0LXdpZGdldC5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7OztrQkFJa0I7QUFDbEIsT0FBTyxFQUFpQix1QkFBdUIsRUFBcUIsU0FBUyxFQUE0QixLQUFLLEVBQWEsU0FBUyxFQUFFLFlBQVksRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUcxSyxPQUFPLEVBQUUsWUFBWSxFQUFFLGtCQUFrQixFQUFFLFNBQVMsRUFBRSxNQUFNLFFBQVEsQ0FBQztBQUlyRSxPQUFPLEVBQUUsc0JBQXNCLEVBQUUsTUFBTSxRQUFRLENBQUM7Ozs7Ozs7O0lDRXhDLHVDQUFvSjs7O0lBQW5ELEFBQTNELHlDQUFvQiwwQ0FBeUU7Ozs7SUFDbkksa0NBQWdHO0lBQXJCLG1MQUFTLGlCQUFVLEtBQUM7SUFBQywyQkFBVztJQUFBLGlCQUFTOzs7QURLNUgsTUFBTSxPQUFPLG1CQUFtQjtJQWE5QixZQUNTLFdBQTJCLEVBQzFCLGlCQUFvQyxFQUM1QyxXQUF3QixFQUNoQixPQUFtQjtRQUhwQixnQkFBVyxHQUFYLFdBQVcsQ0FBZ0I7UUFDMUIsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFtQjtRQUVwQyxZQUFPLEdBQVAsT0FBTyxDQUFZO1FBUDdCLG1CQUFjLEdBQVksS0FBSyxDQUFDO1FBQ2hDLHNCQUFpQixHQUFHLElBQUksWUFBWSxFQUFFLENBQUM7UUFRckMsSUFBSSxDQUFDLFNBQVMsR0FBRyxXQUFXLENBQUMsS0FBSyxDQUFDO1lBQ2pDLEtBQUssRUFBRSxDQUFDLEVBQUUsQ0FBQztTQUNaLENBQUMsQ0FBQztRQUNILElBQUksVUFBVSxHQUFHLElBQUksU0FBUyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQy9DLFVBQVUsQ0FBQyxVQUFVLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztRQUN2QyxVQUFVLENBQUMsWUFBWSxHQUFHO1lBQ3hCLFFBQVEsRUFBRSxPQUFPO1NBQ2xCLENBQUM7UUFDRixJQUFJLENBQUMsVUFBVSxHQUFHLFVBQVUsQ0FBQztRQUM3QixJQUFJLENBQUMsaUJBQWlCLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUMzQyxDQUFDO0lBRUQsUUFBUTtRQUNOLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNoRSxJQUFJLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDNUIsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUM7WUFDM0IsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQ3pDLENBQUM7UUFDRCxJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDLEtBQWEsRUFBRSxFQUFFO1lBQ3JFLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNsQyxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRCxlQUFlO1FBQ2IsTUFBTSxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLGdCQUFnQixDQUFDO1FBQzdELGdCQUFnQixDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxZQUFZLEdBQUcsZ0JBQWdCLENBQUMsZUFBZSxDQUE4QixJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ25ILElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDO1FBQzVELElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1FBQ2xELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN6QyxDQUFDO0lBR0QsWUFBWTtRQUNWLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztZQUMzQixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsRUFBRSxDQUFDO1lBQy9CLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsU0FBNkIsRUFBRSxFQUFFO2dCQUN4RCxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRSxDQUFDO29CQUNyQixTQUFTLENBQUMsS0FBSyxFQUFFLENBQUM7b0JBQ2xCLE9BQU87Z0JBQ1QsQ0FBQztZQUNILENBQUMsQ0FBQyxDQUFDO1lBQ0gsT0FBTztRQUNULENBQUM7UUFDRCxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUVELFFBQVE7UUFDTixJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQztRQUMzQixJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7UUFDdkMsVUFBVSxDQUFDLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRUQsTUFBTTtRQUNKLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxFQUFFLENBQUM7SUFDN0IsQ0FBQztvSEExRVUsbUJBQW1CO29FQUFuQixtQkFBbUI7OzJCQUtuQixzQkFBc0I7MkJBQ25CLGtCQUFrQjs7Ozs7OztZQ3JCbEMsK0JBQTRFO1lBQTlDLG9HQUFZLGtCQUFjLElBQUM7WUFFckQsQUFERiw4QkFBMEIsWUFDQTtZQUFBLFlBQXFDO1lBQUEsaUJBQUs7WUFDbEUsaUNBQThFO1lBQW5CLGdHQUFTLFlBQVEsSUFBQztZQUMvRSxBQURnRixpQkFBUyxFQUNuRjtZQUlBLEFBREYsQUFERixBQURGLDhCQUF3QixhQUNMLGFBQ1MsZUFDMEI7WUFBQSxxQkFBSztZQUFBLGlCQUFRO1lBRTdELEFBREEsMEZBQW9JLGdFQUNwQztZQUNsRyxpQkFBTTtZQUNOLDJCQUFnQztZQUNoQyx1RkFBNkI7WUFFakMsQUFERSxpQkFBTSxFQUNGO1lBRUosQUFERixnQ0FBMEIsa0JBQzhDO1lBQW5CLGlHQUFTLFlBQVEsSUFBQztZQUFDLHVCQUFNO1lBQUEsaUJBQVM7WUFDckYsbUNBQXNEO1lBQUEsK0JBQWM7WUFFeEUsQUFERSxBQURzRSxpQkFBUyxFQUN6RSxFQUNEOztZQXBCRCx5Q0FBdUI7WUFFRCxlQUFxQztZQUFyQyxrRUFBcUM7WUFNL0IsZUFBcUI7WUFBckIsbUNBQXFCO1lBQy9CLGVBQW9CO1lBQXBCLHlDQUFvQjtZQUNnQixjQUFxQjtZQUFyQiwwQ0FBcUI7OztpRkRLcEUsbUJBQW1CO2NBTi9CLFNBQVM7MkJBQ0UsZ0JBQWdCLG1CQUdULHVCQUF1QixDQUFDLE1BQU07a0lBSXRDLE9BQU87a0JBQWYsS0FBSztZQUNHLFlBQVk7a0JBQXBCLEtBQUs7WUFDd0MsWUFBWTtrQkFBekQsU0FBUzttQkFBQyxjQUFjLEVBQUUsRUFBRSxNQUFNLEVBQUUsS0FBSyxFQUFFO1lBQ1UsYUFBYTtrQkFBbEUsU0FBUzttQkFBQyxzQkFBc0IsRUFBRSxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUU7WUFDbEIsVUFBVTtrQkFBM0MsWUFBWTttQkFBQyxrQkFBa0I7O2tGQU5yQixtQkFBbUIiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBDb3B5cmlnaHQgc3RhcnRcbiAgQ29weXJpZ2h0IChDKSAyMDA4IC0gMjAyNSBGb3J0aW5ldCBJbmMuXG4gIEFsbCByaWdodHMgcmVzZXJ2ZWQuXG4gIEZPUlRJTkVUIENPTkZJREVOVElBTCAmIEZPUlRJTkVUIFBST1BSSUVUQVJZIFNPVVJDRSBDT0RFXG4gIENvcHlyaWdodCBlbmQgKi9cbmltcG9ydCB7IEFmdGVyVmlld0luaXQsIENoYW5nZURldGVjdGlvblN0cmF0ZWd5LCBDaGFuZ2VEZXRlY3RvclJlZiwgQ29tcG9uZW50LCBDb21wb25lbnRSZWYsIEVsZW1lbnRSZWYsIElucHV0LCBRdWVyeUxpc3QsIFZpZXdDaGlsZCwgVmlld0NoaWxkcmVuIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBGb3JtQnVpbGRlciwgRm9ybUdyb3VwIH0gZnJvbSAnQGFuZ3VsYXIvZm9ybXMnO1xuaW1wb3J0IHsgTmdiQWN0aXZlTW9kYWwgfSBmcm9tICdAbmctYm9vdHN0cmFwL25nLWJvb3RzdHJhcCc7XG5pbXBvcnQgeyBGaWVsZE9wdGlvbnMsIEZvcm1GaWVsZENvbXBvbmVudCwgVGV4dEZpZWxkIH0gZnJvbSBcInNoYXJlZFwiO1xuaW1wb3J0IHsgVmlld1RlbXBsYXRlQ29udGV4dCB9IGZyb20gJy4uLy4uL21vZGVscy92aWV3LXRlbXBsYXRlLWNvbnRleHQnO1xuaW1wb3J0IHsgV2lkZ2V0Q29uZmlnIH0gZnJvbSAnLi4vLi4vbW9kZWxzL3dpZGdldC1jb25maWcnO1xuaW1wb3J0IHsgQWJzdHJhY3RXaWRnZXRFZGl0Q29tcG9uZW50IH0gZnJvbSAnLi4vLi4vd2lkZ2V0cy9hYnN0cmFjdC13aWRnZXQtZWRpdC5jb21wb25lbnQnO1xuaW1wb3J0IHsgVmlld0NvbnRhaW5lckRpcmVjdGl2ZSB9IGZyb20gJ3NoYXJlZCc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ3hmLWVkaXQtd2lkZ2V0JyxcbiAgdGVtcGxhdGVVcmw6ICcuL2VkaXQtd2lkZ2V0LmNvbXBvbmVudC5odG1sJyxcbiAgc3R5bGVVcmxzOiBbJy4vZWRpdC13aWRnZXQuY29tcG9uZW50LnNjc3MnXSxcbiAgY2hhbmdlRGV0ZWN0aW9uOiBDaGFuZ2VEZXRlY3Rpb25TdHJhdGVneS5PblB1c2hcbn0pXG5leHBvcnQgY2xhc3MgRWRpdFdpZGdldENvbXBvbmVudCBpbXBsZW1lbnRzIEFmdGVyVmlld0luaXQge1xuXG4gIEBJbnB1dCgpIGNvbnRleHQhOiBWaWV3VGVtcGxhdGVDb250ZXh0O1xuICBASW5wdXQoKSB3aWRnZXRDb25maWchOiBXaWRnZXRDb25maWc7XG4gIEBWaWV3Q2hpbGQoJ3RpdGxlRWxlbWVudCcsIHsgc3RhdGljOiBmYWxzZSB9KSB0aXRsZUVsZW1lbnQhOiBGb3JtRmllbGRDb21wb25lbnQ7XG4gIEBWaWV3Q2hpbGQoVmlld0NvbnRhaW5lckRpcmVjdGl2ZSwgeyBzdGF0aWM6IGZhbHNlIH0pIHZpZXdDb250YWluZXIhOiBWaWV3Q29udGFpbmVyRGlyZWN0aXZlO1xuICBAVmlld0NoaWxkcmVuKEZvcm1GaWVsZENvbXBvbmVudCkgZm9ybUZpZWxkcyE6IFF1ZXJ5TGlzdDxGb3JtRmllbGRDb21wb25lbnQ+O1xuICBjb21wb25lbnRSZWYhOiBDb21wb25lbnRSZWY8QWJzdHJhY3RXaWRnZXRFZGl0Q29tcG9uZW50PjtcbiAgZm9ybUdyb3VwOiBGb3JtR3JvdXA7XG4gIHRpdGxlRmllbGQ6IFRleHRGaWVsZDtcbiAgc2hvd1RpdGxlRmllbGQ6IGJvb2xlYW4gPSBmYWxzZTtcbiAgdGl0bGVGaWVsZE9wdGlvbnMgPSBuZXcgRmllbGRPcHRpb25zKCk7XG5cbiAgY29uc3RydWN0b3IoXG4gICAgcHVibGljIGFjdGl2ZU1vZGFsOiBOZ2JBY3RpdmVNb2RhbCxcbiAgICBwcml2YXRlIGNoYW5nZURldGVjdG9yUmVmOiBDaGFuZ2VEZXRlY3RvclJlZixcbiAgICBmb3JtQnVpbGRlcjogRm9ybUJ1aWxkZXIsXG4gICAgcHJpdmF0ZSBlbGVtZW50OiBFbGVtZW50UmVmXG4gICkge1xuICAgIHRoaXMuZm9ybUdyb3VwID0gZm9ybUJ1aWxkZXIuZ3JvdXAoe1xuICAgICAgdGl0bGU6IFsnJ11cbiAgICB9KTtcbiAgICBsZXQgdGl0bGVGaWVsZCA9IG5ldyBUZXh0RmllbGQoJ3dpZGdldC10aXRsZScpO1xuICAgIHRpdGxlRmllbGQudmFsaWRhdGlvbi5yZXF1aXJlZCA9IGZhbHNlO1xuICAgIHRpdGxlRmllbGQuZGVzY3JpcHRpb25zID0ge1xuICAgICAgc2luZ3VsYXI6ICdUaXRsZSdcbiAgICB9O1xuICAgIHRoaXMudGl0bGVGaWVsZCA9IHRpdGxlRmllbGQ7XG4gICAgdGhpcy50aXRsZUZpZWxkT3B0aW9ucy5zaG93TGFiZWwgPSBmYWxzZTtcbiAgfVxuXG4gIG5nT25Jbml0KCkge1xuICAgIHRoaXMuZm9ybUdyb3VwLmNvbnRyb2xzLnRpdGxlLnNldFZhbHVlKHRoaXMud2lkZ2V0Q29uZmlnLnRpdGxlKTtcbiAgICBpZiAodGhpcy53aWRnZXRDb25maWcudGl0bGUpIHtcbiAgICAgIHRoaXMuc2hvd1RpdGxlRmllbGQgPSB0cnVlO1xuICAgICAgdGhpcy5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gICAgfVxuICAgIHRoaXMuZm9ybUdyb3VwLmNvbnRyb2xzLnRpdGxlLnZhbHVlQ2hhbmdlcy5zdWJzY3JpYmUoKHRpdGxlOiBzdHJpbmcpID0+IHtcbiAgICAgIHRoaXMud2lkZ2V0Q29uZmlnLnRpdGxlID0gdGl0bGU7XG4gICAgfSk7XG4gIH1cblxuICBuZ0FmdGVyVmlld0luaXQoKTogdm9pZCB7XG4gICAgY29uc3Qgdmlld0NvbnRhaW5lclJlZiA9IHRoaXMudmlld0NvbnRhaW5lci52aWV3Q29udGFpbmVyUmVmO1xuICAgIHZpZXdDb250YWluZXJSZWYuY2xlYXIoKTtcbiAgICB0aGlzLmNvbXBvbmVudFJlZiA9IHZpZXdDb250YWluZXJSZWYuY3JlYXRlQ29tcG9uZW50PEFic3RyYWN0V2lkZ2V0RWRpdENvbXBvbmVudD4odGhpcy53aWRnZXRDb25maWcuZWRpdENvbXBvbmVudCk7XG4gICAgdGhpcy5jb21wb25lbnRSZWYuaW5zdGFuY2Uud2lkZ2V0Q29uZmlnID0gdGhpcy53aWRnZXRDb25maWc7XG4gICAgdGhpcy5jb21wb25lbnRSZWYuaW5zdGFuY2UuY29udGV4dCA9IHRoaXMuY29udGV4dDtcbiAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgfVxuXG5cbiAgc2F2ZUFuZENsb3NlKCkge1xuICAgIGlmICh0aGlzLmZvcm1Hcm91cC5pbnZhbGlkKSB7XG4gICAgICB0aGlzLmZvcm1Hcm91cC5tYXJrQXNUb3VjaGVkKCk7XG4gICAgICB0aGlzLmZvcm1GaWVsZHMuZm9yRWFjaCgoZm9ybUZpZWxkOiBGb3JtRmllbGRDb21wb25lbnQpID0+IHtcbiAgICAgICAgaWYgKCFmb3JtRmllbGQudmFsaWQpIHtcbiAgICAgICAgICBmb3JtRmllbGQuZm9jdXMoKTtcbiAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgIH0pO1xuICAgICAgcmV0dXJuO1xuICAgIH1cbiAgICB0aGlzLmFjdGl2ZU1vZGFsLmNsb3NlKHRoaXMud2lkZ2V0Q29uZmlnKTtcbiAgfVxuXG4gIGFkZFRpdGxlKCkge1xuICAgIHRoaXMuc2hvd1RpdGxlRmllbGQgPSB0cnVlO1xuICAgIHRoaXMuY2hhbmdlRGV0ZWN0b3JSZWYuZGV0ZWN0Q2hhbmdlcygpO1xuICAgIHNldFRpbWVvdXQoKCkgPT4gdGhpcy50aXRsZUVsZW1lbnQuZm9jdXMoKSk7XG4gIH1cblxuICBjYW5jZWwoKSB7XG4gICAgdGhpcy5hY3RpdmVNb2RhbC5kaXNtaXNzKCk7XG4gIH1cblxufVxuIiwiPCEtLSBDb3B5cmlnaHQgc3RhcnRcbiAgQ29weXJpZ2h0IChDKSAyMDA4IC0gMjAyNSBGb3J0aW5ldCBJbmMuXG4gIEFsbCByaWdodHMgcmVzZXJ2ZWQuXG4gIEZPUlRJTkVUIENPTkZJREVOVElBTCAmIEZPUlRJTkVUIFBST1BSSUVUQVJZIFNPVVJDRSBDT0RFXG4gIENvcHlyaWdodCBlbmQgLS0+XG48Zm9ybSBbZm9ybUdyb3VwXT1cImZvcm1Hcm91cFwiIChuZ1N1Ym1pdCk9XCJzYXZlQW5kQ2xvc2UoKVwiIGZvY3VzSW52YWxpZElucHV0PlxuICA8ZGl2IGNsYXNzPVwibW9kYWwtaGVhZGVyXCI+XG4gICAgPGg0IGNsYXNzPVwibW9kYWwtdGl0bGVcIj5FZGl0IFdpZGdldDoge3sgd2lkZ2V0Q29uZmlnLnRpdGxlIH19PC9oND5cbiAgICA8YnV0dG9uIHR5cGU9XCJidXR0b25cIiBjbGFzcz1cImJ0bi1jbG9zZVwiIGFyaWEtbGFiZWw9XCJDbG9zZVwiIChjbGljayk9XCJjYW5jZWwoKVwiPjwvYnV0dG9uPlxuICA8L2Rpdj5cbiAgPGRpdiBjbGFzcz1cIm1vZGFsLWJvZHlcIj5cbiAgICA8ZGl2IGNsYXNzPVwicC0zXCI+XG4gICAgICA8ZGl2IGNsYXNzPVwiZm9ybS1ncm91cFwiPlxuICAgICAgICA8bGFiZWwgY2xhc3M9XCJmb3JtLWxhYmVsXCIgW2Zvcl09XCInaW5wdXQtdGl0bGUnXCI+VGl0bGU8L2xhYmVsPlxuICAgICAgICA8eGYtZm9ybS1maWVsZCAqbmdJZj1cInNob3dUaXRsZUZpZWxkXCIgW2ZpZWxkXT1cInRpdGxlRmllbGRcIiBmb3JtQ29udHJvbE5hbWU9XCJ0aXRsZVwiICN0aXRsZUVsZW1lbnQgW2ZpZWxkT3B0aW9uc109XCJ0aXRsZUZpZWxkT3B0aW9uc1wiPjwveGYtZm9ybS1maWVsZD5cbiAgICAgICAgPGJ1dHRvbiB0eXBlPVwiYnV0dG9uXCIgY2xhc3M9XCJidG4gYnRuLWxpbmsgZC1ibG9ja1wiICpuZ0lmPVwiIXNob3dUaXRsZUZpZWxkXCIgKGNsaWNrKT1cImFkZFRpdGxlKClcIj4rIEFkZCBUaXRsZTwvYnV0dG9uPlxuICAgICAgPC9kaXY+XG4gICAgICA8ZGl2IGNsYXNzPVwiaHIgbXQtMiBtYi0yXCI+PC9kaXY+XG4gICAgICA8bmctdGVtcGxhdGUgeGZWaWV3Q29udGFpbmVyPjwvbmctdGVtcGxhdGU+XG4gICAgPC9kaXY+XG4gIDwvZGl2PlxuICA8ZGl2IGNsYXNzPVwibW9kYWwtZm9vdGVyXCI+XG4gICAgPGJ1dHRvbiB0eXBlPVwiYnV0dG9uXCIgY2xhc3M9XCJidG4gYnRuLW91dGxpbmUtZGFya1wiIChjbGljayk9XCJjYW5jZWwoKVwiPkNhbmNlbDwvYnV0dG9uPlxuICAgIDxidXR0b24gdHlwZT1cInN1Ym1pdFwiIGNsYXNzPVwiYnRuIGJ0bi1vdXRsaW5lLXByaW1hcnlcIj5TYXZlIGFuZCBDbG9zZTwvYnV0dG9uPlxuICA8L2Rpdj5cbjwvZm9ybT5cbiJdfQ==