/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { Subject } from 'rxjs';
import { map } from 'rxjs/operators';
import { AddWidgetComponent } from '../add-widget/add-widget.component';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "shared";
import * as i3 from "../../widgets/widget.service";
import * as i4 from "../view-template.service";
export class AbstractLayoutItemComponent {
    constructor(changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService) {
        this.changeDetectorRef = changeDetectorRef;
        this.ngbModalService = ngbModalService;
        this.entityService = entityService;
        this.widgetService = widgetService;
        this.utilityService = utilityService;
        this.viewTemplateService = viewTemplateService;
        this.layoutItemChange = new EventEmitter();
        this.gridsterHeight = 150;
        this.fixedGridItemHeight = 50;
        // TODO: - Revisit after PM dicsussion. Do we need the abilit to add multiple containers?
        this.onUpdateGridsterHeight = new Subject();
    }
    ngOnInit() {
        if (this.context.module) {
            this.entityService.build(this.context.module).subscribe((entity) => this.entity = entity);
            this.changeDetectorRef.detectChanges();
        }
        this.widgetSelection$.subscribe((widget) => {
            this.selectedWidget = widget;
        });
        this.utilityService.navigationChanged.subscribe(() => {
            this.gridsterResize();
        });
        this.viewTemplateService.widgetLibraryChanged.subscribe(() => {
            this.gridsterResize();
        });
    }
    addWidget() {
        let modalRef = this.ngbModalService.open(AddWidgetComponent, {
            backdrop: 'static',
            windowClass: 'modal-xlarge'
        });
        modalRef.componentInstance.context = this.context;
        return modalRef.closed.pipe(map((widgetConfig) => {
            widgetConfig.viewTemplate = this.viewTemplate?.uuid || null;
            return widgetConfig;
        }));
    }
    gridsterResize() {
        if (this.gridsterConfig && this.gridsterConfig.api && this.gridsterConfig.api.resize) {
            this.gridsterConfig.api.resize();
        }
    }
    static { this.ɵfac = function AbstractLayoutItemComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractLayoutItemComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.NgbModal), i0.ɵɵdirectiveInject(i2.EntityService), i0.ɵɵdirectiveInject(i3.WidgetService), i0.ɵɵdirectiveInject(i2.UtilityService), i0.ɵɵdirectiveInject(i4.ViewTemplateService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractLayoutItemComponent, selectors: [["xf-abstract-layout-item"]], inputs: { layoutItem: "layoutItem", mode: "mode", viewTemplate: "viewTemplate", context: "context", selectedWidget: "selectedWidget", widgetSelection$: "widgetSelection$", gridsterConfig: "gridsterConfig" }, outputs: { layoutItemChange: "layoutItemChange" }, decls: 0, vars: 0, template: function AbstractLayoutItemComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractLayoutItemComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-layout-item',
                template: ''
            }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.NgbModal }, { type: i2.EntityService }, { type: i3.WidgetService }, { type: i2.UtilityService }, { type: i4.ViewTemplateService }], { layoutItem: [{
            type: Input
        }], mode: [{
            type: Input
        }], viewTemplate: [{
            type: Input
        }], context: [{
            type: Input
        }], selectedWidget: [{
            type: Input
        }], widgetSelection$: [{
            type: Input
        }], gridsterConfig: [{
            type: Input
        }], layoutItemChange: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractLayoutItemComponent, { className: "AbstractLayoutItemComponent", filePath: "src/view-template/layout-item/abstract-layout-item.component.ts", lineNumber: 26 }); })();
//# sourceMappingURL=data:application/json;base64,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