import { Injectable } from '@angular/core';
import { NavigationEnd } from '@angular/router';
import { plainToInstance } from 'class-transformer';
import { cloneDeep, concat, flatten, isString, last } from 'lodash-es';
import { ReplaySubject, forkJoin, of } from 'rxjs';
import { concatMap, filter, map } from 'rxjs/operators';
import { ALL_RECORDS_SIZE, API, FIXED_MODULE } from "shared";
import { ViewLayoutItem } from '../models/view-layout-item';
import { ViewTemplate } from '../models/view-template';
import { WidgetConfig } from '../models/widget-config';
//TODO: Remove after backend API is ready
import { Entity } from "shared";
import { v4 as uuidv4 } from 'uuid';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "@angular/router";
import * as i3 from "shared";
export class ViewTemplateService {
    constructor(http, router, apiService, utilityService) {
        this.http = http;
        this.router = router;
        this.apiService = apiService;
        this.utilityService = utilityService;
        this.widgetLibraryChanged = new ReplaySubject(0);
        this.router.events
            .pipe(filter((e) => e instanceof NavigationEnd))
            .subscribe(() => {
            this.currentUrl = this.router.url;
        });
        // TODO: Add view template mmd
        this.viewTemplateEntity = new Entity(FIXED_MODULE.VIEW_TEMPLATES);
        this.viewTemplateEntity.baseUrl = API.API_APPMANAGER;
        this.widgetConfigEntity = new Entity(FIXED_MODULE.WIDGET_CONFIGS);
        this.widgetConfigEntity.baseUrl = API.API_APPMANAGER;
    }
    loadByUuid(uuid, includeWidgetConfigs = false) {
        let observable$;
        if (includeWidgetConfigs) {
            observable$ = this.apiService.query(this.widgetConfigEntity, {
                filters: [{
                        field: 'viewTemplate',
                        operator: 'eq',
                        value: uuid
                    }]
            }).pipe(map((response) => {
                return response['hydra:member'];
            }));
        }
        else {
            observable$ = of([]);
        }
        return observable$.pipe(concatMap((widgetConfigs) => {
            return this.apiService.getRecord(this.viewTemplateEntity, uuid, ViewTemplate).pipe(map((viewTemplate) => {
                viewTemplate.widgetConfigs = widgetConfigs;
                return plainToInstance(ViewTemplate, viewTemplate);
            }));
        }));
    }
    loadWithParams(filters) {
        return this.apiService.query(this.viewTemplateEntity, {
            filters: filters,
            limit: ALL_RECORDS_SIZE
        }).pipe(map((response) => {
            return response['hydra:member'];
        }));
    }
    //TODO:- Use when API is ready
    // public loadWithParams(params: any): Observable<ViewTemplate[]> {
    //   let filters = [];
    //   for (const k in params) {
    //     filters.push({
    //       field: k,
    //       operator: 'eq',
    //       value: params[k]
    //     });
    //   }
    //   // to do: use Query
    //   return this.http.post(API.QUERY + MMD.VIEW_TEMPLATES_KEY,
    //     {
    //       filters: filters,
    //       logic: 'AND',
    //       __selectFields: ['uuid', 'title']
    //     }
    //   )
    //     .pipe(
    //       map((response: any) => {
    //         return plainToInstance(ViewTemplate, response['hydra:member']);
    //       })
    //     );
    // }
    delete(uuid) {
        return this.apiService.deleteRecord(this.viewTemplateEntity, uuid);
    }
    save(viewTemplate) {
        let data = viewTemplate;
        let observable;
        let widgetConfigs = [];
        if (viewTemplate.layout) {
            widgetConfigs = flatten(viewTemplate.layout.map((item) => this.getNewWidgetConfigs(item)));
            data.widget_configs = widgetConfigs;
        }
        if (viewTemplate.uuid) {
            observable = this.apiService.updateRecord(this.viewTemplateEntity, viewTemplate.uuid, data);
        }
        else {
            observable = this.apiService.createRecord(this.viewTemplateEntity, data);
        }
        return observable.pipe(map((response) => {
            return plainToInstance(ViewTemplate, response);
        }), map((newViewTemplate) => {
            newViewTemplate.widgetConfigs = widgetConfigs;
            return newViewTemplate;
        }));
    }
    getNewWidgetConfigs(viewLayoutItem) {
        if (viewLayoutItem instanceof ViewLayoutItem.Widget || viewLayoutItem.type === ViewLayoutItem.Types.WIDGET) {
            let widget = viewLayoutItem;
            if (widget.config && typeof widget.config !== 'string') {
                widget.config.uuid = widget.config.uuid ?? uuidv4();
                const widgetConfig = cloneDeep(widget.config);
                widget.config = widget.config.uuid;
                return [widgetConfig];
            }
            else {
                return [widget.config];
            }
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Container || viewLayoutItem.type === ViewLayoutItem.Types.CONTAINER) {
            return flatten(concat(viewLayoutItem.contents.map((item) => this.getNewWidgetConfigs(item))));
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Tabs || viewLayoutItem.type === ViewLayoutItem.Types.TABS) {
            return flatten(concat(viewLayoutItem.contents.map((item) => this.getNewWidgetConfigs(item))));
        }
        return [];
    }
    navigateToView(params = {}, currentRoute) {
        this.router.navigate(['.'], {
            relativeTo: currentRoute,
            queryParams: params
        });
    }
    duplicate(uuid) {
        return this.loadByUuid(uuid, true).pipe(concatMap((viewTemplate) => {
            let newWidgetConfigs = viewTemplate.widgetConfigs;
            let uuidMap = {};
            newWidgetConfigs.forEach((widgetConfig) => {
                const newUuid = this.utilityService.generateUUID();
                widgetConfig.isNew = true;
                if (widgetConfig.uuid) {
                    uuidMap[widgetConfig.uuid] = newUuid;
                    widgetConfig.uuid = newUuid;
                }
            });
            viewTemplate.layout.forEach((layoutItem) => {
                this.updateLayoutWidgetUuids(layoutItem, uuidMap);
            });
            viewTemplate.title = 'Copy of ' + viewTemplate.title;
            delete viewTemplate.uuid;
            return this.apiService.createRecord(this.viewTemplateEntity, viewTemplate)
                .pipe(concatMap((newViewTemplate) => {
                let observables$ = [];
                newWidgetConfigs.forEach((widgetConfig) => {
                    widgetConfig.viewTemplate = newViewTemplate.uuid;
                    let newWidgetConfig$ = this.apiService.createRecord(this.widgetConfigEntity, widgetConfig);
                    observables$.push(newWidgetConfig$);
                });
                return forkJoin(observables$).pipe(map(() => newViewTemplate));
            }));
        }), map((response) => {
            return plainToInstance(ViewTemplate, response, {
                enableImplicitConversion: true
            });
        }));
    }
    updateLayoutWidgetUuids(viewLayoutItem, uuidMap) {
        if (viewLayoutItem instanceof ViewLayoutItem.Widget || viewLayoutItem.type === ViewLayoutItem.Types.WIDGET) {
            let widget = viewLayoutItem;
            if (widget.config instanceof WidgetConfig && widget.config.uuid) {
                widget.config.uuid = uuidMap[widget.config.uuid];
            }
            else if (isString(widget.config)) {
                const uuid = last(widget.config.split('/'));
                widget.config = uuid ? uuidMap[uuid] : widget.config;
            }
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Container || viewLayoutItem.type === ViewLayoutItem.Types.CONTAINER) {
            let container = viewLayoutItem;
            container.contents.forEach((item) => {
                this.updateLayoutWidgetUuids(item, uuidMap);
            });
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Tabs || viewLayoutItem.type === ViewLayoutItem.Types.TABS) {
            let tabs = viewLayoutItem;
            tabs.contents.forEach((tab) => {
                this.updateLayoutWidgetUuids(tab, uuidMap);
            });
        }
    }
    static { this.ɵfac = function ViewTemplateService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ViewTemplateService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.Router), i0.ɵɵinject(i3.ApiService), i0.ɵɵinject(i3.UtilityService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ViewTemplateService, factory: ViewTemplateService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ViewTemplateService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.Router }, { type: i3.ApiService }, { type: i3.UtilityService }], null); })();
//# sourceMappingURL=data:application/json;base64,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