/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, Input } from '@angular/core';
import { findIndex, flattenDeep } from 'lodash-es';
import { AbstractWidgetEditComponent } from '../../abstract-widget-edit.component';
import { FieldRenderer } from '../field-renderer';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "ngx-drag-drop";
import * as i5 from "@ng-bootstrap/ng-bootstrap";
import * as i6 from "@jsverse/transloco";
function FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r6 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 18)(1, "span", 19);
    i0.ɵɵelement(2, "i", 20);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "div", 21)(5, "div", 22);
    i0.ɵɵelement(6, "i", 23);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(7, "div", 24)(8, "div", 25)(9, "input", 26);
    i0.ɵɵtwoWayListener("ngModelChange", function FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template_input_ngModelChange_9_listener($event) { i0.ɵɵrestoreView(_r6); const field_r7 = i0.ɵɵnextContext().$implicit; i0.ɵɵtwoWayBindingSet(field_r7.readOnly, $event) || (field_r7.readOnly = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(10, "label", 27);
    i0.ɵɵtext(11, " Read-only ");
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(12, "div", 25)(13, "input", 26);
    i0.ɵɵtwoWayListener("ngModelChange", function FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template_input_ngModelChange_13_listener($event) { i0.ɵɵrestoreView(_r6); const field_r7 = i0.ɵɵnextContext().$implicit; i0.ɵɵtwoWayBindingSet(field_r7.hideLabel, $event) || (field_r7.hideLabel = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(14, "label", 27);
    i0.ɵɵtext(15, " Hide Label ");
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(16, "div", 25)(17, "input", 26);
    i0.ɵɵtwoWayListener("ngModelChange", function FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template_input_ngModelChange_17_listener($event) { i0.ɵɵrestoreView(_r6); const field_r7 = i0.ɵɵnextContext().$implicit; i0.ɵɵtwoWayBindingSet(field_r7.showInline, $event) || (field_r7.showInline = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(18, "label", 27);
    i0.ɵɵtext(19, " Show Inline ");
    i0.ɵɵelementEnd()()()();
    i0.ɵɵelementStart(20, "i", 28);
    i0.ɵɵlistener("click", function FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template_i_click_20_listener() { i0.ɵɵrestoreView(_r6); const fieldIndex_r8 = i0.ɵɵnextContext().index; const colIndex_r9 = i0.ɵɵnextContext().index; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.removeField(colIndex_r9, fieldIndex_r8)); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r9 = i0.ɵɵnextContext();
    const field_r7 = ctx_r9.$implicit;
    const fieldIndex_r8 = ctx_r9.index;
    const colIndex_r9 = i0.ɵɵnextContext().index;
    const t_r11 = i0.ɵɵnextContext().$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r11(ctx_r1.entity.fields[field_r7.name].title), " ");
    i0.ɵɵadvance(2);
    i0.ɵɵpropertyInterpolate2("id", "field-dropdown-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵadvance(2);
    i0.ɵɵattribute("aria-labelledby", "field-dropdown-" + colIndex_r9 + "-" + fieldIndex_r8);
    i0.ɵɵadvance(2);
    i0.ɵɵpropertyInterpolate2("id", "field-read-only-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵtwoWayProperty("ngModel", field_r7.readOnly);
    i0.ɵɵadvance();
    i0.ɵɵpropertyInterpolate2("for", "field-read-only-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵadvance(3);
    i0.ɵɵpropertyInterpolate2("id", "field-hide-label-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵtwoWayProperty("ngModel", field_r7.hideLabel);
    i0.ɵɵadvance();
    i0.ɵɵpropertyInterpolate2("for", "field-hide-label-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵadvance(3);
    i0.ɵɵpropertyInterpolate2("id", "field-label-inline-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵtwoWayProperty("ngModel", field_r7.showInline);
    i0.ɵɵadvance();
    i0.ɵɵpropertyInterpolate2("for", "field-label-inline-", colIndex_r9, "-", fieldIndex_r8, "");
} }
function FieldGroupEditComponent_div_0_div_17_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵlistener("dndStart", function FieldGroupEditComponent_div_0_div_17_div_1_Template_div_dndStart_0_listener() { i0.ɵɵrestoreView(_r5); const col_r4 = i0.ɵɵnextContext().$implicit; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.originalColumn = col_r4); });
    i0.ɵɵtemplate(1, FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template, 21, 26, "div", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r7 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("dndDraggable", field_r7);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.entity);
} }
function FieldGroupEditComponent_div_0_div_17_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 11);
    i0.ɵɵlistener("dndDrop", function FieldGroupEditComponent_div_0_div_17_Template_div_dndDrop_0_listener($event) { const col_r4 = i0.ɵɵrestoreView(_r3).$implicit; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.onDrop($event, col_r4)); });
    i0.ɵɵtemplate(1, FieldGroupEditComponent_div_0_div_17_div_1_Template, 2, 2, "div", 12);
    i0.ɵɵelement(2, "div", 13);
    i0.ɵɵelementStart(3, "div", 14)(4, "xf-searchable-dropdown", 15);
    i0.ɵɵlistener("ngModelChange", function FieldGroupEditComponent_div_0_div_17_Template_xf_searchable_dropdown_ngModelChange_4_listener($event) { const colIndex_r9 = i0.ɵɵrestoreView(_r3).index; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.addField(colIndex_r9, $event)); })("searchQueryChange", function FieldGroupEditComponent_div_0_div_17_Template_xf_searchable_dropdown_searchQueryChange_4_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.filterFields($event)); });
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const col_r4 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("dndHorizontal", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", col_r4);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngModel", ctx_r1.field)("clearValueOnSelect", true)("items", ctx_r1.items);
} }
function FieldGroupEditComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div", 1)(2, "label", 2);
    i0.ɵɵtext(3, "Columns");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "select", 3);
    i0.ɵɵlistener("ngModelChange", function FieldGroupEditComponent_div_0_Template_select_ngModelChange_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); ctx_r1.columnCount = $event; return i0.ɵɵresetView(ctx_r1.columnCountChanges($event)); });
    i0.ɵɵelementStart(5, "option", 4);
    i0.ɵɵtext(6, "1-column");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(7, "option", 4);
    i0.ɵɵtext(8, "2-column");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "option", 4);
    i0.ɵɵtext(10, "3-column");
    i0.ɵɵelementEnd()()();
    i0.ɵɵelementStart(11, "div", 5)(12, "label", 6)(13, "input", 7);
    i0.ɵɵtwoWayListener("ngModelChange", function FieldGroupEditComponent_div_0_Template_input_ngModelChange_13_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r1.columnInline, $event) || (ctx_r1.columnInline = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵlistener("ngModelChange", function FieldGroupEditComponent_div_0_Template_input_ngModelChange_13_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.columnInlineToggle()); });
    i0.ɵɵelementEnd();
    i0.ɵɵtext(14, "All Inline ");
    i0.ɵɵelementEnd()();
    i0.ɵɵelement(15, "div", 8);
    i0.ɵɵelementStart(16, "div", 9);
    i0.ɵɵtemplate(17, FieldGroupEditComponent_div_0_div_17_Template, 5, 5, "div", 10);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngModel", ctx_r1.columnCount);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngValue", 1);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngValue", 2);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngValue", 3);
    i0.ɵɵadvance(4);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r1.columnInline);
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngForOf", ctx_r1.widgetConfig.configuration.cols);
} }
export class FieldGroupEditComponent extends AbstractWidgetEditComponent {
    constructor(entityService, changeDetectorRef, utilityService) {
        super(changeDetectorRef, entityService, utilityService);
        this.originalColumn = null;
        this.columnCount = 1;
        this.columnInline = false;
        this.field = null;
    }
    ngOnInit() {
        if (this.context.module) {
            this.entityService.build(this.context.module).subscribe((entity) => {
                this.entity = entity;
                this.widgetConfig.configuration.module = this.widgetConfig.configuration.module || this.entity.type;
                this.widgetConfig.configuration.cols = this.widgetConfig.configuration.cols || [[]];
                this.widgetConfig.configuration.showInline = this.widgetConfig.configuration.showInline || this.columnInline;
                this.columnCount = this.widgetConfig.configuration.cols.length;
                this.columnInline = this.widgetConfig.configuration.showInline;
                this.filterFields('');
                this.changeDetectorRef.detectChanges();
            });
        }
    }
    onChange(col, colIndex) {
        this.widgetConfig.configuration.cols[colIndex] = col;
    }
    onDrop(event, list) {
        if (list && this.originalColumn) {
            // Remove from existing columns
            const foundIndex = findIndex(this.originalColumn, {
                name: event.data.name
            });
            if (foundIndex > -1) {
                this.originalColumn.splice(foundIndex, 1);
                this.originalColumn = null;
            }
            // Add to new column
            let index = event.index;
            if (typeof index === "undefined") {
                index = list.length;
            }
            list.splice(index, 0, event.data);
        }
    }
    onDragStart(col) {
        this.originalColumn = col;
    }
    addField(colIndex, item) {
        if (!item) {
            return;
        }
        this.widgetConfig.configuration.cols[colIndex].push(new FieldRenderer(item.value.name));
    }
    removeField(colIndex, fieldIndex) {
        this.widgetConfig.configuration.cols[colIndex].splice(fieldIndex, 1);
    }
    filterFields(search) {
        const fieldsAlreadyAdded = flattenDeep(this.widgetConfig.configuration.cols.map((col) => col.map((field) => field.name)));
        super.filterFields(search, fieldsAlreadyAdded);
    }
    columnCountChanges(columns) {
        let cols = this.widgetConfig.configuration.cols;
        while (cols.length > columns) {
            const widgets = cols.pop() || [];
            if (widgets.length > 0) {
                cols[cols.length - 1] = cols[cols.length - 1].concat(widgets);
            }
        }
        while (cols.length < columns) {
            cols.push([]);
        }
        this.changeDetectorRef.detectChanges();
    }
    columnInlineToggle() {
        this.widgetConfig.configuration.showInline = this.columnInline;
    }
    static { this.ɵfac = function FieldGroupEditComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldGroupEditComponent)(i0.ɵɵdirectiveInject(i1.EntityService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.UtilityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FieldGroupEditComponent, selectors: [["xf-field-group-edit"]], inputs: { widgetConfig: "widgetConfig" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 0, consts: [[4, "transloco"], [1, "form-group", "d-inline-block"], ["for", "columns", 1, "form-label"], ["id", "columns", "name", "columns", 1, "form-select", "w-auto", 3, "ngModelChange", "ngModel"], [3, "ngValue"], [1, "form-group", "d-inline-block", "margin-left-4px"], ["title", "Enable to show label and field data in one line", 1, "align-self-center", "solid-border-1", "padding-6px", "rounded-3px"], ["type", "checkbox", "id", "section-inline", 1, "form-check-input", "margin-right-8px", 3, "ngModelChange", "ngModel"], [1, "hr", "pt-2", "pb-2"], [1, "row", "edit-cols", "m-0"], ["class", "col pb-2", "dndDropzone", "", "dndEffectAllowed", "copyMove", 3, "dndHorizontal", "dndDrop", 4, "ngFor", "ngForOf"], ["dndDropzone", "", "dndEffectAllowed", "copyMove", 1, "col", "pb-2", 3, "dndDrop", "dndHorizontal"], ["dndEffectAllowed", "move", "class", "card mt-2", 3, "dndDraggable", "dndStart", 4, "ngFor", "ngForOf"], ["dndPlaceholderRef", "", 1, "card", "dnd-placeholder", "mt-2"], [1, "d-flex", "flex-row", "justify-content-left", "gap-2", "mt-2"], ["placeholder", "+ Add Field", 3, "ngModelChange", "searchQueryChange", "ngModel", "clearValueOnSelect", "items"], ["dndEffectAllowed", "move", 1, "card", "mt-2", 3, "dndStart", "dndDraggable"], ["class", "card-title m-0 d-flex", 4, "ngIf"], [1, "card-title", "m-0", "d-flex"], [1, "flex-grow-1"], ["dndHandle", "", 1, "cursor-move", "fa", "fa-arrows-alt", "fa-light", "me-2"], ["ngbDropdown", "", 1, "d-inline-block"], ["role", "button", "ngbDropdownToggle", "", 1, "dropdown-caret-off", "margin-right-16px", 3, "id"], [1, "fa", "fa-ellipsis-v-alt", "fa-light"], ["ngbDropdownMenu", ""], [1, "form-check", "mx-2"], ["type", "checkbox", 1, "form-check-input", 3, "ngModelChange", "ngModel", "id"], [1, "form-check-label", 3, "for"], ["role", "button", 1, "fa", "fa-light", "fa-trash", "margin-top-4px", "text-danger", 3, "click"]], template: function FieldGroupEditComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FieldGroupEditComponent_div_0_Template, 18, 6, "div", 0);
        } }, dependencies: [i2.NgForOf, i2.NgIf, i3.NgSelectOption, i3.ɵNgSelectMultipleOption, i3.CheckboxControlValueAccessor, i3.SelectControlValueAccessor, i3.NgControlStatus, i3.NgModel, i4.DndDraggableDirective, i4.DndDropzoneDirective, i4.DndHandleDirective, i4.DndPlaceholderRefDirective, i5.NgbDropdown, i5.NgbDropdownToggle, i5.NgbDropdownMenu, i1.SearchableDropdownComponent, i6.TranslocoDirective], styles: [".dnd-placeholder[_ngcontent-%COMP%]{height:50px;background:var(--bs-gray-100);border:2px dashed var(--bs-gray-300)}.edit-cols[_ngcontent-%COMP%]{border:1px solid var(--bs-gray-300)}.edit-cols[_ngcontent-%COMP%]   .col[_ngcontent-%COMP%]   .card[_ngcontent-%COMP%]{background-color:#fff;padding:.5rem}.searchable-dropdown[_ngcontent-%COMP%]{max-height:200px;overflow:auto}.bi-three-dots-vertical[_ngcontent-%COMP%]:after{display:none}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldGroupEditComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-group-edit', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div *transloco=\"let t\">\n <div class=\"form-group d-inline-block\">\n  <label for=\"columns\" class=\"form-label\">Columns</label>\n  <select [ngModel]=\"columnCount\" (ngModelChange)=\"columnCount = $event; columnCountChanges($event)\" id=\"columns\" name=\"columns\" class=\"form-select w-auto\">\n    <option [ngValue]=\"1\">1-column</option>\n    <option [ngValue]=\"2\">2-column</option>\n    <option [ngValue]=\"3\">3-column</option>\n  </select>\n</div>\n<div class=\"form-group d-inline-block margin-left-4px\">\n  <label class=\"align-self-center solid-border-1 padding-6px rounded-3px\" title=\"Enable to show label and field data in one line\">\n    <input type=\"checkbox\" class=\"form-check-input margin-right-8px\" id=\"section-inline\" [(ngModel)]=\"columnInline\" (ngModelChange)=\"columnInlineToggle()\" >All Inline </label>\n</div>\n<div class=\"hr pt-2 pb-2\"></div>\n<div class=\"row edit-cols m-0\">\n  <div class=\"col pb-2\" *ngFor=\"let col of widgetConfig.configuration.cols; let colIndex = index\" dndDropzone\n    [dndHorizontal]=\"true\" dndEffectAllowed=\"copyMove\" (dndDrop)=\"onDrop($event, col)\">\n    <div *ngFor=\"let field of col; let fieldIndex = index\" [dndDraggable]=\"field\" dndEffectAllowed=\"move\"\n      (dndStart)=\"originalColumn = col\" class=\"card mt-2\">\n      <div class=\"card-title m-0 d-flex\" *ngIf=\"entity\">\n        <span class=\"flex-grow-1\">\n          <i class=\"cursor-move fa fa-arrows-alt fa-light me-2\" dndHandle></i>{{ t(entity.fields[field.name].title) }}\n        </span>\n        <div ngbDropdown class=\"d-inline-block\">\n          <div role=\"button\" id=\"field-dropdown-{{ colIndex }}-{{ fieldIndex }}\"\n          ngbDropdownToggle class=\"dropdown-caret-off margin-right-16px\">\n            <i class=\"fa fa-ellipsis-v-alt fa-light\"></i>\n          </div>\n          <div ngbDropdownMenu [attr.aria-labelledby]=\"'field-dropdown-' + colIndex + '-' + fieldIndex\">\n            <div class=\"form-check mx-2\">\n              <input class=\"form-check-input\" type=\"checkbox\" [(ngModel)]=\"field.readOnly\"\n                id=\"field-read-only-{{ colIndex }}-{{ fieldIndex }}\">\n              <label class=\"form-check-label\" for=\"field-read-only-{{ colIndex }}-{{ fieldIndex }}\">\n                Read-only\n              </label>\n            </div>\n            <div class=\"form-check mx-2\">\n              <input class=\"form-check-input\" type=\"checkbox\" [(ngModel)]=\"field.hideLabel\"\n                id=\"field-hide-label-{{ colIndex }}-{{ fieldIndex }}\">\n              <label class=\"form-check-label\" for=\"field-hide-label-{{ colIndex }}-{{ fieldIndex }}\">\n                Hide Label\n              </label>\n            </div>\n            <div class=\"form-check mx-2\">\n              <input class=\"form-check-input\" type=\"checkbox\" [(ngModel)]=\"field.showInline\"\n                id=\"field-label-inline-{{ colIndex }}-{{ fieldIndex }}\">\n              <label class=\"form-check-label\" for=\"field-label-inline-{{ colIndex }}-{{ fieldIndex }}\">\n                Show Inline\n              </label>\n            </div>\n          </div>\n        </div>\n        <i class=\"fa fa-light fa-trash margin-top-4px text-danger\" role=\"button\" (click)=\"removeField(colIndex, fieldIndex)\"></i>\n      </div>\n\n    </div>\n    <div class=\"card dnd-placeholder mt-2\" dndPlaceholderRef></div>\n    <div class=\"d-flex flex-row justify-content-left gap-2 mt-2\">\n      <xf-searchable-dropdown (ngModelChange)=\"addField(colIndex, $event)\" [ngModel]=\"field\" [clearValueOnSelect]=\"true\" [items]=\"items\"\n        placeholder=\"+ Add Field\" (searchQueryChange)=\"filterFields($event)\"></xf-searchable-dropdown>\n    </div>\n  </div>\n</div>\n</div>\n", styles: [".dnd-placeholder{height:50px;background:var(--bs-gray-100);border:2px dashed var(--bs-gray-300)}.edit-cols{border:1px solid var(--bs-gray-300)}.edit-cols .col .card{background-color:#fff;padding:.5rem}.searchable-dropdown{max-height:200px;overflow:auto}.bi-three-dots-vertical:after{display:none}\n"] }]
    }], () => [{ type: i1.EntityService }, { type: i0.ChangeDetectorRef }, { type: i1.UtilityService }], { widgetConfig: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FieldGroupEditComponent, { className: "FieldGroupEditComponent", filePath: "src/widgets/field-group/field-group-edit/field-group-edit.component.ts", lineNumber: 22 }); })();
//# sourceMappingURL=data:application/json;base64,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