/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { HttpContext } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';
import { plainToInstance } from 'class-transformer';
import _, { extend } from 'lodash-es';
import { omit } from 'lodash-es';
import { from, of } from 'rxjs';
import { map } from 'rxjs/operators';
import { ALL_RECORDS_SIZE, API, DynamicContent, FIXED_MODULE, HeaderService, IGNORE_ERRORS, StorageService } from "shared";
import builtInWidgetList from './built-in-widget-metadatas.json';
import { FieldGroupConfig } from './field-group/field-group-config';
import { PrimaryDetailConfig } from './primary-detail/primary-detail-config';
import { Widget } from '../models/widget';
import { loadRemoteModule } from '@angular-architects/native-federation';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
export class WidgetService {
    constructor(http) {
        this.http = http;
        this.builtInWidgetConfigs = {
            // 'grid': GridConfig,
            'field-group': FieldGroupConfig,
            'primary-detail': PrimaryDetailConfig
        };
        this.widgets = {};
        this.headerService = inject(HeaderService);
        this.localStorage = inject(StorageService);
        const widgets = plainToInstance(Widget, builtInWidgetList);
        this.builtInWidgets = _.keyBy(widgets, 'name');
    }
    loadWidget(name, force = false) {
        this.widgets = extend(this.widgets, this.builtInWidgets);
        if (!this.widgets[name] || force) {
            return this.loadWidgets(name).pipe(map(() => {
                return this.widgets[name];
            }));
        }
        return of(this.widgets[name]);
    }
    getWidgetById(widgets, id) {
        Object.keys(widgets).forEach((widget) => {
            if (widget.uuid === id) {
                return widget;
            }
        });
    }
    getWidget(name, version) {
        return this.http.get(`${API.API_APPMANAGER}widget/${name}/${version}`, {
            context: new HttpContext().set(IGNORE_ERRORS, true)
        });
    }
    loadDynamicContent(name, type) {
        return this.http.get(API.BASE + FIXED_MODULE.DYNAMIC_CONTENT, {
            params: {
                limit: ALL_RECORDS_SIZE,
                type: type,
                name: name
            }
        }).pipe(map((response) => {
            if (!response['hydra:member'].length) {
                return null;
            }
            return plainToInstance(DynamicContent, response['hydra:member'][0]);
        }));
    }
    loadWidgets(name) {
        return this.getWidget(name, null).pipe(map((response) => {
            const widgets = plainToInstance(Widget, response);
            this.widgets = _.keyBy(widgets, 'name');
            this.widgets = extend(this.widgets, this.builtInWidgets);
            return this.widgets;
        }));
    }
    getRemoteConfig(widget) {
        if (!widget.className) {
            return of();
        }
        const options = {
            remoteEntry: '/widgets/' + widget.name + '/remoteEntry.json',
            exposedModule: widget.exposedModule || './Config',
            className: widget.className
        };
        const component$ = from(loadRemoteModule(options));
        return component$.pipe(map((exposedModules) => {
            const widgetConfigType = exposedModules[options.className];
            return widgetConfigType;
        }));
    }
    castAsWidgetConfig(object, widget) {
        const foundType = this.builtInWidgetConfigs[object.type];
        const excludedKeys = ['@id', '@context'];
        object = omit(object, excludedKeys);
        if (foundType) {
            const instance = plainToInstance(foundType, object);
            return of(instance);
        }
        else {
            return this.getRemoteConfig(widget).pipe(map((widgetConfigType) => plainToInstance(widgetConfigType, object)));
        }
    }
    static { this.ɵfac = function WidgetService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WidgetService)(i0.ɵɵinject(i1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: WidgetService, factory: WidgetService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WidgetService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }], null); })();
//# sourceMappingURL=data:application/json;base64,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