import { ChangeDetectionStrategy, Component, EventEmitter, Input, Optional, Output, ViewChild, ViewContainerRef } from '@angular/core';
import { cloneDeep, isUndefined } from 'lodash-es';
import { DndDraggableDirective, DndHandleDirective } from 'ngx-drag-drop';
import { concatMap, filter, map, of, tap } from 'rxjs';
import { API, Entity, FIXED_MODULE } from "shared";
import { Query } from "shared";
import { EditWidgetComponent } from '../../view-template/edit-widget/edit-widget.component';
import { WidgetConfig } from '../../models/widget-config';
import * as i0 from "@angular/core";
import * as i1 from "../widget.service";
import * as i2 from "@angular/common/http";
import * as i3 from "shared";
import * as i4 from "@ng-bootstrap/ng-bootstrap";
import * as i5 from "ngx-drag-drop";
import * as i6 from "@angular/common";
const _c0 = ["widgetHolder"];
const _c1 = (a0, a1) => [a0, a1];
const _c2 = a0 => ({ "card-body p-0": a0 });
function WidgetComponent_div_0_div_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 13);
} }
function WidgetComponent_div_0_div_1_div_6_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 19);
    i0.ɵɵlistener("click", function WidgetComponent_div_0_div_1_div_6_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r2 = i0.ɵɵnextContext(4); return i0.ɵɵresetView(ctx_r2.clone.emit(ctx_r2.widgetConfig)); });
    i0.ɵɵelement(1, "i", 20);
    i0.ɵɵelementEnd();
} }
function WidgetComponent_div_0_div_1_div_6_button_2_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 21);
    i0.ɵɵlistener("click", function WidgetComponent_div_0_div_1_div_6_button_2_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(4); return i0.ɵɵresetView(ctx_r2.delete.emit(ctx_r2.widgetConfig)); });
    i0.ɵɵelement(1, "i", 22);
    i0.ɵɵelementEnd();
} }
function WidgetComponent_div_0_div_1_div_6_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵtemplate(1, WidgetComponent_div_0_div_1_div_6_button_1_Template, 2, 0, "button", 15)(2, WidgetComponent_div_0_div_1_div_6_button_2_Template, 2, 0, "button", 16);
    i0.ɵɵelementStart(3, "button", 17);
    i0.ɵɵlistener("click", function WidgetComponent_div_0_div_1_div_6_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r1); const ctx_r2 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r2.openEditModal()); });
    i0.ɵɵelement(4, "i", 18);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.showLayoutControls);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.showLayoutControls);
} }
function WidgetComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 7)(1, "div", 8)(2, "div", 9);
    i0.ɵɵtemplate(3, WidgetComponent_div_0_div_1_span_3_Template, 1, 0, "span", 10);
    i0.ɵɵelementStart(4, "h5", 11);
    i0.ɵɵtext(5);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(6, WidgetComponent_div_0_div_1_div_6_Template, 5, 2, "div", 12);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r2.mode === "edit" && ctx_r2.showLayoutControls);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.title);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.mode !== "view");
} }
function WidgetComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵtemplate(1, WidgetComponent_div_0_div_1_Template, 7, 3, "div", 4);
    i0.ɵɵelementStart(2, "div", 5);
    i0.ɵɵelement(3, "div", 6)(4, "div", null, 0);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵclassMapInterpolate1("", ctx_r2.widgetClass, " transitions-bottom-linear widget");
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(6, _c1, (ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.showBorder) || ctx_r2.mode !== "view" ? "card" : "no-border", ctx_r2.mode === "edit" ? "editing" : ""));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.showBorder) && (ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.title) !== "" || ctx_r2.mode === "edit");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(9, _c2, ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.showBorder));
} }
function WidgetComponent_div_1_a_4_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "a", 27);
    i0.ɵɵlistener("click", function WidgetComponent_div_1_a_4_Template_a_click_0_listener() { i0.ɵɵrestoreView(_r5); const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.logExpanded = !ctx_r2.logExpanded); });
    i0.ɵɵtext(1, "Show Build Log");
    i0.ɵɵelementEnd();
} }
function WidgetComponent_div_1_pre_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "pre", 28);
    i0.ɵɵtext(1, "        ");
    i0.ɵɵelement(2, "div", 29);
    i0.ɵɵtext(3, "\n      ");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("innerHTML", ctx_r2.buildLogHtml, i0.ɵɵsanitizeHtml);
} }
function WidgetComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "div", 7)(2, "div", 23);
    i0.ɵɵtext(3);
    i0.ɵɵtemplate(4, WidgetComponent_div_1_a_4_Template, 2, 0, "a", 24)(5, WidgetComponent_div_1_pre_5_Template, 4, 1, "pre", 25);
    i0.ɵɵelement(6, "i", 26);
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1(" The widget \"", ctx_r2.widget == null ? null : ctx_r2.widget.name, "\" is publishing. ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.widgetPermission.indexOf("update") > -1);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.widgetPermission.indexOf("update") > -1 && ctx_r2.logExpanded);
} }
function WidgetComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r6 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div", 7)(2, "div", 23);
    i0.ɵɵtext(3);
    i0.ɵɵelementStart(4, "a", 30);
    i0.ɵɵlistener("click", function WidgetComponent_div_2_Template_a_click_4_listener() { i0.ɵɵrestoreView(_r6); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.reload()); });
    i0.ɵɵtext(5, "Refresh page");
    i0.ɵɵelementEnd();
    i0.ɵɵtext(6, " to see changes. ");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1(" There is an updated version of the \"", ctx_r2.widget == null ? null : ctx_r2.widget.name, "\" widget available. ");
} }
export class WidgetComponent {
    constructor(widgetService, http, dataProvider, ngbModalService, permissionService, changeDetectorRef, entityService, apiService, parentDraggable, embedService) {
        this.widgetService = widgetService;
        this.http = http;
        this.dataProvider = dataProvider;
        this.ngbModalService = ngbModalService;
        this.permissionService = permissionService;
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.apiService = apiService;
        this.parentDraggable = parentDraggable;
        this.embedService = embedService;
        this.edit = new EventEmitter();
        this.clone = new EventEmitter();
        this.delete = new EventEmitter();
        this.showLayoutControls = false;
        this.showMenu = false;
        this.widgetPermission = [];
        this.logExpanded = false;
        this.buildLogHtml = '';
        this.reloadRequired = false;
    }
    ngOnInit() {
        this.widgetPermission = this.permissionService.getPermission(FIXED_MODULE.DYNAMIC_CONTENT);
    }
    ngAfterViewInit() {
        if (this.parentDraggable) {
            this.parentDraggable.registerDragHandle(this.dndHandle);
        }
    }
    ngOnChanges(changes) {
        if (changes.config && this.config) {
            this.subscription?.unsubscribe();
            this.setConfig().subscribe(() => {
                if (this.widgetConfig) {
                    this.componentRef.instance.widgetConfigChanged(this.widgetConfig);
                }
            });
        }
        else if (changes.mode && this.componentRef) {
            this.componentRef.instance.mode = this.mode;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
        else if (changes.context) {
            this.componentRef.instance.contextChanged(changes.context.currentValue);
        }
    }
    createWidgetComponent(widgetConfig) {
        this.viewContainer.clear();
        this.componentRef = this.viewContainer.createComponent(widgetConfig.viewComponent);
        this.componentRef.instance.widgetConfig = widgetConfig;
        this.componentRef.instance.mode = this.mode;
        this.componentRef.instance.widgetId = this.widgetId;
        this.componentRef.instance.updateHeight = this.updateHeight;
        this.componentRef.instance.context = this.context;
        this.changeDetectorRef.detectChanges();
    }
    watchMetadataChanges(widgetUuid) {
        let query = new Query({
            selectedFields: ['buildLog', 'publishing']
        });
        return this.entityService.build(FIXED_MODULE.DYNAMIC_CONTENT).pipe(concatMap((entity) => {
            return this.dataProvider.observe(entity, widgetUuid, undefined, query).pipe(tap((entityChange) => {
                if (!this.widget) {
                    return;
                }
                this.widget.publishing = entityChange.entity.values.publishing;
                this.widget.buildLog = entityChange.entity.values.buildLog;
                if (this.widget.publishing) {
                    this.reloadRequired = true;
                }
                this.setBuildLogHtml();
                this.changeDetectorRef.detectChanges();
            }), filter((entityChange) => {
                return !isUndefined(entityChange.entity.values.publishing) && !entityChange.entity.values.publishing;
            }));
        }));
    }
    getConfig(configUuid) {
        // TODO: Add widget-configs mmd
        let widgetConfigEntity = new Entity(FIXED_MODULE.WIDGET_CONFIGS);
        widgetConfigEntity.baseUrl = API.API_APPMANAGER;
        return this.apiService.getRecord(widgetConfigEntity, configUuid, WidgetConfig);
    }
    setConfig() {
        let getWidgetConfig$;
        getWidgetConfig$ = of('');
        return getWidgetConfig$.pipe(concatMap(() => this.widgetService.castAsWidgetConfig(this.config, this.widgetData).pipe(map((widgetConfig) => {
            this.widgetConfig = widgetConfig;
            this.changeDetectorRef.detectChanges();
            return this.createWidgetComponent(widgetConfig);
        }))));
    }
    setBuildLogHtml() {
        this.buildLogHtml = this.widget?.buildLog?.replace(/\\n/g, '<br>') || '';
    }
    ngOnDestroy() {
        this.subscription?.unsubscribe();
    }
    openEditModal() {
        if (!this.widgetConfig) {
            return;
        }
        let modalRef = this.ngbModalService.open(EditWidgetComponent, {
            backdrop: 'static',
            windowClass: 'modal-xlarge'
        });
        modalRef.componentInstance.widgetConfig = cloneDeep(this.widgetConfig);
        modalRef.componentInstance.context = this.context;
        modalRef.closed.subscribe((widgetConfig) => {
            this.edit.emit(widgetConfig);
            this.widgetConfig = widgetConfig;
            this.componentRef.instance.widgetConfig = widgetConfig;
            this.componentRef.instance.widgetConfigChanged(widgetConfig);
        });
    }
    reload() {
        location.reload();
    }
    static { this.ɵfac = function WidgetComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WidgetComponent)(i0.ɵɵdirectiveInject(i1.WidgetService), i0.ɵɵdirectiveInject(i2.HttpClient), i0.ɵɵdirectiveInject(i3.DataProviderService), i0.ɵɵdirectiveInject(i4.NgbModal), i0.ɵɵdirectiveInject(i3.PermissionService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i3.EntityService), i0.ɵɵdirectiveInject(i3.ApiService), i0.ɵɵdirectiveInject(i5.DndDraggableDirective, 8), i0.ɵɵdirectiveInject(i3.EmbedService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: WidgetComponent, selectors: [["xf-widget"]], viewQuery: function WidgetComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5, ViewContainerRef);
            i0.ɵɵviewQuery(DndHandleDirective, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.viewContainer = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dndHandle = _t.first);
        } }, inputs: { config: "config", widgetData: "widgetData", context: "context", mode: "mode", widgetClass: "widgetClass", showLayoutControls: "showLayoutControls", updateHeight: "updateHeight", widgetId: "widgetId" }, outputs: { edit: "edit", clone: "clone", delete: "delete" }, features: [i0.ɵɵProvidersFeature([DndDraggableDirective]), i0.ɵɵNgOnChangesFeature], decls: 3, vars: 3, consts: [["widgetHolder", ""], [3, "class", "ngClass", 4, "ngIf"], [4, "ngIf"], [3, "ngClass"], ["class", "card-header", 4, "ngIf"], [1, "", 3, "ngClass"], [1, "card-overlay"], [1, "card-header"], [1, "row"], [1, "col", "d-flex"], ["class", "fa fa-grip-horizontal fa-light align-self-center cursor-move margin-right-8px", "role", "grab", "dndHandle", "", 4, "ngIf"], [1, "pt-2", "pb-2", "mb-0", "container-title-font"], ["class", "col d-flex justify-content-end gap-2", 4, "ngIf"], ["role", "grab", "dndHandle", "", 1, "fa", "fa-grip-horizontal", "fa-light", "align-self-center", "cursor-move", "margin-right-8px"], [1, "col", "d-flex", "justify-content-end", "gap-2"], ["class", "btn btn-secondary btn-xs", 3, "click", 4, "ngIf"], ["type", "button", "class", "btn btn-danger btn-xs", 3, "click", 4, "ngIf"], ["type", "button", 1, "btn", "btn-primary", "btn-xs", 3, "click"], [1, "fa-light", "fa", "fa-pencil"], [1, "btn", "btn-secondary", "btn-xs", 3, "click"], [1, "fa", "fa-clone"], ["type", "button", 1, "btn", "btn-danger", "btn-xs", 3, "click"], [1, "fa-light", "fa", "fa-trash"], [1, "alert", "alert-warning"], ["class", "btn btn-link", 3, "click", 4, "ngIf"], ["class", "import-log", 4, "ngIf"], [1, "fa", "fa-spin", "fa-spinner"], [1, "btn", "btn-link", 3, "click"], [1, "import-log"], [3, "innerHTML"], ["href", ".", 1, "btn", "btn-link", "d-inline", 3, "click"]], template: function WidgetComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, WidgetComponent_div_0_Template, 6, 11, "div", 1)(1, WidgetComponent_div_1_Template, 7, 3, "div", 2)(2, WidgetComponent_div_2_Template, 7, 1, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !(ctx.widget == null ? null : ctx.widget.publishing) && !ctx.reloadRequired);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.widget == null ? null : ctx.widget.publishing);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !(ctx.widget == null ? null : ctx.widget.publishing) && ctx.reloadRequired);
        } }, dependencies: [i6.NgClass, i6.NgIf, i5.DndHandleDirective], styles: [".widget[_ngcontent-%COMP%]   .card[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]{visibility:hidden}.widget[_ngcontent-%COMP%]   .card[_ngcontent-%COMP%]:hover   .menu[_ngcontent-%COMP%]{visibility:visible}.widget[_ngcontent-%COMP%]   .editing[_ngcontent-%COMP%]   .card-body[_ngcontent-%COMP%]{max-height:200px;position:relative;overflow:hidden}.widget[_ngcontent-%COMP%]   .editing[_ngcontent-%COMP%]   .card-body[_ngcontent-%COMP%]   .card-overlay[_ngcontent-%COMP%]{position:absolute;top:0;left:0;width:100%;height:200px;z-index:2;background-color:#fff0;background-image:linear-gradient(rgba(255,255,255,0),rgba(255,255,255,0) 100px,var(--card-header-bg-color));background-repeat:no-repeat}.widget[_ngcontent-%COMP%]   .dropdown-toggle[_ngcontent-%COMP%]:after{display:none}.widget[_ngcontent-%COMP%]   pre[_ngcontent-%COMP%]{white-space:pre-wrap;max-width:500px}.no-border[_ngcontent-%COMP%]{background-color:var(--card-bg-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WidgetComponent, [{
        type: Component,
        args: [{ selector: 'xf-widget', providers: [DndDraggableDirective], changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"{{widgetClass}} transitions-bottom-linear widget\"\n  [ngClass]=\"[(widgetConfig?.showBorder || mode !== 'view') ? 'card': 'no-border', mode === 'edit' ? 'editing': '']\"\n  *ngIf=\"!widget?.publishing && !reloadRequired\">\n  <div class=\"card-header\" *ngIf=\"(widgetConfig?.showBorder && widgetConfig?.title !== '') || mode === 'edit'\">\n    <div class=\"row\">\n      <div class=\"col d-flex\">\n        <span *ngIf=\"mode === 'edit' && showLayoutControls\"\n          class=\"fa fa-grip-horizontal fa-light align-self-center cursor-move margin-right-8px\" role=\"grab\"\n          dndHandle></span>\n        <h5 class=\"pt-2 pb-2 mb-0 container-title-font\">{{ widgetConfig?.title }}</h5>\n      </div>\n      <div class=\"col d-flex justify-content-end gap-2\" *ngIf=\"mode !== 'view'\">\n        <button class=\"btn btn-secondary btn-xs\" (click)=\"clone.emit(widgetConfig)\" *ngIf=\"showLayoutControls\">\n          <i class=\"fa fa-clone\"></i>\n        </button>\n        <button type=\"button\" class=\"btn btn-danger btn-xs\" *ngIf=\"showLayoutControls\"\n          (click)=\"delete.emit(widgetConfig)\">\n          <i class=\"fa-light fa fa-trash\"></i>\n        </button>\n        <button type=\"button\" class=\"btn btn-primary btn-xs\" (click)=\"openEditModal()\">\n          <i class=\"fa-light fa fa-pencil\"></i>\n        </button>\n      </div>\n    </div>\n  </div>\n  <div class=\"\" [ngClass]=\"{'card-body p-0': widgetConfig?.showBorder}\">\n    <div class=\"card-overlay\"></div>\n    <div #widgetHolder></div>\n  </div>\n</div>\n<div *ngIf=\"widget?.publishing\">\n  <div class=\"card-header\">\n    <div class=\"alert alert-warning\">\n      The widget \"{{ widget?.name }}\" is publishing.\n      <a class=\"btn btn-link\" (click)=\"logExpanded = !logExpanded\" *ngIf=\"widgetPermission.indexOf('update') > -1\">Show Build Log</a>\n      <pre class=\"import-log\" *ngIf=\"widgetPermission.indexOf('update') > -1 && logExpanded\">\n        <div [innerHTML]=\"buildLogHtml\"></div>\n      </pre>\n      <i class=\"fa fa-spin fa-spinner\"></i>\n    </div>\n  </div>\n</div>\n<div *ngIf=\"!widget?.publishing && reloadRequired\">\n  <div class=\"card-header\">\n    <div class=\"alert alert-warning\">\n      There is an updated version of the \"{{ widget?.name }}\" widget available.\n      <a (click)=\"reload()\" href=\".\" class=\"btn btn-link d-inline\">Refresh page</a> to see changes.\n    </div>\n  </div>\n</div>\n", styles: [".widget .card .menu{visibility:hidden}.widget .card:hover .menu{visibility:visible}.widget .editing .card-body{max-height:200px;position:relative;overflow:hidden}.widget .editing .card-body .card-overlay{position:absolute;top:0;left:0;width:100%;height:200px;z-index:2;background-color:#fff0;background-image:linear-gradient(rgba(255,255,255,0),rgba(255,255,255,0) 100px,var(--card-header-bg-color));background-repeat:no-repeat}.widget .dropdown-toggle:after{display:none}.widget pre{white-space:pre-wrap;max-width:500px}.no-border{background-color:var(--card-bg-color)}\n"] }]
    }], () => [{ type: i1.WidgetService }, { type: i2.HttpClient }, { type: i3.DataProviderService }, { type: i4.NgbModal }, { type: i3.PermissionService }, { type: i0.ChangeDetectorRef }, { type: i3.EntityService }, { type: i3.ApiService }, { type: i5.DndDraggableDirective, decorators: [{
                type: Optional
            }] }, { type: i3.EmbedService }], { config: [{
            type: Input
        }], widgetData: [{
            type: Input
        }], context: [{
            type: Input
        }], edit: [{
            type: Output
        }], clone: [{
            type: Output
        }], delete: [{
            type: Output
        }], mode: [{
            type: Input
        }], widgetClass: [{
            type: Input
        }], showLayoutControls: [{
            type: Input
        }], updateHeight: [{
            type: Input
        }], widgetId: [{
            type: Input
        }], viewContainer: [{
            type: ViewChild,
            args: ['widgetHolder', { read: ViewContainerRef }]
        }], dndHandle: [{
            type: ViewChild,
            args: [DndHandleDirective]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(WidgetComponent, { className: "WidgetComponent", filePath: "src/widgets/widget/widget.component.ts", lineNumber: 29 }); })();
//# sourceMappingURL=data:application/json;base64,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