import { ChangeDetectorRef } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { Router } from '@angular/router';
import { DndDropEvent } from 'ngx-drag-drop';
import { Observable } from 'rxjs';
import { Entity, EntityService, Field, FilterGroup, ModelMetadata, ModelMetadataService, PlaybookService, Query, SearchableItem, UtilityService } from "shared";
import { AbstractWidgetEditComponent } from 'shared/view-templates';
import { GridConfig } from '../grid-config';
import { GridColumnService } from '../../../services/grid-column.service';
import * as i0 from "@angular/core";
export declare class GridEditComponent extends AbstractWidgetEditComponent {
    private modelMetadataService;
    private playbookService;
    private router;
    private gridColumnService;
    widgetConfig: GridConfig;
    modules: ModelMetadata[];
    relatedModules: ModelMetadata[];
    selectedEntity?: Entity;
    formGroup: FormGroup;
    query: Query;
    actionPlaybook: SearchableItem | null;
    fields: Record<string, Field>;
    actionPlaybookList: any[];
    private actionPBList;
    isDetailPage: boolean;
    constructor(changeDetectorRef: ChangeDetectorRef, entityService: EntityService, modelMetadataService: ModelMetadataService, formBuilder: FormBuilder, playbookService: PlaybookService, router: Router, utilityService: UtilityService, gridColumnService: GridColumnService);
    ngOnInit(): void;
    moduleChanged(module: string): void;
    queryChange(filterGroup: FilterGroup | null): void;
    initWidgetConfig(entity?: Entity): Observable<any>;
    rowExpansionChange(event: any): void;
    lightModeChange(event: any): void;
    private setFields;
    private setColumns;
    private getActionPlaybooks;
    onActionsDrop(event: DndDropEvent): void;
    addActionPlaybook(event: SearchableItem | null): void;
    removeActionPlaybook(index: number): void;
    filterActionPlaybooks(search: string): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<GridEditComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<GridEditComponent, "xf-grid-edit", never, { "widgetConfig": { "alias": "widgetConfig"; "required": false; }; }, {}, never, never, false, never>;
}
